<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryMethodDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryMethodDescription
 * @subpackage Structs
 */
class DeliveryMethodDescription extends AbstractStructBase
{
    /**
     * The AddressRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AddressRequired;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * The PricingEntry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DeliveryPricingDescription
     */
    public $PricingEntry;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageId;
    /**
     * Constructor method for DeliveryMethodDescription
     * @uses DeliveryMethodDescription::setAddressRequired()
     * @uses DeliveryMethodDescription::setDescription()
     * @uses DeliveryMethodDescription::setId()
     * @uses DeliveryMethodDescription::setLocalId()
     * @uses DeliveryMethodDescription::setName()
     * @uses DeliveryMethodDescription::setOrdinal()
     * @uses DeliveryMethodDescription::setPricingEntry()
     * @uses DeliveryMethodDescription::setImageId()
     * @param bool $addressRequired
     * @param \patest\StructType\GlobalString $description
     * @param string $id
     * @param int $localId
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param \patest\StructType\DeliveryPricingDescription $pricingEntry
     * @param int $imageId
     */
    public function __construct($addressRequired = null, \patest\StructType\GlobalString $description = null, $id = null, $localId = null, \patest\StructType\GlobalString $name = null, $ordinal = null, \patest\StructType\DeliveryPricingDescription $pricingEntry = null, $imageId = null)
    {
        $this
            ->setAddressRequired($addressRequired)
            ->setDescription($description)
            ->setId($id)
            ->setLocalId($localId)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setPricingEntry($pricingEntry)
            ->setImageId($imageId);
    }
    /**
     * Get AddressRequired value
     * @return bool|null
     */
    public function getAddressRequired()
    {
        return $this->AddressRequired;
    }
    /**
     * Set AddressRequired value
     * @param bool $addressRequired
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setAddressRequired($addressRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRequired) && !is_bool($addressRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressRequired, true), gettype($addressRequired)), __LINE__);
        }
        $this->AddressRequired = $addressRequired;
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
    /**
     * Get PricingEntry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DeliveryPricingDescription|null
     */
    public function getPricingEntry()
    {
        return isset($this->PricingEntry) ? $this->PricingEntry : null;
    }
    /**
     * Set PricingEntry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DeliveryPricingDescription $pricingEntry
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setPricingEntry(\patest\StructType\DeliveryPricingDescription $pricingEntry = null)
    {
        if (is_null($pricingEntry) || (is_array($pricingEntry) && empty($pricingEntry))) {
            unset($this->PricingEntry);
        } else {
            $this->PricingEntry = $pricingEntry;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageId()
    {
        return isset($this->ImageId) ? $this->ImageId : null;
    }
    /**
     * Set ImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageId
     * @return \patest\StructType\DeliveryMethodDescription
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: int
        if (!is_null($imageId) && !(is_int($imageId) || ctype_digit($imageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        if (is_null($imageId) || (is_array($imageId) && empty($imageId))) {
            unset($this->ImageId);
        } else {
            $this->ImageId = $imageId;
        }
        return $this;
    }
}
