<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryItem
 * @subpackage Structs
 */
class DeliveryItem extends AbstractProductItem
{
    /**
     * The AddressDetailId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddressDetailId;
    /**
     * The DeliveryClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryClientId;
    /**
     * The DeliveryMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryMethodId;
    /**
     * The Instructions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Instructions;
    /**
     * Constructor method for DeliveryItem
     * @uses DeliveryItem::setAddressDetailId()
     * @uses DeliveryItem::setDeliveryClientId()
     * @uses DeliveryItem::setDeliveryMethodId()
     * @uses DeliveryItem::setInstructions()
     * @param string $addressDetailId
     * @param string $deliveryClientId
     * @param string $deliveryMethodId
     * @param string $instructions
     */
    public function __construct($addressDetailId = null, $deliveryClientId = null, $deliveryMethodId = null, $instructions = null)
    {
        $this
            ->setAddressDetailId($addressDetailId)
            ->setDeliveryClientId($deliveryClientId)
            ->setDeliveryMethodId($deliveryMethodId)
            ->setInstructions($instructions);
    }
    /**
     * Get AddressDetailId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressDetailId()
    {
        return isset($this->AddressDetailId) ? $this->AddressDetailId : null;
    }
    /**
     * Set AddressDetailId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressDetailId
     * @return \patest\StructType\DeliveryItem
     */
    public function setAddressDetailId($addressDetailId = null)
    {
        // validation for constraint: string
        if (!is_null($addressDetailId) && !is_string($addressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressDetailId, true), gettype($addressDetailId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addressDetailId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addressDetailId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addressDetailId, true)), __LINE__);
        }
        if (is_null($addressDetailId) || (is_array($addressDetailId) && empty($addressDetailId))) {
            unset($this->AddressDetailId);
        } else {
            $this->AddressDetailId = $addressDetailId;
        }
        return $this;
    }
    /**
     * Get DeliveryClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryClientId()
    {
        return isset($this->DeliveryClientId) ? $this->DeliveryClientId : null;
    }
    /**
     * Set DeliveryClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryClientId
     * @return \patest\StructType\DeliveryItem
     */
    public function setDeliveryClientId($deliveryClientId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryClientId) && !is_string($deliveryClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryClientId, true), gettype($deliveryClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryClientId, true)), __LINE__);
        }
        if (is_null($deliveryClientId) || (is_array($deliveryClientId) && empty($deliveryClientId))) {
            unset($this->DeliveryClientId);
        } else {
            $this->DeliveryClientId = $deliveryClientId;
        }
        return $this;
    }
    /**
     * Get DeliveryMethodId value
     * @return string|null
     */
    public function getDeliveryMethodId()
    {
        return $this->DeliveryMethodId;
    }
    /**
     * Set DeliveryMethodId value
     * @param string $deliveryMethodId
     * @return \patest\StructType\DeliveryItem
     */
    public function setDeliveryMethodId($deliveryMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryMethodId) && !is_string($deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryMethodId, true), gettype($deliveryMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryMethodId, true)), __LINE__);
        }
        $this->DeliveryMethodId = $deliveryMethodId;
        return $this;
    }
    /**
     * Get Instructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstructions()
    {
        return isset($this->Instructions) ? $this->Instructions : null;
    }
    /**
     * Set Instructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instructions
     * @return \patest\StructType\DeliveryItem
     */
    public function setInstructions($instructions = null)
    {
        // validation for constraint: string
        if (!is_null($instructions) && !is_string($instructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructions, true), gettype($instructions)), __LINE__);
        }
        if (is_null($instructions) || (is_array($instructions) && empty($instructions))) {
            unset($this->Instructions);
        } else {
            $this->Instructions = $instructions;
        }
        return $this;
    }
}
