<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeductionDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeductionDetail
 * @subpackage Structs
 */
class DeductionDetail extends AbstractStructBase
{
    /**
     * The DeductionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DeductionAmount;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemType;
    /**
     * Constructor method for DeductionDetail
     * @uses DeductionDetail::setDeductionAmount()
     * @uses DeductionDetail::setItemId()
     * @uses DeductionDetail::setItemType()
     * @param \patest\StructType\Money $deductionAmount
     * @param string $itemId
     * @param string $itemType
     */
    public function __construct(\patest\StructType\Money $deductionAmount = null, $itemId = null, $itemType = null)
    {
        $this
            ->setDeductionAmount($deductionAmount)
            ->setItemId($itemId)
            ->setItemType($itemType);
    }
    /**
     * Get DeductionAmount value
     * @return \patest\StructType\Money|null
     */
    public function getDeductionAmount()
    {
        return $this->DeductionAmount;
    }
    /**
     * Set DeductionAmount value
     * @param \patest\StructType\Money $deductionAmount
     * @return \patest\StructType\DeductionDetail
     */
    public function setDeductionAmount(\patest\StructType\Money $deductionAmount = null)
    {
        $this->DeductionAmount = $deductionAmount;
        return $this;
    }
    /**
     * Get ItemId value
     * @return string|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param string $itemId
     * @return \patest\StructType\DeductionDetail
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @uses \patest\EnumType\DeductionItemKind::valueIsValid()
     * @uses \patest\EnumType\DeductionItemKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \patest\StructType\DeductionDetail
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DeductionItemKind::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DeductionItemKind', is_array($itemType) ? implode(', ', $itemType) : var_export($itemType, true), implode(', ', \patest\EnumType\DeductionItemKind::getValidValues())), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
}
