<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeactivateCodeStatus-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DeactivateCodeStatus-Request
 * @subpackage Structs
 */
class DeactivateCodeStatus_Request extends ExtensibleDataContract
{
    /**
     * The JobId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $JobId;
    /**
     * Constructor method for DeactivateCodeStatus-Request
     * @uses DeactivateCodeStatus_Request::setJobId()
     * @param string $jobId
     */
    public function __construct($jobId = null)
    {
        $this
            ->setJobId($jobId);
    }
    /**
     * Get JobId value
     * @return string|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param string $jobId
     * @return \patest\StructType\DeactivateCodeStatus_Request
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: string
        if (!is_null($jobId) && !is_string($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jobId, true), gettype($jobId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($jobId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($jobId, true)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
}
