<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomService StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomService
 * @subpackage Structs
 */
class CustomService extends Service
{
    /**
     * The ServiceCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceCategoryId;
    /**
     * Constructor method for CustomService
     * @uses CustomService::setServiceCategoryId()
     * @param string $serviceCategoryId
     */
    public function __construct($serviceCategoryId = null)
    {
        $this
            ->setServiceCategoryId($serviceCategoryId);
    }
    /**
     * Get ServiceCategoryId value
     * @return string|null
     */
    public function getServiceCategoryId()
    {
        return $this->ServiceCategoryId;
    }
    /**
     * Set ServiceCategoryId value
     * @param string $serviceCategoryId
     * @return \patest\StructType\CustomService
     */
    public function setServiceCategoryId($serviceCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceCategoryId) && !is_string($serviceCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceCategoryId, true), gettype($serviceCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceCategoryId, true)), __LINE__);
        }
        $this->ServiceCategoryId = $serviceCategoryId;
        return $this;
    }
}
