<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomSeatPrice StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomSeatPrice
 * @subpackage Structs
 */
class CustomSeatPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * Constructor method for CustomSeatPrice
     * @uses CustomSeatPrice::setPrice()
     * @uses CustomSeatPrice::setSeatIdInAreaMap()
     * @param \patest\StructType\Money $price
     * @param int $seatIdInAreaMap
     */
    public function __construct(\patest\StructType\Money $price = null, $seatIdInAreaMap = null)
    {
        $this
            ->setPrice($price)
            ->setSeatIdInAreaMap($seatIdInAreaMap);
    }
    /**
     * Get Price value
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\CustomSeatPrice
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return $this->SeatIdInAreaMap;
    }
    /**
     * Set SeatIdInAreaMap value
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\CustomSeatPrice
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        $this->SeatIdInAreaMap = $seatIdInAreaMap;
        return $this;
    }
}
