<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.TicketSchemeEnrollmentOption StructType
 * @subpackage Structs
 */
class Crm_TicketSchemeEnrollmentOption extends PersistableEntity
{
    /**
     * The EnrollmentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollmentOption;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * Constructor method for Crm.TicketSchemeEnrollmentOption
     * @uses Crm_TicketSchemeEnrollmentOption::setEnrollmentOption()
     * @uses Crm_TicketSchemeEnrollmentOption::setSeriesId()
     * @uses Crm_TicketSchemeEnrollmentOption::setTicketSchemeId()
     * @param string $enrollmentOption
     * @param string $seriesId
     * @param string $ticketSchemeId
     */
    public function __construct($enrollmentOption = null, $seriesId = null, $ticketSchemeId = null)
    {
        $this
            ->setEnrollmentOption($enrollmentOption)
            ->setSeriesId($seriesId)
            ->setTicketSchemeId($ticketSchemeId);
    }
    /**
     * Get EnrollmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentOption()
    {
        return isset($this->EnrollmentOption) ? $this->EnrollmentOption : null;
    }
    /**
     * Set EnrollmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketSchemeEnrollmentPolicy::valueIsValid()
     * @uses \patest\EnumType\TicketSchemeEnrollmentPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $enrollmentOption
     * @return \patest\StructType\Crm_TicketSchemeEnrollmentOption
     */
    public function setEnrollmentOption($enrollmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketSchemeEnrollmentPolicy::valueIsValid($enrollmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketSchemeEnrollmentPolicy', is_array($enrollmentOption) ? implode(', ', $enrollmentOption) : var_export($enrollmentOption, true), implode(', ', \patest\EnumType\TicketSchemeEnrollmentPolicy::getValidValues())), __LINE__);
        }
        if (is_null($enrollmentOption) || (is_array($enrollmentOption) && empty($enrollmentOption))) {
            unset($this->EnrollmentOption);
        } else {
            $this->EnrollmentOption = $enrollmentOption;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Crm_TicketSchemeEnrollmentOption
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\Crm_TicketSchemeEnrollmentOption
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
}
