<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.StronglyRelatedClient StructType
 * @subpackage Structs
 */
class Crm_StronglyRelatedClient extends Crm_RelatedClient
{
    /**
     * The IsDeceased
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDeceased;
    /**
     * The IsGroupLeader
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupLeader;
    /**
     * The SharedAddressId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SharedAddressId;
    /**
     * Constructor method for Crm.StronglyRelatedClient
     * @uses Crm_StronglyRelatedClient::setIsDeceased()
     * @uses Crm_StronglyRelatedClient::setIsGroupLeader()
     * @uses Crm_StronglyRelatedClient::setSharedAddressId()
     * @param bool $isDeceased
     * @param bool $isGroupLeader
     * @param string $sharedAddressId
     */
    public function __construct($isDeceased = null, $isGroupLeader = null, $sharedAddressId = null)
    {
        $this
            ->setIsDeceased($isDeceased)
            ->setIsGroupLeader($isGroupLeader)
            ->setSharedAddressId($sharedAddressId);
    }
    /**
     * Get IsDeceased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDeceased()
    {
        return isset($this->IsDeceased) ? $this->IsDeceased : null;
    }
    /**
     * Set IsDeceased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDeceased
     * @return \patest\StructType\Crm_StronglyRelatedClient
     */
    public function setIsDeceased($isDeceased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDeceased) && !is_bool($isDeceased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDeceased, true), gettype($isDeceased)), __LINE__);
        }
        if (is_null($isDeceased) || (is_array($isDeceased) && empty($isDeceased))) {
            unset($this->IsDeceased);
        } else {
            $this->IsDeceased = $isDeceased;
        }
        return $this;
    }
    /**
     * Get IsGroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupLeader()
    {
        return isset($this->IsGroupLeader) ? $this->IsGroupLeader : null;
    }
    /**
     * Set IsGroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupLeader
     * @return \patest\StructType\Crm_StronglyRelatedClient
     */
    public function setIsGroupLeader($isGroupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupLeader) && !is_bool($isGroupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupLeader, true), gettype($isGroupLeader)), __LINE__);
        }
        if (is_null($isGroupLeader) || (is_array($isGroupLeader) && empty($isGroupLeader))) {
            unset($this->IsGroupLeader);
        } else {
            $this->IsGroupLeader = $isGroupLeader;
        }
        return $this;
    }
    /**
     * Get SharedAddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSharedAddressId()
    {
        return isset($this->SharedAddressId) ? $this->SharedAddressId : null;
    }
    /**
     * Set SharedAddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sharedAddressId
     * @return \patest\StructType\Crm_StronglyRelatedClient
     */
    public function setSharedAddressId($sharedAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($sharedAddressId) && !is_string($sharedAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sharedAddressId, true), gettype($sharedAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sharedAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sharedAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sharedAddressId, true)), __LINE__);
        }
        if (is_null($sharedAddressId) || (is_array($sharedAddressId) && empty($sharedAddressId))) {
            unset($this->SharedAddressId);
        } else {
            $this->SharedAddressId = $sharedAddressId;
        }
        return $this;
    }
}
