<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SimplifiedAddress StructType
 * @subpackage Structs
 */
class Crm_SimplifiedAddress extends AnyEntity
{
    /**
     * The AddressLine1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine1;
    /**
     * The AddressLine2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine2;
    /**
     * The AddressLine3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine3;
    /**
     * The AddressLine4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine4;
    /**
     * The AddressLine5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddressLine5;
    /**
     * The CityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CityId;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CountryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountryId;
    /**
     * The CountryName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CountryName;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefault;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The IsShared
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsShared;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Phone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Phone;
    /**
     * The RegionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RegionId;
    /**
     * The RegionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegionName;
    /**
     * The StateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StateId;
    /**
     * The StateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StateName;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The Usage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usage;
    /**
     * The ValidFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidFromDate;
    /**
     * The ValidToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidToDate;
    /**
     * The ZipCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCode;
    /**
     * The ZipCodeSource
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ZipCodeSource;
    /**
     * Constructor method for Crm.SimplifiedAddress
     * @uses Crm_SimplifiedAddress::setAddressLine1()
     * @uses Crm_SimplifiedAddress::setAddressLine2()
     * @uses Crm_SimplifiedAddress::setAddressLine3()
     * @uses Crm_SimplifiedAddress::setAddressLine4()
     * @uses Crm_SimplifiedAddress::setAddressLine5()
     * @uses Crm_SimplifiedAddress::setCityId()
     * @uses Crm_SimplifiedAddress::setCityName()
     * @uses Crm_SimplifiedAddress::setClientId()
     * @uses Crm_SimplifiedAddress::setCountryId()
     * @uses Crm_SimplifiedAddress::setCountryName()
     * @uses Crm_SimplifiedAddress::setId()
     * @uses Crm_SimplifiedAddress::setIsDefault()
     * @uses Crm_SimplifiedAddress::setIsPrimary()
     * @uses Crm_SimplifiedAddress::setIsShared()
     * @uses Crm_SimplifiedAddress::setNote()
     * @uses Crm_SimplifiedAddress::setPhone()
     * @uses Crm_SimplifiedAddress::setRegionId()
     * @uses Crm_SimplifiedAddress::setRegionName()
     * @uses Crm_SimplifiedAddress::setStateId()
     * @uses Crm_SimplifiedAddress::setStateName()
     * @uses Crm_SimplifiedAddress::setTypeId()
     * @uses Crm_SimplifiedAddress::setUsage()
     * @uses Crm_SimplifiedAddress::setValidFromDate()
     * @uses Crm_SimplifiedAddress::setValidToDate()
     * @uses Crm_SimplifiedAddress::setZipCode()
     * @uses Crm_SimplifiedAddress::setZipCodeSource()
     * @param string $addressLine1
     * @param string $addressLine2
     * @param string $addressLine3
     * @param string $addressLine4
     * @param string $addressLine5
     * @param string $cityId
     * @param string $cityName
     * @param string $clientId
     * @param string $countryId
     * @param string $countryName
     * @param string $id
     * @param bool $isDefault
     * @param bool $isPrimary
     * @param bool $isShared
     * @param string $note
     * @param string $phone
     * @param string $regionId
     * @param string $regionName
     * @param string $stateId
     * @param string $stateName
     * @param string $typeId
     * @param string $usage
     * @param string $validFromDate
     * @param string $validToDate
     * @param string $zipCode
     * @param string $zipCodeSource
     */
    public function __construct($addressLine1 = null, $addressLine2 = null, $addressLine3 = null, $addressLine4 = null, $addressLine5 = null, $cityId = null, $cityName = null, $clientId = null, $countryId = null, $countryName = null, $id = null, $isDefault = null, $isPrimary = null, $isShared = null, $note = null, $phone = null, $regionId = null, $regionName = null, $stateId = null, $stateName = null, $typeId = null, $usage = null, $validFromDate = null, $validToDate = null, $zipCode = null, $zipCodeSource = null)
    {
        $this
            ->setAddressLine1($addressLine1)
            ->setAddressLine2($addressLine2)
            ->setAddressLine3($addressLine3)
            ->setAddressLine4($addressLine4)
            ->setAddressLine5($addressLine5)
            ->setCityId($cityId)
            ->setCityName($cityName)
            ->setClientId($clientId)
            ->setCountryId($countryId)
            ->setCountryName($countryName)
            ->setId($id)
            ->setIsDefault($isDefault)
            ->setIsPrimary($isPrimary)
            ->setIsShared($isShared)
            ->setNote($note)
            ->setPhone($phone)
            ->setRegionId($regionId)
            ->setRegionName($regionName)
            ->setStateId($stateId)
            ->setStateName($stateName)
            ->setTypeId($typeId)
            ->setUsage($usage)
            ->setValidFromDate($validFromDate)
            ->setValidToDate($validToDate)
            ->setZipCode($zipCode)
            ->setZipCodeSource($zipCodeSource);
    }
    /**
     * Get AddressLine1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine1()
    {
        return isset($this->AddressLine1) ? $this->AddressLine1 : null;
    }
    /**
     * Set AddressLine1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine1
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setAddressLine1($addressLine1 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine1) && !is_string($addressLine1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine1, true), gettype($addressLine1)), __LINE__);
        }
        if (is_null($addressLine1) || (is_array($addressLine1) && empty($addressLine1))) {
            unset($this->AddressLine1);
        } else {
            $this->AddressLine1 = $addressLine1;
        }
        return $this;
    }
    /**
     * Get AddressLine2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine2()
    {
        return isset($this->AddressLine2) ? $this->AddressLine2 : null;
    }
    /**
     * Set AddressLine2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine2
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setAddressLine2($addressLine2 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine2) && !is_string($addressLine2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine2, true), gettype($addressLine2)), __LINE__);
        }
        if (is_null($addressLine2) || (is_array($addressLine2) && empty($addressLine2))) {
            unset($this->AddressLine2);
        } else {
            $this->AddressLine2 = $addressLine2;
        }
        return $this;
    }
    /**
     * Get AddressLine3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine3()
    {
        return isset($this->AddressLine3) ? $this->AddressLine3 : null;
    }
    /**
     * Set AddressLine3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine3
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setAddressLine3($addressLine3 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine3) && !is_string($addressLine3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine3, true), gettype($addressLine3)), __LINE__);
        }
        if (is_null($addressLine3) || (is_array($addressLine3) && empty($addressLine3))) {
            unset($this->AddressLine3);
        } else {
            $this->AddressLine3 = $addressLine3;
        }
        return $this;
    }
    /**
     * Get AddressLine4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine4()
    {
        return isset($this->AddressLine4) ? $this->AddressLine4 : null;
    }
    /**
     * Set AddressLine4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine4
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setAddressLine4($addressLine4 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine4) && !is_string($addressLine4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine4, true), gettype($addressLine4)), __LINE__);
        }
        if (is_null($addressLine4) || (is_array($addressLine4) && empty($addressLine4))) {
            unset($this->AddressLine4);
        } else {
            $this->AddressLine4 = $addressLine4;
        }
        return $this;
    }
    /**
     * Get AddressLine5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddressLine5()
    {
        return isset($this->AddressLine5) ? $this->AddressLine5 : null;
    }
    /**
     * Set AddressLine5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addressLine5
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setAddressLine5($addressLine5 = null)
    {
        // validation for constraint: string
        if (!is_null($addressLine5) && !is_string($addressLine5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressLine5, true), gettype($addressLine5)), __LINE__);
        }
        if (is_null($addressLine5) || (is_array($addressLine5) && empty($addressLine5))) {
            unset($this->AddressLine5);
        } else {
            $this->AddressLine5 = $addressLine5;
        }
        return $this;
    }
    /**
     * Get CityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityId()
    {
        return isset($this->CityId) ? $this->CityId : null;
    }
    /**
     * Set CityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setCityId($cityId = null)
    {
        // validation for constraint: string
        if (!is_null($cityId) && !is_string($cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityId, true), gettype($cityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cityId, true)), __LINE__);
        }
        if (is_null($cityId) || (is_array($cityId) && empty($cityId))) {
            unset($this->CityId);
        } else {
            $this->CityId = $cityId;
        }
        return $this;
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CountryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryId()
    {
        return isset($this->CountryId) ? $this->CountryId : null;
    }
    /**
     * Set CountryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setCountryId($countryId = null)
    {
        // validation for constraint: string
        if (!is_null($countryId) && !is_string($countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryId, true), gettype($countryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countryId, true)), __LINE__);
        }
        if (is_null($countryId) || (is_array($countryId) && empty($countryId))) {
            unset($this->CountryId);
        } else {
            $this->CountryId = $countryId;
        }
        return $this;
    }
    /**
     * Get CountryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountryName()
    {
        return isset($this->CountryName) ? $this->CountryName : null;
    }
    /**
     * Set CountryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countryName
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setCountryName($countryName = null)
    {
        // validation for constraint: string
        if (!is_null($countryName) && !is_string($countryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryName, true), gettype($countryName)), __LINE__);
        }
        if (is_null($countryName) || (is_array($countryName) && empty($countryName))) {
            unset($this->CountryName);
        } else {
            $this->CountryName = $countryName;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefault()
    {
        return isset($this->IsDefault) ? $this->IsDefault : null;
    }
    /**
     * Set IsDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefault
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setIsDefault($isDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefault) && !is_bool($isDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefault, true), gettype($isDefault)), __LINE__);
        }
        if (is_null($isDefault) || (is_array($isDefault) && empty($isDefault))) {
            unset($this->IsDefault);
        } else {
            $this->IsDefault = $isDefault;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return isset($this->IsPrimary) ? $this->IsPrimary : null;
    }
    /**
     * Set IsPrimary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrimary
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        if (is_null($isPrimary) || (is_array($isPrimary) && empty($isPrimary))) {
            unset($this->IsPrimary);
        } else {
            $this->IsPrimary = $isPrimary;
        }
        return $this;
    }
    /**
     * Get IsShared value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsShared()
    {
        return isset($this->IsShared) ? $this->IsShared : null;
    }
    /**
     * Set IsShared value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isShared
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setIsShared($isShared = null)
    {
        // validation for constraint: boolean
        if (!is_null($isShared) && !is_bool($isShared)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isShared, true), gettype($isShared)), __LINE__);
        }
        if (is_null($isShared) || (is_array($isShared) && empty($isShared))) {
            unset($this->IsShared);
        } else {
            $this->IsShared = $isShared;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Phone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhone()
    {
        return isset($this->Phone) ? $this->Phone : null;
    }
    /**
     * Set Phone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $phone
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($phone, true), gettype($phone)), __LINE__);
        }
        if (is_null($phone) || (is_array($phone) && empty($phone))) {
            unset($this->Phone);
        } else {
            $this->Phone = $phone;
        }
        return $this;
    }
    /**
     * Get RegionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionId()
    {
        return isset($this->RegionId) ? $this->RegionId : null;
    }
    /**
     * Set RegionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setRegionId($regionId = null)
    {
        // validation for constraint: string
        if (!is_null($regionId) && !is_string($regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionId, true), gettype($regionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($regionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $regionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($regionId, true)), __LINE__);
        }
        if (is_null($regionId) || (is_array($regionId) && empty($regionId))) {
            unset($this->RegionId);
        } else {
            $this->RegionId = $regionId;
        }
        return $this;
    }
    /**
     * Get RegionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegionName()
    {
        return isset($this->RegionName) ? $this->RegionName : null;
    }
    /**
     * Set RegionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regionName
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setRegionName($regionName = null)
    {
        // validation for constraint: string
        if (!is_null($regionName) && !is_string($regionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($regionName, true), gettype($regionName)), __LINE__);
        }
        if (is_null($regionName) || (is_array($regionName) && empty($regionName))) {
            unset($this->RegionName);
        } else {
            $this->RegionName = $regionName;
        }
        return $this;
    }
    /**
     * Get StateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateId()
    {
        return isset($this->StateId) ? $this->StateId : null;
    }
    /**
     * Set StateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setStateId($stateId = null)
    {
        // validation for constraint: string
        if (!is_null($stateId) && !is_string($stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateId, true), gettype($stateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stateId, true)), __LINE__);
        }
        if (is_null($stateId) || (is_array($stateId) && empty($stateId))) {
            unset($this->StateId);
        } else {
            $this->StateId = $stateId;
        }
        return $this;
    }
    /**
     * Get StateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStateName()
    {
        return isset($this->StateName) ? $this->StateName : null;
    }
    /**
     * Set StateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stateName
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateName, true), gettype($stateName)), __LINE__);
        }
        if (is_null($stateName) || (is_array($stateName) && empty($stateName))) {
            unset($this->StateName);
        } else {
            $this->StateName = $stateName;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get Usage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsage()
    {
        return isset($this->Usage) ? $this->Usage : null;
    }
    /**
     * Set Usage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AddressUsageKind::valueIsValid()
     * @uses \patest\EnumType\AddressUsageKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $usage
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setUsage($usage = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AddressUsageKind::valueIsValid($usage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AddressUsageKind', is_array($usage) ? implode(', ', $usage) : var_export($usage, true), implode(', ', \patest\EnumType\AddressUsageKind::getValidValues())), __LINE__);
        }
        if (is_null($usage) || (is_array($usage) && empty($usage))) {
            unset($this->Usage);
        } else {
            $this->Usage = $usage;
        }
        return $this;
    }
    /**
     * Get ValidFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidFromDate()
    {
        return isset($this->ValidFromDate) ? $this->ValidFromDate : null;
    }
    /**
     * Set ValidFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validFromDate
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setValidFromDate($validFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($validFromDate) && !is_string($validFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFromDate, true), gettype($validFromDate)), __LINE__);
        }
        if (is_null($validFromDate) || (is_array($validFromDate) && empty($validFromDate))) {
            unset($this->ValidFromDate);
        } else {
            $this->ValidFromDate = $validFromDate;
        }
        return $this;
    }
    /**
     * Get ValidToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidToDate()
    {
        return isset($this->ValidToDate) ? $this->ValidToDate : null;
    }
    /**
     * Set ValidToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validToDate
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setValidToDate($validToDate = null)
    {
        // validation for constraint: string
        if (!is_null($validToDate) && !is_string($validToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validToDate, true), gettype($validToDate)), __LINE__);
        }
        if (is_null($validToDate) || (is_array($validToDate) && empty($validToDate))) {
            unset($this->ValidToDate);
        } else {
            $this->ValidToDate = $validToDate;
        }
        return $this;
    }
    /**
     * Get ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCode()
    {
        return isset($this->ZipCode) ? $this->ZipCode : null;
    }
    /**
     * Set ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zipCode
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCode, true), gettype($zipCode)), __LINE__);
        }
        if (is_null($zipCode) || (is_array($zipCode) && empty($zipCode))) {
            unset($this->ZipCode);
        } else {
            $this->ZipCode = $zipCode;
        }
        return $this;
    }
    /**
     * Get ZipCodeSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZipCodeSource()
    {
        return isset($this->ZipCodeSource) ? $this->ZipCodeSource : null;
    }
    /**
     * Set ZipCodeSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ZipCodeSource::valueIsValid()
     * @uses \patest\EnumType\ZipCodeSource::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $zipCodeSource
     * @return \patest\StructType\Crm_SimplifiedAddress
     */
    public function setZipCodeSource($zipCodeSource = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ZipCodeSource::valueIsValid($zipCodeSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ZipCodeSource', is_array($zipCodeSource) ? implode(', ', $zipCodeSource) : var_export($zipCodeSource, true), implode(', ', \patest\EnumType\ZipCodeSource::getValidValues())), __LINE__);
        }
        if (is_null($zipCodeSource) || (is_array($zipCodeSource) && empty($zipCodeSource))) {
            unset($this->ZipCodeSource);
        } else {
            $this->ZipCodeSource = $zipCodeSource;
        }
        return $this;
    }
}
