<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.SimplifiedAccount StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.SimplifiedAccount
 * @subpackage Structs
 */
class Crm_SimplifiedAccount extends Crm_SimplifiedClient
{
    /**
     * The AccountTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccountTypeIds
     */
    public $AccountTypeIds;
    /**
     * The AccountTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AccountType
     */
    public $AccountTypes;
    /**
     * The Announcement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Announcement;
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactPersonId;
    /**
     * The CreditLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CreditLimit;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The Interface
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Interface;
    /**
     * The Logo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Logo;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SaleOnBehalfUserTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleOnBehalfUserTokenId;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Crm.SimplifiedAccount
     * @uses Crm_SimplifiedAccount::setAccountTypeIds()
     * @uses Crm_SimplifiedAccount::setAccountTypes()
     * @uses Crm_SimplifiedAccount::setAnnouncement()
     * @uses Crm_SimplifiedAccount::setContactPersonId()
     * @uses Crm_SimplifiedAccount::setCreditLimit()
     * @uses Crm_SimplifiedAccount::setGroupId()
     * @uses Crm_SimplifiedAccount::setInterface()
     * @uses Crm_SimplifiedAccount::setLogo()
     * @uses Crm_SimplifiedAccount::setName()
     * @uses Crm_SimplifiedAccount::setSaleOnBehalfUserTokenId()
     * @uses Crm_SimplifiedAccount::setVatRegistrationNumber()
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @param string $announcement
     * @param string $contactPersonId
     * @param \patest\StructType\Money $creditLimit
     * @param string $groupId
     * @param string $interface
     * @param string $logo
     * @param string $name
     * @param string $saleOnBehalfUserTokenId
     * @param string $vatRegistrationNumber
     */
    public function __construct(\patest\StructType\AccountTypeIds $accountTypeIds = null, \patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null, $announcement = null, $contactPersonId = null, \patest\StructType\Money $creditLimit = null, $groupId = null, $interface = null, $logo = null, $name = null, $saleOnBehalfUserTokenId = null, $vatRegistrationNumber = null)
    {
        $this
            ->setAccountTypeIds($accountTypeIds)
            ->setAccountTypes($accountTypes)
            ->setAnnouncement($announcement)
            ->setContactPersonId($contactPersonId)
            ->setCreditLimit($creditLimit)
            ->setGroupId($groupId)
            ->setInterface($interface)
            ->setLogo($logo)
            ->setName($name)
            ->setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get AccountTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccountTypeIds|null
     */
    public function getAccountTypeIds()
    {
        return isset($this->AccountTypeIds) ? $this->AccountTypeIds : null;
    }
    /**
     * Set AccountTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AccountTypeIds $accountTypeIds
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setAccountTypeIds(\patest\StructType\AccountTypeIds $accountTypeIds = null)
    {
        if (is_null($accountTypeIds) || (is_array($accountTypeIds) && empty($accountTypeIds))) {
            unset($this->AccountTypeIds);
        } else {
            $this->AccountTypeIds = $accountTypeIds;
        }
        return $this;
    }
    /**
     * Get AccountTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AccountType|null
     */
    public function getAccountTypes()
    {
        return isset($this->AccountTypes) ? $this->AccountTypes : null;
    }
    /**
     * Set AccountTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AccountType $accountTypes
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setAccountTypes(\patest\StructType\RecordSetOfCrm_AccountType $accountTypes = null)
    {
        if (is_null($accountTypes) || (is_array($accountTypes) && empty($accountTypes))) {
            unset($this->AccountTypes);
        } else {
            $this->AccountTypes = $accountTypes;
        }
        return $this;
    }
    /**
     * Get Announcement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnnouncement()
    {
        return isset($this->Announcement) ? $this->Announcement : null;
    }
    /**
     * Set Announcement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $announcement
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setAnnouncement($announcement = null)
    {
        // validation for constraint: string
        if (!is_null($announcement) && !is_string($announcement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($announcement, true), gettype($announcement)), __LINE__);
        }
        if (is_null($announcement) || (is_array($announcement) && empty($announcement))) {
            unset($this->Announcement);
        } else {
            $this->Announcement = $announcement;
        }
        return $this;
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPersonId
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonId) && !is_string($contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactPersonId, true)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get CreditLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCreditLimit()
    {
        return isset($this->CreditLimit) ? $this->CreditLimit : null;
    }
    /**
     * Set CreditLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $creditLimit
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setCreditLimit(\patest\StructType\Money $creditLimit = null)
    {
        if (is_null($creditLimit) || (is_array($creditLimit) && empty($creditLimit))) {
            unset($this->CreditLimit);
        } else {
            $this->CreditLimit = $creditLimit;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get Interface value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInterface()
    {
        return isset($this->Interface) ? $this->Interface : null;
    }
    /**
     * Set Interface value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $interface
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setInterface($interface = null)
    {
        // validation for constraint: string
        if (!is_null($interface) && !is_string($interface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interface, true), gettype($interface)), __LINE__);
        }
        if (is_null($interface) || (is_array($interface) && empty($interface))) {
            unset($this->Interface);
        } else {
            $this->Interface = $interface;
        }
        return $this;
    }
    /**
     * Get Logo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLogo()
    {
        return isset($this->Logo) ? $this->Logo : null;
    }
    /**
     * Set Logo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $logo
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setLogo($logo = null)
    {
        // validation for constraint: string
        if (!is_null($logo) && !is_string($logo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logo, true), gettype($logo)), __LINE__);
        }
        if (is_null($logo) || (is_array($logo) && empty($logo))) {
            unset($this->Logo);
        } else {
            $this->Logo = $logo;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SaleOnBehalfUserTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleOnBehalfUserTokenId()
    {
        return isset($this->SaleOnBehalfUserTokenId) ? $this->SaleOnBehalfUserTokenId : null;
    }
    /**
     * Set SaleOnBehalfUserTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleOnBehalfUserTokenId
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setSaleOnBehalfUserTokenId($saleOnBehalfUserTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($saleOnBehalfUserTokenId) && !is_string($saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleOnBehalfUserTokenId, true), gettype($saleOnBehalfUserTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleOnBehalfUserTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleOnBehalfUserTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleOnBehalfUserTokenId, true)), __LINE__);
        }
        if (is_null($saleOnBehalfUserTokenId) || (is_array($saleOnBehalfUserTokenId) && empty($saleOnBehalfUserTokenId))) {
            unset($this->SaleOnBehalfUserTokenId);
        } else {
            $this->SaleOnBehalfUserTokenId = $saleOnBehalfUserTokenId;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Crm_SimplifiedAccount
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
