<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.RelatedClient StructType
 * @subpackage Structs
 */
class Crm_RelatedClient extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ClientType;
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactPersonId;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The FullName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FullName;
    /**
     * The IsFavourite
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFavourite;
    /**
     * The IsRelationshipConfirmed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelationshipConfirmed;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LoyaltyPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LoyaltyPoints;
    /**
     * The MatchingGiftMax
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftMax;
    /**
     * The MatchingGiftMin
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftMin;
    /**
     * The MatchingGiftPercent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftPercent;
    /**
     * The QualityPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QualityPoints;
    /**
     * The ReciprocalRoleId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReciprocalRoleId;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * The RelationshipRoleId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipRoleId;
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * The SoftCreditPercentage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SoftCreditPercentage;
    /**
     * Constructor method for Crm.RelatedClient
     * @uses Crm_RelatedClient::setClientId()
     * @uses Crm_RelatedClient::setClientType()
     * @uses Crm_RelatedClient::setContactPersonId()
     * @uses Crm_RelatedClient::setCrmId()
     * @uses Crm_RelatedClient::setFirstName()
     * @uses Crm_RelatedClient::setFullName()
     * @uses Crm_RelatedClient::setIsFavourite()
     * @uses Crm_RelatedClient::setIsRelationshipConfirmed()
     * @uses Crm_RelatedClient::setLastName()
     * @uses Crm_RelatedClient::setLoyaltyPoints()
     * @uses Crm_RelatedClient::setMatchingGiftMax()
     * @uses Crm_RelatedClient::setMatchingGiftMin()
     * @uses Crm_RelatedClient::setMatchingGiftPercent()
     * @uses Crm_RelatedClient::setQualityPoints()
     * @uses Crm_RelatedClient::setReciprocalRoleId()
     * @uses Crm_RelatedClient::setRelationshipId()
     * @uses Crm_RelatedClient::setRelationshipRoleId()
     * @uses Crm_RelatedClient::setRelationshipTypeId()
     * @uses Crm_RelatedClient::setSoftCreditPercentage()
     * @param string $clientId
     * @param string[] $clientType
     * @param string $contactPersonId
     * @param string $crmId
     * @param string $firstName
     * @param string $fullName
     * @param bool $isFavourite
     * @param bool $isRelationshipConfirmed
     * @param string $lastName
     * @param float $loyaltyPoints
     * @param int $matchingGiftMax
     * @param int $matchingGiftMin
     * @param int $matchingGiftPercent
     * @param float $qualityPoints
     * @param string $reciprocalRoleId
     * @param string $relationshipId
     * @param string $relationshipRoleId
     * @param string $relationshipTypeId
     * @param int $softCreditPercentage
     */
    public function __construct($clientId = null, array $clientType = array(), $contactPersonId = null, $crmId = null, $firstName = null, $fullName = null, $isFavourite = null, $isRelationshipConfirmed = null, $lastName = null, $loyaltyPoints = null, $matchingGiftMax = null, $matchingGiftMin = null, $matchingGiftPercent = null, $qualityPoints = null, $reciprocalRoleId = null, $relationshipId = null, $relationshipRoleId = null, $relationshipTypeId = null, $softCreditPercentage = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientType($clientType)
            ->setContactPersonId($contactPersonId)
            ->setCrmId($crmId)
            ->setFirstName($firstName)
            ->setFullName($fullName)
            ->setIsFavourite($isFavourite)
            ->setIsRelationshipConfirmed($isRelationshipConfirmed)
            ->setLastName($lastName)
            ->setLoyaltyPoints($loyaltyPoints)
            ->setMatchingGiftMax($matchingGiftMax)
            ->setMatchingGiftMin($matchingGiftMin)
            ->setMatchingGiftPercent($matchingGiftPercent)
            ->setQualityPoints($qualityPoints)
            ->setReciprocalRoleId($reciprocalRoleId)
            ->setRelationshipId($relationshipId)
            ->setRelationshipRoleId($relationshipRoleId)
            ->setRelationshipTypeId($relationshipTypeId)
            ->setSoftCreditPercentage($softCreditPercentage);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getClientType()
    {
        return isset($this->ClientType) ? $this->ClientType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setClientType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientTypeForArrayConstraintsFromSetClientType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_RelatedClientClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_RelatedClientClientTypeItem)) {
                $invalidValues[] = is_object($crm_RelatedClientClientTypeItem) ? get_class($crm_RelatedClientClientTypeItem) : sprintf('%s(%s)', gettype($crm_RelatedClientClientTypeItem), var_export($crm_RelatedClientClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $clientType
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setClientType(array $clientType = array())
    {
        // validation for constraint: list
        if ('' !== ($clientTypeArrayErrorMessage = self::validateClientTypeForArrayConstraintsFromSetClientType($clientType))) {
            throw new \InvalidArgumentException($clientTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($clientType) || (is_array($clientType) && empty($clientType))) {
            unset($this->ClientType);
        } else {
            $this->ClientType = is_array($clientType) ? implode(' ', $clientType) : null;
        }
        return $this;
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPersonId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonId) && !is_string($contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactPersonId, true)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get FullName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFullName()
    {
        return isset($this->FullName) ? $this->FullName : null;
    }
    /**
     * Set FullName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fullName
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fullName, true), gettype($fullName)), __LINE__);
        }
        if (is_null($fullName) || (is_array($fullName) && empty($fullName))) {
            unset($this->FullName);
        } else {
            $this->FullName = $fullName;
        }
        return $this;
    }
    /**
     * Get IsFavourite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFavourite()
    {
        return isset($this->IsFavourite) ? $this->IsFavourite : null;
    }
    /**
     * Set IsFavourite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFavourite
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setIsFavourite($isFavourite = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFavourite) && !is_bool($isFavourite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFavourite, true), gettype($isFavourite)), __LINE__);
        }
        if (is_null($isFavourite) || (is_array($isFavourite) && empty($isFavourite))) {
            unset($this->IsFavourite);
        } else {
            $this->IsFavourite = $isFavourite;
        }
        return $this;
    }
    /**
     * Get IsRelationshipConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelationshipConfirmed()
    {
        return isset($this->IsRelationshipConfirmed) ? $this->IsRelationshipConfirmed : null;
    }
    /**
     * Set IsRelationshipConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelationshipConfirmed
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setIsRelationshipConfirmed($isRelationshipConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelationshipConfirmed) && !is_bool($isRelationshipConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelationshipConfirmed, true), gettype($isRelationshipConfirmed)), __LINE__);
        }
        if (is_null($isRelationshipConfirmed) || (is_array($isRelationshipConfirmed) && empty($isRelationshipConfirmed))) {
            unset($this->IsRelationshipConfirmed);
        } else {
            $this->IsRelationshipConfirmed = $isRelationshipConfirmed;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LoyaltyPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLoyaltyPoints()
    {
        return isset($this->LoyaltyPoints) ? $this->LoyaltyPoints : null;
    }
    /**
     * Set LoyaltyPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $loyaltyPoints
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setLoyaltyPoints($loyaltyPoints = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPoints) && !(is_float($loyaltyPoints) || is_numeric($loyaltyPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPoints, true), gettype($loyaltyPoints)), __LINE__);
        }
        if (is_null($loyaltyPoints) || (is_array($loyaltyPoints) && empty($loyaltyPoints))) {
            unset($this->LoyaltyPoints);
        } else {
            $this->LoyaltyPoints = $loyaltyPoints;
        }
        return $this;
    }
    /**
     * Get MatchingGiftMax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftMax()
    {
        return isset($this->MatchingGiftMax) ? $this->MatchingGiftMax : null;
    }
    /**
     * Set MatchingGiftMax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftMax
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setMatchingGiftMax($matchingGiftMax = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftMax) && !(is_int($matchingGiftMax) || ctype_digit($matchingGiftMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftMax, true), gettype($matchingGiftMax)), __LINE__);
        }
        if (is_null($matchingGiftMax) || (is_array($matchingGiftMax) && empty($matchingGiftMax))) {
            unset($this->MatchingGiftMax);
        } else {
            $this->MatchingGiftMax = $matchingGiftMax;
        }
        return $this;
    }
    /**
     * Get MatchingGiftMin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftMin()
    {
        return isset($this->MatchingGiftMin) ? $this->MatchingGiftMin : null;
    }
    /**
     * Set MatchingGiftMin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftMin
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setMatchingGiftMin($matchingGiftMin = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftMin) && !(is_int($matchingGiftMin) || ctype_digit($matchingGiftMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftMin, true), gettype($matchingGiftMin)), __LINE__);
        }
        if (is_null($matchingGiftMin) || (is_array($matchingGiftMin) && empty($matchingGiftMin))) {
            unset($this->MatchingGiftMin);
        } else {
            $this->MatchingGiftMin = $matchingGiftMin;
        }
        return $this;
    }
    /**
     * Get MatchingGiftPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftPercent()
    {
        return isset($this->MatchingGiftPercent) ? $this->MatchingGiftPercent : null;
    }
    /**
     * Set MatchingGiftPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftPercent
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setMatchingGiftPercent($matchingGiftPercent = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftPercent) && !(is_int($matchingGiftPercent) || ctype_digit($matchingGiftPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftPercent, true), gettype($matchingGiftPercent)), __LINE__);
        }
        if (is_null($matchingGiftPercent) || (is_array($matchingGiftPercent) && empty($matchingGiftPercent))) {
            unset($this->MatchingGiftPercent);
        } else {
            $this->MatchingGiftPercent = $matchingGiftPercent;
        }
        return $this;
    }
    /**
     * Get QualityPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQualityPoints()
    {
        return isset($this->QualityPoints) ? $this->QualityPoints : null;
    }
    /**
     * Set QualityPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qualityPoints
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setQualityPoints($qualityPoints = null)
    {
        // validation for constraint: float
        if (!is_null($qualityPoints) && !(is_float($qualityPoints) || is_numeric($qualityPoints))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qualityPoints, true), gettype($qualityPoints)), __LINE__);
        }
        if (is_null($qualityPoints) || (is_array($qualityPoints) && empty($qualityPoints))) {
            unset($this->QualityPoints);
        } else {
            $this->QualityPoints = $qualityPoints;
        }
        return $this;
    }
    /**
     * Get ReciprocalRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReciprocalRoleId()
    {
        return isset($this->ReciprocalRoleId) ? $this->ReciprocalRoleId : null;
    }
    /**
     * Set ReciprocalRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reciprocalRoleId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setReciprocalRoleId($reciprocalRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($reciprocalRoleId) && !is_string($reciprocalRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reciprocalRoleId, true), gettype($reciprocalRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reciprocalRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reciprocalRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reciprocalRoleId, true)), __LINE__);
        }
        if (is_null($reciprocalRoleId) || (is_array($reciprocalRoleId) && empty($reciprocalRoleId))) {
            unset($this->ReciprocalRoleId);
        } else {
            $this->ReciprocalRoleId = $reciprocalRoleId;
        }
        return $this;
    }
    /**
     * Get RelationshipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipId()
    {
        return isset($this->RelationshipId) ? $this->RelationshipId : null;
    }
    /**
     * Set RelationshipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        if (is_null($relationshipId) || (is_array($relationshipId) && empty($relationshipId))) {
            unset($this->RelationshipId);
        } else {
            $this->RelationshipId = $relationshipId;
        }
        return $this;
    }
    /**
     * Get RelationshipRoleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipRoleId()
    {
        return isset($this->RelationshipRoleId) ? $this->RelationshipRoleId : null;
    }
    /**
     * Set RelationshipRoleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipRoleId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setRelationshipRoleId($relationshipRoleId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipRoleId) && !is_string($relationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipRoleId, true), gettype($relationshipRoleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipRoleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipRoleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipRoleId, true)), __LINE__);
        }
        if (is_null($relationshipRoleId) || (is_array($relationshipRoleId) && empty($relationshipRoleId))) {
            unset($this->RelationshipRoleId);
        } else {
            $this->RelationshipRoleId = $relationshipRoleId;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return isset($this->RelationshipTypeId) ? $this->RelationshipTypeId : null;
    }
    /**
     * Set RelationshipTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeId
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        if (is_null($relationshipTypeId) || (is_array($relationshipTypeId) && empty($relationshipTypeId))) {
            unset($this->RelationshipTypeId);
        } else {
            $this->RelationshipTypeId = $relationshipTypeId;
        }
        return $this;
    }
    /**
     * Get SoftCreditPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSoftCreditPercentage()
    {
        return isset($this->SoftCreditPercentage) ? $this->SoftCreditPercentage : null;
    }
    /**
     * Set SoftCreditPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $softCreditPercentage
     * @return \patest\StructType\Crm_RelatedClient
     */
    public function setSoftCreditPercentage($softCreditPercentage = null)
    {
        // validation for constraint: int
        if (!is_null($softCreditPercentage) && !(is_int($softCreditPercentage) || ctype_digit($softCreditPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($softCreditPercentage, true), gettype($softCreditPercentage)), __LINE__);
        }
        if (is_null($softCreditPercentage) || (is_array($softCreditPercentage) && empty($softCreditPercentage))) {
            unset($this->SoftCreditPercentage);
        } else {
            $this->SoftCreditPercentage = $softCreditPercentage;
        }
        return $this;
    }
}
