<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.CustomerRegistration StructType
 * @subpackage Structs
 */
class Crm_CustomerRegistration extends PersistableEntity
{
    /**
     * The ClientEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientEntity;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The IsVerified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerified;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LoginUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginUrl;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The RegistrationLandingUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegistrationLandingUrl;
    /**
     * The ResetPasswordUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResetPasswordUrl;
    /**
     * The TokenExpirationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TokenExpirationDateTime;
    /**
     * The TokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TokenId;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Crm.CustomerRegistration
     * @uses Crm_CustomerRegistration::setClientEntity()
     * @uses Crm_CustomerRegistration::setConnectionAuditId()
     * @uses Crm_CustomerRegistration::setCreationDateTime()
     * @uses Crm_CustomerRegistration::setEmail()
     * @uses Crm_CustomerRegistration::setIsVerified()
     * @uses Crm_CustomerRegistration::setLastUpdateDateTime()
     * @uses Crm_CustomerRegistration::setLoginUrl()
     * @uses Crm_CustomerRegistration::setOrganizationUnitId()
     * @uses Crm_CustomerRegistration::setRegistrationLandingUrl()
     * @uses Crm_CustomerRegistration::setResetPasswordUrl()
     * @uses Crm_CustomerRegistration::setTokenExpirationDateTime()
     * @uses Crm_CustomerRegistration::setTokenId()
     * @uses Crm_CustomerRegistration::setUserId()
     * @param string $clientEntity
     * @param int $connectionAuditId
     * @param string $creationDateTime
     * @param string $email
     * @param bool $isVerified
     * @param string $lastUpdateDateTime
     * @param string $loginUrl
     * @param string $organizationUnitId
     * @param string $registrationLandingUrl
     * @param string $resetPasswordUrl
     * @param string $tokenExpirationDateTime
     * @param string $tokenId
     * @param string $userId
     */
    public function __construct($clientEntity = null, $connectionAuditId = null, $creationDateTime = null, $email = null, $isVerified = null, $lastUpdateDateTime = null, $loginUrl = null, $organizationUnitId = null, $registrationLandingUrl = null, $resetPasswordUrl = null, $tokenExpirationDateTime = null, $tokenId = null, $userId = null)
    {
        $this
            ->setClientEntity($clientEntity)
            ->setConnectionAuditId($connectionAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setEmail($email)
            ->setIsVerified($isVerified)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLoginUrl($loginUrl)
            ->setOrganizationUnitId($organizationUnitId)
            ->setRegistrationLandingUrl($registrationLandingUrl)
            ->setResetPasswordUrl($resetPasswordUrl)
            ->setTokenExpirationDateTime($tokenExpirationDateTime)
            ->setTokenId($tokenId)
            ->setUserId($userId);
    }
    /**
     * Get ClientEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEntity()
    {
        return isset($this->ClientEntity) ? $this->ClientEntity : null;
    }
    /**
     * Set ClientEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEntity
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setClientEntity($clientEntity = null)
    {
        // validation for constraint: string
        if (!is_null($clientEntity) && !is_string($clientEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEntity, true), gettype($clientEntity)), __LINE__);
        }
        if (is_null($clientEntity) || (is_array($clientEntity) && empty($clientEntity))) {
            unset($this->ClientEntity);
        } else {
            $this->ClientEntity = $clientEntity;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get IsVerified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerified()
    {
        return isset($this->IsVerified) ? $this->IsVerified : null;
    }
    /**
     * Set IsVerified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerified
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setIsVerified($isVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerified) && !is_bool($isVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerified, true), gettype($isVerified)), __LINE__);
        }
        if (is_null($isVerified) || (is_array($isVerified) && empty($isVerified))) {
            unset($this->IsVerified);
        } else {
            $this->IsVerified = $isVerified;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LoginUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginUrl()
    {
        return isset($this->LoginUrl) ? $this->LoginUrl : null;
    }
    /**
     * Set LoginUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginUrl
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setLoginUrl($loginUrl = null)
    {
        // validation for constraint: string
        if (!is_null($loginUrl) && !is_string($loginUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginUrl, true), gettype($loginUrl)), __LINE__);
        }
        if (is_null($loginUrl) || (is_array($loginUrl) && empty($loginUrl))) {
            unset($this->LoginUrl);
        } else {
            $this->LoginUrl = $loginUrl;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get RegistrationLandingUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegistrationLandingUrl()
    {
        return isset($this->RegistrationLandingUrl) ? $this->RegistrationLandingUrl : null;
    }
    /**
     * Set RegistrationLandingUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $registrationLandingUrl
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setRegistrationLandingUrl($registrationLandingUrl = null)
    {
        // validation for constraint: string
        if (!is_null($registrationLandingUrl) && !is_string($registrationLandingUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registrationLandingUrl, true), gettype($registrationLandingUrl)), __LINE__);
        }
        if (is_null($registrationLandingUrl) || (is_array($registrationLandingUrl) && empty($registrationLandingUrl))) {
            unset($this->RegistrationLandingUrl);
        } else {
            $this->RegistrationLandingUrl = $registrationLandingUrl;
        }
        return $this;
    }
    /**
     * Get ResetPasswordUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResetPasswordUrl()
    {
        return isset($this->ResetPasswordUrl) ? $this->ResetPasswordUrl : null;
    }
    /**
     * Set ResetPasswordUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resetPasswordUrl
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setResetPasswordUrl($resetPasswordUrl = null)
    {
        // validation for constraint: string
        if (!is_null($resetPasswordUrl) && !is_string($resetPasswordUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resetPasswordUrl, true), gettype($resetPasswordUrl)), __LINE__);
        }
        if (is_null($resetPasswordUrl) || (is_array($resetPasswordUrl) && empty($resetPasswordUrl))) {
            unset($this->ResetPasswordUrl);
        } else {
            $this->ResetPasswordUrl = $resetPasswordUrl;
        }
        return $this;
    }
    /**
     * Get TokenExpirationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenExpirationDateTime()
    {
        return isset($this->TokenExpirationDateTime) ? $this->TokenExpirationDateTime : null;
    }
    /**
     * Set TokenExpirationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenExpirationDateTime
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setTokenExpirationDateTime($tokenExpirationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($tokenExpirationDateTime) && !is_string($tokenExpirationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenExpirationDateTime, true), gettype($tokenExpirationDateTime)), __LINE__);
        }
        if (is_null($tokenExpirationDateTime) || (is_array($tokenExpirationDateTime) && empty($tokenExpirationDateTime))) {
            unset($this->TokenExpirationDateTime);
        } else {
            $this->TokenExpirationDateTime = $tokenExpirationDateTime;
        }
        return $this;
    }
    /**
     * Get TokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTokenId()
    {
        return isset($this->TokenId) ? $this->TokenId : null;
    }
    /**
     * Set TokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tokenId
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setTokenId($tokenId = null)
    {
        // validation for constraint: string
        if (!is_null($tokenId) && !is_string($tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenId, true), gettype($tokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tokenId, true)), __LINE__);
        }
        if (is_null($tokenId) || (is_array($tokenId) && empty($tokenId))) {
            unset($this->TokenId);
        } else {
            $this->TokenId = $tokenId;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Crm_CustomerRegistration
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
