<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ContactDetail StructType
 * @subpackage Structs
 */
class Crm_ContactDetail extends DistributableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Detail;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The OriginalValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OriginalValue;
    /**
     * The SearchableDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SearchableDetail;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * Constructor method for Crm.ContactDetail
     * @uses Crm_ContactDetail::setClientId()
     * @uses Crm_ContactDetail::setDetail()
     * @uses Crm_ContactDetail::setIsPrimary()
     * @uses Crm_ContactDetail::setLastUpdateDateTime()
     * @uses Crm_ContactDetail::setMapToCrmSyncEntity()
     * @uses Crm_ContactDetail::setNote()
     * @uses Crm_ContactDetail::setOriginalValue()
     * @uses Crm_ContactDetail::setSearchableDetail()
     * @uses Crm_ContactDetail::setSystemName()
     * @uses Crm_ContactDetail::setType()
     * @uses Crm_ContactDetail::setTypeId()
     * @param string $clientId
     * @param string $detail
     * @param bool $isPrimary
     * @param string $lastUpdateDateTime
     * @param int $mapToCrmSyncEntity
     * @param \patest\StructType\GlobalString $note
     * @param string $originalValue
     * @param string $searchableDetail
     * @param string $systemName
     * @param string $type
     * @param string $typeId
     */
    public function __construct($clientId = null, $detail = null, $isPrimary = null, $lastUpdateDateTime = null, $mapToCrmSyncEntity = null, \patest\StructType\GlobalString $note = null, $originalValue = null, $searchableDetail = null, $systemName = null, $type = null, $typeId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDetail($detail)
            ->setIsPrimary($isPrimary)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setNote($note)
            ->setOriginalValue($originalValue)
            ->setSearchableDetail($searchableDetail)
            ->setSystemName($systemName)
            ->setType($type)
            ->setTypeId($typeId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetail()
    {
        return isset($this->Detail) ? $this->Detail : null;
    }
    /**
     * Set Detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detail
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        if (is_null($detail) || (is_array($detail) && empty($detail))) {
            unset($this->Detail);
        } else {
            $this->Detail = $detail;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return isset($this->IsPrimary) ? $this->IsPrimary : null;
    }
    /**
     * Set IsPrimary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrimary
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        if (is_null($isPrimary) || (is_array($isPrimary) && empty($isPrimary))) {
            unset($this->IsPrimary);
        } else {
            $this->IsPrimary = $isPrimary;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OriginalValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalValue()
    {
        return isset($this->OriginalValue) ? $this->OriginalValue : null;
    }
    /**
     * Set OriginalValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalValue
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setOriginalValue($originalValue = null)
    {
        // validation for constraint: string
        if (!is_null($originalValue) && !is_string($originalValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalValue, true), gettype($originalValue)), __LINE__);
        }
        if (is_null($originalValue) || (is_array($originalValue) && empty($originalValue))) {
            unset($this->OriginalValue);
        } else {
            $this->OriginalValue = $originalValue;
        }
        return $this;
    }
    /**
     * Get SearchableDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearchableDetail()
    {
        return isset($this->SearchableDetail) ? $this->SearchableDetail : null;
    }
    /**
     * Set SearchableDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $searchableDetail
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setSearchableDetail($searchableDetail = null)
    {
        // validation for constraint: string
        if (!is_null($searchableDetail) && !is_string($searchableDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($searchableDetail, true), gettype($searchableDetail)), __LINE__);
        }
        if (is_null($searchableDetail) || (is_array($searchableDetail) && empty($searchableDetail))) {
            unset($this->SearchableDetail);
        } else {
            $this->SearchableDetail = $searchableDetail;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ContactTypeKind::valueIsValid()
     * @uses \patest\EnumType\ContactTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ContactTypeKind::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ContactTypeKind', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\ContactTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_ContactDetail
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
}
