<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm.ClientType
 * @subpackage Structs
 */
class Crm_ClientType extends DistributableEntity
{
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The AvailableFor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AvailableFor;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DisplayInClientAlerts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayInClientAlerts;
    /**
     * The DisplayInContactRecord
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayInContactRecord;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsDynamic
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDynamic;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Crm.ClientType
     * @uses Crm_ClientType::setAclSchemeId()
     * @uses Crm_ClientType::setAvailableFor()
     * @uses Crm_ClientType::setDescription()
     * @uses Crm_ClientType::setDisplayInClientAlerts()
     * @uses Crm_ClientType::setDisplayInContactRecord()
     * @uses Crm_ClientType::setIsActive()
     * @uses Crm_ClientType::setIsDynamic()
     * @uses Crm_ClientType::setMapToCrmSyncEntity()
     * @uses Crm_ClientType::setName()
     * @uses Crm_ClientType::setOrdinal()
     * @uses Crm_ClientType::setOrganizationUnitId()
     * @uses Crm_ClientType::setVisibleBySubordinates()
     * @param int $aclSchemeId
     * @param string[] $availableFor
     * @param \patest\StructType\GlobalString $description
     * @param bool $displayInClientAlerts
     * @param bool $displayInContactRecord
     * @param bool $isActive
     * @param bool $isDynamic
     * @param int $mapToCrmSyncEntity
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($aclSchemeId = null, array $availableFor = array(), \patest\StructType\GlobalString $description = null, $displayInClientAlerts = null, $displayInContactRecord = null, $isActive = null, $isDynamic = null, $mapToCrmSyncEntity = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAclSchemeId($aclSchemeId)
            ->setAvailableFor($availableFor)
            ->setDescription($description)
            ->setDisplayInClientAlerts($displayInClientAlerts)
            ->setDisplayInContactRecord($displayInContactRecord)
            ->setIsActive($isActive)
            ->setIsDynamic($isDynamic)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Crm_ClientType
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get AvailableFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAvailableFor()
    {
        return isset($this->AvailableFor) ? $this->AvailableFor : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAvailableFor method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAvailableFor method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAvailableForForArrayConstraintsFromSetAvailableFor(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_ClientTypeAvailableForItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_ClientTypeAvailableForItem)) {
                $invalidValues[] = is_object($crm_ClientTypeAvailableForItem) ? get_class($crm_ClientTypeAvailableForItem) : sprintf('%s(%s)', gettype($crm_ClientTypeAvailableForItem), var_export($crm_ClientTypeAvailableForItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AvailableFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $availableFor
     * @return \patest\StructType\Crm_ClientType
     */
    public function setAvailableFor(array $availableFor = array())
    {
        // validation for constraint: list
        if ('' !== ($availableForArrayErrorMessage = self::validateAvailableForForArrayConstraintsFromSetAvailableFor($availableFor))) {
            throw new \InvalidArgumentException($availableForArrayErrorMessage, __LINE__);
        }
        if (is_null($availableFor) || (is_array($availableFor) && empty($availableFor))) {
            unset($this->AvailableFor);
        } else {
            $this->AvailableFor = is_array($availableFor) ? implode(' ', $availableFor) : null;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Crm_ClientType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayInClientAlerts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayInClientAlerts()
    {
        return isset($this->DisplayInClientAlerts) ? $this->DisplayInClientAlerts : null;
    }
    /**
     * Set DisplayInClientAlerts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayInClientAlerts
     * @return \patest\StructType\Crm_ClientType
     */
    public function setDisplayInClientAlerts($displayInClientAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInClientAlerts) && !is_bool($displayInClientAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInClientAlerts, true), gettype($displayInClientAlerts)), __LINE__);
        }
        if (is_null($displayInClientAlerts) || (is_array($displayInClientAlerts) && empty($displayInClientAlerts))) {
            unset($this->DisplayInClientAlerts);
        } else {
            $this->DisplayInClientAlerts = $displayInClientAlerts;
        }
        return $this;
    }
    /**
     * Get DisplayInContactRecord value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayInContactRecord()
    {
        return isset($this->DisplayInContactRecord) ? $this->DisplayInContactRecord : null;
    }
    /**
     * Set DisplayInContactRecord value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayInContactRecord
     * @return \patest\StructType\Crm_ClientType
     */
    public function setDisplayInContactRecord($displayInContactRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayInContactRecord) && !is_bool($displayInContactRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayInContactRecord, true), gettype($displayInContactRecord)), __LINE__);
        }
        if (is_null($displayInContactRecord) || (is_array($displayInContactRecord) && empty($displayInContactRecord))) {
            unset($this->DisplayInContactRecord);
        } else {
            $this->DisplayInContactRecord = $displayInContactRecord;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_ClientType
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsDynamic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDynamic()
    {
        return isset($this->IsDynamic) ? $this->IsDynamic : null;
    }
    /**
     * Set IsDynamic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDynamic
     * @return \patest\StructType\Crm_ClientType
     */
    public function setIsDynamic($isDynamic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDynamic) && !is_bool($isDynamic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDynamic, true), gettype($isDynamic)), __LINE__);
        }
        if (is_null($isDynamic) || (is_array($isDynamic) && empty($isDynamic))) {
            unset($this->IsDynamic);
        } else {
            $this->IsDynamic = $isDynamic;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_ClientType
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Crm_ClientType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Crm_ClientType
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_ClientType
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Crm_ClientType
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
