<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientLastModifierFields StructType
 * @subpackage Structs
 */
class Crm_ClientLastModifierFields extends DistributableEntity
{
    /**
     * The LastUpdateAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastUpdateAuditId;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * Constructor method for Crm.ClientLastModifierFields
     * @uses Crm_ClientLastModifierFields::setLastUpdateAuditId()
     * @uses Crm_ClientLastModifierFields::setLastUpdateDateTime()
     * @param int $lastUpdateAuditId
     * @param string $lastUpdateDateTime
     */
    public function __construct($lastUpdateAuditId = null, $lastUpdateDateTime = null)
    {
        $this
            ->setLastUpdateAuditId($lastUpdateAuditId)
            ->setLastUpdateDateTime($lastUpdateDateTime);
    }
    /**
     * Get LastUpdateAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastUpdateAuditId()
    {
        return isset($this->LastUpdateAuditId) ? $this->LastUpdateAuditId : null;
    }
    /**
     * Set LastUpdateAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastUpdateAuditId
     * @return \patest\StructType\Crm_ClientLastModifierFields
     */
    public function setLastUpdateAuditId($lastUpdateAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateAuditId) && !(is_int($lastUpdateAuditId) || ctype_digit($lastUpdateAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastUpdateAuditId, true), gettype($lastUpdateAuditId)), __LINE__);
        }
        if (is_null($lastUpdateAuditId) || (is_array($lastUpdateAuditId) && empty($lastUpdateAuditId))) {
            unset($this->LastUpdateAuditId);
        } else {
            $this->LastUpdateAuditId = $lastUpdateAuditId;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Crm_ClientLastModifierFields
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
}
