<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientEnrollment StructType
 * @subpackage Structs
 */
class Crm_ClientEnrollment extends PersistableEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DateOfEnteringPaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfEnteringPaymentDetails;
    /**
     * The EnrolledInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrolledInstanceId;
    /**
     * The EnrolledInstanceOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrolledInstanceOwner;
    /**
     * The EnrollmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EnrollmentDate;
    /**
     * The EnrollmentSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrollmentSchemeId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The MassEnrollId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MassEnrollId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentPlanPaymentDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentPlanPaymentDay;
    /**
     * The PaymentPlanPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanPaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The SpecialInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialInfo;
    /**
     * Constructor method for Crm.ClientEnrollment
     * @uses Crm_ClientEnrollment::setClientId()
     * @uses Crm_ClientEnrollment::setDateOfEnteringPaymentDetails()
     * @uses Crm_ClientEnrollment::setEnrolledInstanceId()
     * @uses Crm_ClientEnrollment::setEnrolledInstanceOwner()
     * @uses Crm_ClientEnrollment::setEnrollmentDate()
     * @uses Crm_ClientEnrollment::setEnrollmentSchemeId()
     * @uses Crm_ClientEnrollment::setIsActive()
     * @uses Crm_ClientEnrollment::setMassEnrollId()
     * @uses Crm_ClientEnrollment::setPaymentMethodId()
     * @uses Crm_ClientEnrollment::setPaymentPlanPaymentDay()
     * @uses Crm_ClientEnrollment::setPaymentPlanPaymentMethodId()
     * @uses Crm_ClientEnrollment::setPaymentTokenId()
     * @uses Crm_ClientEnrollment::setSpecialInfo()
     * @param string $clientId
     * @param string $dateOfEnteringPaymentDetails
     * @param string $enrolledInstanceId
     * @param string $enrolledInstanceOwner
     * @param string $enrollmentDate
     * @param string $enrollmentSchemeId
     * @param bool $isActive
     * @param string $massEnrollId
     * @param string $paymentMethodId
     * @param int $paymentPlanPaymentDay
     * @param string $paymentPlanPaymentMethodId
     * @param string $paymentTokenId
     * @param string $specialInfo
     */
    public function __construct($clientId = null, $dateOfEnteringPaymentDetails = null, $enrolledInstanceId = null, $enrolledInstanceOwner = null, $enrollmentDate = null, $enrollmentSchemeId = null, $isActive = null, $massEnrollId = null, $paymentMethodId = null, $paymentPlanPaymentDay = null, $paymentPlanPaymentMethodId = null, $paymentTokenId = null, $specialInfo = null)
    {
        $this
            ->setClientId($clientId)
            ->setDateOfEnteringPaymentDetails($dateOfEnteringPaymentDetails)
            ->setEnrolledInstanceId($enrolledInstanceId)
            ->setEnrolledInstanceOwner($enrolledInstanceOwner)
            ->setEnrollmentDate($enrollmentDate)
            ->setEnrollmentSchemeId($enrollmentSchemeId)
            ->setIsActive($isActive)
            ->setMassEnrollId($massEnrollId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentPlanPaymentDay($paymentPlanPaymentDay)
            ->setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setSpecialInfo($specialInfo);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DateOfEnteringPaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfEnteringPaymentDetails()
    {
        return isset($this->DateOfEnteringPaymentDetails) ? $this->DateOfEnteringPaymentDetails : null;
    }
    /**
     * Set DateOfEnteringPaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfEnteringPaymentDetails
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setDateOfEnteringPaymentDetails($dateOfEnteringPaymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfEnteringPaymentDetails) && !is_string($dateOfEnteringPaymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfEnteringPaymentDetails, true), gettype($dateOfEnteringPaymentDetails)), __LINE__);
        }
        if (is_null($dateOfEnteringPaymentDetails) || (is_array($dateOfEnteringPaymentDetails) && empty($dateOfEnteringPaymentDetails))) {
            unset($this->DateOfEnteringPaymentDetails);
        } else {
            $this->DateOfEnteringPaymentDetails = $dateOfEnteringPaymentDetails;
        }
        return $this;
    }
    /**
     * Get EnrolledInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrolledInstanceId()
    {
        return isset($this->EnrolledInstanceId) ? $this->EnrolledInstanceId : null;
    }
    /**
     * Set EnrolledInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrolledInstanceId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setEnrolledInstanceId($enrolledInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($enrolledInstanceId) && !is_string($enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrolledInstanceId, true), gettype($enrolledInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrolledInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrolledInstanceId, true)), __LINE__);
        }
        if (is_null($enrolledInstanceId) || (is_array($enrolledInstanceId) && empty($enrolledInstanceId))) {
            unset($this->EnrolledInstanceId);
        } else {
            $this->EnrolledInstanceId = $enrolledInstanceId;
        }
        return $this;
    }
    /**
     * Get EnrolledInstanceOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrolledInstanceOwner()
    {
        return isset($this->EnrolledInstanceOwner) ? $this->EnrolledInstanceOwner : null;
    }
    /**
     * Set EnrolledInstanceOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrolledInstanceOwner
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setEnrolledInstanceOwner($enrolledInstanceOwner = null)
    {
        // validation for constraint: string
        if (!is_null($enrolledInstanceOwner) && !is_string($enrolledInstanceOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrolledInstanceOwner, true), gettype($enrolledInstanceOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrolledInstanceOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrolledInstanceOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrolledInstanceOwner, true)), __LINE__);
        }
        if (is_null($enrolledInstanceOwner) || (is_array($enrolledInstanceOwner) && empty($enrolledInstanceOwner))) {
            unset($this->EnrolledInstanceOwner);
        } else {
            $this->EnrolledInstanceOwner = $enrolledInstanceOwner;
        }
        return $this;
    }
    /**
     * Get EnrollmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentDate()
    {
        return isset($this->EnrollmentDate) ? $this->EnrollmentDate : null;
    }
    /**
     * Set EnrollmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentDate
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setEnrollmentDate($enrollmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentDate) && !is_string($enrollmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentDate, true), gettype($enrollmentDate)), __LINE__);
        }
        if (is_null($enrollmentDate) || (is_array($enrollmentDate) && empty($enrollmentDate))) {
            unset($this->EnrollmentDate);
        } else {
            $this->EnrollmentDate = $enrollmentDate;
        }
        return $this;
    }
    /**
     * Get EnrollmentSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrollmentSchemeId()
    {
        return isset($this->EnrollmentSchemeId) ? $this->EnrollmentSchemeId : null;
    }
    /**
     * Set EnrollmentSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrollmentSchemeId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setEnrollmentSchemeId($enrollmentSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($enrollmentSchemeId) && !is_string($enrollmentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrollmentSchemeId, true), gettype($enrollmentSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrollmentSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrollmentSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrollmentSchemeId, true)), __LINE__);
        }
        if (is_null($enrollmentSchemeId) || (is_array($enrollmentSchemeId) && empty($enrollmentSchemeId))) {
            unset($this->EnrollmentSchemeId);
        } else {
            $this->EnrollmentSchemeId = $enrollmentSchemeId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get MassEnrollId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMassEnrollId()
    {
        return isset($this->MassEnrollId) ? $this->MassEnrollId : null;
    }
    /**
     * Set MassEnrollId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $massEnrollId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setMassEnrollId($massEnrollId = null)
    {
        // validation for constraint: string
        if (!is_null($massEnrollId) && !is_string($massEnrollId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($massEnrollId, true), gettype($massEnrollId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($massEnrollId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $massEnrollId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($massEnrollId, true)), __LINE__);
        }
        if (is_null($massEnrollId) || (is_array($massEnrollId) && empty($massEnrollId))) {
            unset($this->MassEnrollId);
        } else {
            $this->MassEnrollId = $massEnrollId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentPlanPaymentDay()
    {
        return isset($this->PaymentPlanPaymentDay) ? $this->PaymentPlanPaymentDay : null;
    }
    /**
     * Set PaymentPlanPaymentDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentPlanPaymentDay
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setPaymentPlanPaymentDay($paymentPlanPaymentDay = null)
    {
        // validation for constraint: int
        if (!is_null($paymentPlanPaymentDay) && !(is_int($paymentPlanPaymentDay) || ctype_digit($paymentPlanPaymentDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentPlanPaymentDay, true), gettype($paymentPlanPaymentDay)), __LINE__);
        }
        if (is_null($paymentPlanPaymentDay) || (is_array($paymentPlanPaymentDay) && empty($paymentPlanPaymentDay))) {
            unset($this->PaymentPlanPaymentDay);
        } else {
            $this->PaymentPlanPaymentDay = $paymentPlanPaymentDay;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanPaymentMethodId()
    {
        return isset($this->PaymentPlanPaymentMethodId) ? $this->PaymentPlanPaymentMethodId : null;
    }
    /**
     * Set PaymentPlanPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanPaymentMethodId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanPaymentMethodId) && !is_string($paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanPaymentMethodId, true), gettype($paymentPlanPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanPaymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentPlanPaymentMethodId) || (is_array($paymentPlanPaymentMethodId) && empty($paymentPlanPaymentMethodId))) {
            unset($this->PaymentPlanPaymentMethodId);
        } else {
            $this->PaymentPlanPaymentMethodId = $paymentPlanPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get SpecialInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialInfo()
    {
        return isset($this->SpecialInfo) ? $this->SpecialInfo : null;
    }
    /**
     * Set SpecialInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialInfo
     * @return \patest\StructType\Crm_ClientEnrollment
     */
    public function setSpecialInfo($specialInfo = null)
    {
        // validation for constraint: string
        if (!is_null($specialInfo) && !is_string($specialInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialInfo, true), gettype($specialInfo)), __LINE__);
        }
        if (is_null($specialInfo) || (is_array($specialInfo) && empty($specialInfo))) {
            unset($this->SpecialInfo);
        } else {
            $this->SpecialInfo = $specialInfo;
        }
        return $this;
    }
}
