<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientAlert StructType
 * @subpackage Structs
 */
class Crm_ClientAlert extends AnyEntity
{
    /**
     * The Alert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Alert;
    /**
     * The AlertColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlertColor;
    /**
     * The AlertKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlertKind;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * Constructor method for Crm.ClientAlert
     * @uses Crm_ClientAlert::setAlert()
     * @uses Crm_ClientAlert::setAlertColor()
     * @uses Crm_ClientAlert::setAlertKind()
     * @uses Crm_ClientAlert::setClientId()
     * @uses Crm_ClientAlert::setClientName()
     * @uses Crm_ClientAlert::setLastUpdateDateTime()
     * @param \patest\StructType\GlobalString $alert
     * @param string $alertColor
     * @param string $alertKind
     * @param string $clientId
     * @param string $clientName
     * @param string $lastUpdateDateTime
     */
    public function __construct(\patest\StructType\GlobalString $alert = null, $alertColor = null, $alertKind = null, $clientId = null, $clientName = null, $lastUpdateDateTime = null)
    {
        $this
            ->setAlert($alert)
            ->setAlertColor($alertColor)
            ->setAlertKind($alertKind)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setLastUpdateDateTime($lastUpdateDateTime);
    }
    /**
     * Get Alert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAlert()
    {
        return isset($this->Alert) ? $this->Alert : null;
    }
    /**
     * Set Alert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $alert
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setAlert(\patest\StructType\GlobalString $alert = null)
    {
        if (is_null($alert) || (is_array($alert) && empty($alert))) {
            unset($this->Alert);
        } else {
            $this->Alert = $alert;
        }
        return $this;
    }
    /**
     * Get AlertColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlertColor()
    {
        return isset($this->AlertColor) ? $this->AlertColor : null;
    }
    /**
     * Set AlertColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alertColor
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setAlertColor($alertColor = null)
    {
        // validation for constraint: string
        if (!is_null($alertColor) && !is_string($alertColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alertColor, true), gettype($alertColor)), __LINE__);
        }
        if (is_null($alertColor) || (is_array($alertColor) && empty($alertColor))) {
            unset($this->AlertColor);
        } else {
            $this->AlertColor = $alertColor;
        }
        return $this;
    }
    /**
     * Get AlertKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlertKind()
    {
        return isset($this->AlertKind) ? $this->AlertKind : null;
    }
    /**
     * Set AlertKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ClientAlertKind::valueIsValid()
     * @uses \patest\EnumType\ClientAlertKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $alertKind
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setAlertKind($alertKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ClientAlertKind::valueIsValid($alertKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ClientAlertKind', is_array($alertKind) ? implode(', ', $alertKind) : var_export($alertKind, true), implode(', ', \patest\EnumType\ClientAlertKind::getValidValues())), __LINE__);
        }
        if (is_null($alertKind) || (is_array($alertKind) && empty($alertKind))) {
            unset($this->AlertKind);
        } else {
            $this->AlertKind = $alertKind;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Crm_ClientAlert
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
}
