<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientActivityJournalFilter StructType
 * @subpackage Structs
 */
class Crm_ClientActivityJournalFilter extends FilterEntity
{
    /**
     * The AcivitiesByGroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AcivitiesByGroupType;
    /**
     * The ActivityDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDateFrom;
    /**
     * The ActivityDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDateTo;
    /**
     * The ActivityDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityDateType;
    /**
     * The ActivityGroupType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityGroupType;
    /**
     * The ActivityGroupTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActivityGroupTypes;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Crm.ClientActivityJournalFilter
     * @uses Crm_ClientActivityJournalFilter::setAcivitiesByGroupType()
     * @uses Crm_ClientActivityJournalFilter::setActivityDateFrom()
     * @uses Crm_ClientActivityJournalFilter::setActivityDateTo()
     * @uses Crm_ClientActivityJournalFilter::setActivityDateType()
     * @uses Crm_ClientActivityJournalFilter::setActivityGroupType()
     * @uses Crm_ClientActivityJournalFilter::setActivityGroupTypes()
     * @uses Crm_ClientActivityJournalFilter::setApplicationChannel()
     * @uses Crm_ClientActivityJournalFilter::setTransactionNumber()
     * @param string $acivitiesByGroupType
     * @param string $activityDateFrom
     * @param string $activityDateTo
     * @param string $activityDateType
     * @param string $activityGroupType
     * @param string $activityGroupTypes
     * @param string $applicationChannel
     * @param int $transactionNumber
     */
    public function __construct($acivitiesByGroupType = null, $activityDateFrom = null, $activityDateTo = null, $activityDateType = null, $activityGroupType = null, $activityGroupTypes = null, $applicationChannel = null, $transactionNumber = null)
    {
        $this
            ->setAcivitiesByGroupType($acivitiesByGroupType)
            ->setActivityDateFrom($activityDateFrom)
            ->setActivityDateTo($activityDateTo)
            ->setActivityDateType($activityDateType)
            ->setActivityGroupType($activityGroupType)
            ->setActivityGroupTypes($activityGroupTypes)
            ->setApplicationChannel($applicationChannel)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AcivitiesByGroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAcivitiesByGroupType()
    {
        return isset($this->AcivitiesByGroupType) ? $this->AcivitiesByGroupType : null;
    }
    /**
     * Set AcivitiesByGroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $acivitiesByGroupType
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setAcivitiesByGroupType($acivitiesByGroupType = null)
    {
        // validation for constraint: string
        if (!is_null($acivitiesByGroupType) && !is_string($acivitiesByGroupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acivitiesByGroupType, true), gettype($acivitiesByGroupType)), __LINE__);
        }
        if (is_null($acivitiesByGroupType) || (is_array($acivitiesByGroupType) && empty($acivitiesByGroupType))) {
            unset($this->AcivitiesByGroupType);
        } else {
            $this->AcivitiesByGroupType = $acivitiesByGroupType;
        }
        return $this;
    }
    /**
     * Get ActivityDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDateFrom()
    {
        return isset($this->ActivityDateFrom) ? $this->ActivityDateFrom : null;
    }
    /**
     * Set ActivityDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityDateFrom
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setActivityDateFrom($activityDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($activityDateFrom) && !is_string($activityDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDateFrom, true), gettype($activityDateFrom)), __LINE__);
        }
        if (is_null($activityDateFrom) || (is_array($activityDateFrom) && empty($activityDateFrom))) {
            unset($this->ActivityDateFrom);
        } else {
            $this->ActivityDateFrom = $activityDateFrom;
        }
        return $this;
    }
    /**
     * Get ActivityDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDateTo()
    {
        return isset($this->ActivityDateTo) ? $this->ActivityDateTo : null;
    }
    /**
     * Set ActivityDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityDateTo
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setActivityDateTo($activityDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($activityDateTo) && !is_string($activityDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityDateTo, true), gettype($activityDateTo)), __LINE__);
        }
        if (is_null($activityDateTo) || (is_array($activityDateTo) && empty($activityDateTo))) {
            unset($this->ActivityDateTo);
        } else {
            $this->ActivityDateTo = $activityDateTo;
        }
        return $this;
    }
    /**
     * Get ActivityDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityDateType()
    {
        return isset($this->ActivityDateType) ? $this->ActivityDateType : null;
    }
    /**
     * Set ActivityDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DateEnum::valueIsValid()
     * @uses \patest\EnumType\DateEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityDateType
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setActivityDateType($activityDateType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DateEnum::valueIsValid($activityDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DateEnum', is_array($activityDateType) ? implode(', ', $activityDateType) : var_export($activityDateType, true), implode(', ', \patest\EnumType\DateEnum::getValidValues())), __LINE__);
        }
        if (is_null($activityDateType) || (is_array($activityDateType) && empty($activityDateType))) {
            unset($this->ActivityDateType);
        } else {
            $this->ActivityDateType = $activityDateType;
        }
        return $this;
    }
    /**
     * Get ActivityGroupType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityGroupType()
    {
        return isset($this->ActivityGroupType) ? $this->ActivityGroupType : null;
    }
    /**
     * Set ActivityGroupType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActivityGroupType::valueIsValid()
     * @uses \patest\EnumType\ActivityGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $activityGroupType
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setActivityGroupType($activityGroupType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActivityGroupType::valueIsValid($activityGroupType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActivityGroupType', is_array($activityGroupType) ? implode(', ', $activityGroupType) : var_export($activityGroupType, true), implode(', ', \patest\EnumType\ActivityGroupType::getValidValues())), __LINE__);
        }
        if (is_null($activityGroupType) || (is_array($activityGroupType) && empty($activityGroupType))) {
            unset($this->ActivityGroupType);
        } else {
            $this->ActivityGroupType = $activityGroupType;
        }
        return $this;
    }
    /**
     * Get ActivityGroupTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivityGroupTypes()
    {
        return isset($this->ActivityGroupTypes) ? $this->ActivityGroupTypes : null;
    }
    /**
     * Set ActivityGroupTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activityGroupTypes
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setActivityGroupTypes($activityGroupTypes = null)
    {
        // validation for constraint: string
        if (!is_null($activityGroupTypes) && !is_string($activityGroupTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityGroupTypes, true), gettype($activityGroupTypes)), __LINE__);
        }
        if (is_null($activityGroupTypes) || (is_array($activityGroupTypes) && empty($activityGroupTypes))) {
            unset($this->ActivityGroupTypes);
        } else {
            $this->ActivityGroupTypes = $activityGroupTypes;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Crm_ClientActivityJournalFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
