<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.ClientActivityJournalEntry StructType
 * @subpackage Structs
 */
class Crm_ClientActivityJournalEntry extends Foundation_JournalEntry
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientIdFor
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientIdFor;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The IconId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IconId;
    /**
     * The Link1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Link1;
    /**
     * The Link2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Link2;
    /**
     * The NormalizedData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedData;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The RelatedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedEntityId;
    /**
     * The RelatedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityName;
    /**
     * The Topic
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Topic;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The TypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TypeId;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TypeName;
    /**
     * Constructor method for Crm.ClientActivityJournalEntry
     * @uses Crm_ClientActivityJournalEntry::setClientId()
     * @uses Crm_ClientActivityJournalEntry::setClientIdFor()
     * @uses Crm_ClientActivityJournalEntry::setClientName()
     * @uses Crm_ClientActivityJournalEntry::setIconId()
     * @uses Crm_ClientActivityJournalEntry::setLink1()
     * @uses Crm_ClientActivityJournalEntry::setLink2()
     * @uses Crm_ClientActivityJournalEntry::setNormalizedData()
     * @uses Crm_ClientActivityJournalEntry::setNotes()
     * @uses Crm_ClientActivityJournalEntry::setRelatedEntityId()
     * @uses Crm_ClientActivityJournalEntry::setRelatedEntityName()
     * @uses Crm_ClientActivityJournalEntry::setTopic()
     * @uses Crm_ClientActivityJournalEntry::setTransactionNumber()
     * @uses Crm_ClientActivityJournalEntry::setTransactionReferenceNumber()
     * @uses Crm_ClientActivityJournalEntry::setTypeId()
     * @uses Crm_ClientActivityJournalEntry::setTypeName()
     * @param string $clientId
     * @param string $clientIdFor
     * @param string $clientName
     * @param int $iconId
     * @param string $link1
     * @param string $link2
     * @param string $normalizedData
     * @param string $notes
     * @param string $relatedEntityId
     * @param string $relatedEntityName
     * @param string $topic
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     * @param string $typeId
     * @param \patest\StructType\GlobalString $typeName
     */
    public function __construct($clientId = null, $clientIdFor = null, $clientName = null, $iconId = null, $link1 = null, $link2 = null, $normalizedData = null, $notes = null, $relatedEntityId = null, $relatedEntityName = null, $topic = null, $transactionNumber = null, $transactionReferenceNumber = null, $typeId = null, \patest\StructType\GlobalString $typeName = null)
    {
        $this
            ->setClientId($clientId)
            ->setClientIdFor($clientIdFor)
            ->setClientName($clientName)
            ->setIconId($iconId)
            ->setLink1($link1)
            ->setLink2($link2)
            ->setNormalizedData($normalizedData)
            ->setNotes($notes)
            ->setRelatedEntityId($relatedEntityId)
            ->setRelatedEntityName($relatedEntityName)
            ->setTopic($topic)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setTypeId($typeId)
            ->setTypeName($typeName);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientIdFor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIdFor()
    {
        return isset($this->ClientIdFor) ? $this->ClientIdFor : null;
    }
    /**
     * Set ClientIdFor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIdFor
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setClientIdFor($clientIdFor = null)
    {
        // validation for constraint: string
        if (!is_null($clientIdFor) && !is_string($clientIdFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIdFor, true), gettype($clientIdFor)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientIdFor) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientIdFor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientIdFor, true)), __LINE__);
        }
        if (is_null($clientIdFor) || (is_array($clientIdFor) && empty($clientIdFor))) {
            unset($this->ClientIdFor);
        } else {
            $this->ClientIdFor = $clientIdFor;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get IconId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIconId()
    {
        return isset($this->IconId) ? $this->IconId : null;
    }
    /**
     * Set IconId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iconId
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setIconId($iconId = null)
    {
        // validation for constraint: int
        if (!is_null($iconId) && !(is_int($iconId) || ctype_digit($iconId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iconId, true), gettype($iconId)), __LINE__);
        }
        if (is_null($iconId) || (is_array($iconId) && empty($iconId))) {
            unset($this->IconId);
        } else {
            $this->IconId = $iconId;
        }
        return $this;
    }
    /**
     * Get Link1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLink1()
    {
        return isset($this->Link1) ? $this->Link1 : null;
    }
    /**
     * Set Link1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $link1
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setLink1($link1 = null)
    {
        // validation for constraint: string
        if (!is_null($link1) && !is_string($link1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link1, true), gettype($link1)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($link1) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $link1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($link1, true)), __LINE__);
        }
        if (is_null($link1) || (is_array($link1) && empty($link1))) {
            unset($this->Link1);
        } else {
            $this->Link1 = $link1;
        }
        return $this;
    }
    /**
     * Get Link2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLink2()
    {
        return isset($this->Link2) ? $this->Link2 : null;
    }
    /**
     * Set Link2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $link2
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setLink2($link2 = null)
    {
        // validation for constraint: string
        if (!is_null($link2) && !is_string($link2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link2, true), gettype($link2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($link2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $link2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($link2, true)), __LINE__);
        }
        if (is_null($link2) || (is_array($link2) && empty($link2))) {
            unset($this->Link2);
        } else {
            $this->Link2 = $link2;
        }
        return $this;
    }
    /**
     * Get NormalizedData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedData()
    {
        return isset($this->NormalizedData) ? $this->NormalizedData : null;
    }
    /**
     * Set NormalizedData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedData
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setNormalizedData($normalizedData = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedData) && !is_string($normalizedData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedData, true), gettype($normalizedData)), __LINE__);
        }
        if (is_null($normalizedData) || (is_array($normalizedData) && empty($normalizedData))) {
            unset($this->NormalizedData);
        } else {
            $this->NormalizedData = $normalizedData;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get RelatedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityId()
    {
        return isset($this->RelatedEntityId) ? $this->RelatedEntityId : null;
    }
    /**
     * Set RelatedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityId
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setRelatedEntityId($relatedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityId) && !is_string($relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityId, true), gettype($relatedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedEntityId, true)), __LINE__);
        }
        if (is_null($relatedEntityId) || (is_array($relatedEntityId) && empty($relatedEntityId))) {
            unset($this->RelatedEntityId);
        } else {
            $this->RelatedEntityId = $relatedEntityId;
        }
        return $this;
    }
    /**
     * Get RelatedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityName()
    {
        return isset($this->RelatedEntityName) ? $this->RelatedEntityName : null;
    }
    /**
     * Set RelatedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityName
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setRelatedEntityName($relatedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityName) && !is_string($relatedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityName, true), gettype($relatedEntityName)), __LINE__);
        }
        if (is_null($relatedEntityName) || (is_array($relatedEntityName) && empty($relatedEntityName))) {
            unset($this->RelatedEntityName);
        } else {
            $this->RelatedEntityName = $relatedEntityName;
        }
        return $this;
    }
    /**
     * Get Topic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTopic()
    {
        return isset($this->Topic) ? $this->Topic : null;
    }
    /**
     * Set Topic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ActivityGroupType::valueIsValid()
     * @uses \patest\EnumType\ActivityGroupType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $topic
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setTopic($topic = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ActivityGroupType::valueIsValid($topic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ActivityGroupType', is_array($topic) ? implode(', ', $topic) : var_export($topic, true), implode(', ', \patest\EnumType\ActivityGroupType::getValidValues())), __LINE__);
        }
        if (is_null($topic) || (is_array($topic) && empty($topic))) {
            unset($this->Topic);
        } else {
            $this->Topic = $topic;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get TypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeId()
    {
        return isset($this->TypeId) ? $this->TypeId : null;
    }
    /**
     * Set TypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeId
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setTypeId($typeId = null)
    {
        // validation for constraint: string
        if (!is_null($typeId) && !is_string($typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeId, true), gettype($typeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($typeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $typeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($typeId, true)), __LINE__);
        }
        if (is_null($typeId) || (is_array($typeId) && empty($typeId))) {
            unset($this->TypeId);
        } else {
            $this->TypeId = $typeId;
        }
        return $this;
    }
    /**
     * Get TypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTypeName()
    {
        return isset($this->TypeName) ? $this->TypeName : null;
    }
    /**
     * Set TypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $typeName
     * @return \patest\StructType\Crm_ClientActivityJournalEntry
     */
    public function setTypeName(\patest\StructType\GlobalString $typeName = null)
    {
        if (is_null($typeName) || (is_array($typeName) && empty($typeName))) {
            unset($this->TypeName);
        } else {
            $this->TypeName = $typeName;
        }
        return $this;
    }
}
