<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.Client4Printing StructType
 * @subpackage Structs
 */
class Crm_Client4Printing extends DistributableEntity
{
    /**
     * The AccountLinkCreatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountLinkCreatedAt;
    /**
     * The AccountLinkIsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AccountLinkIsActive;
    /**
     * The AccountLinkScope
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountLinkScope;
    /**
     * The AccountLinkUpdatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountLinkUpdatedAt;
    /**
     * The AddressDetailIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AddressDetailIds
     */
    public $AddressDetailIds;
    /**
     * The AddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_AddressDetail4Printing
     */
    public $AddressDetails;
    /**
     * The AddressDetails4Printing
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails
     */
    public $AddressDetails4Printing;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddresses
     */
    public $Addresses;
    /**
     * The AllOrganizationUnitIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllOrganizationUnitIds
     */
    public $AllOrganizationUnitIds;
    /**
     * The AnonymousDonations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AnonymousDonations;
    /**
     * The AssociationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AssociationIds
     */
    public $AssociationIds;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientBalance
     */
    public $Balance;
    /**
     * The BulkOperationExternalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BulkOperationExternalId;
    /**
     * The BulkOperationMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BulkOperationMap;
    /**
     * The BusinessAddress
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PostalAddress
     */
    public $BusinessAddress;
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing
     */
    public $ClientTypes;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_ContactDetail4Printing
     */
    public $ContactDetails;
    /**
     * The ContactDetails4Printing
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail
     */
    public $ContactDetails4Printing;
    /**
     * The ContactMeByServiceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ContactMeByServiceIds
     */
    public $ContactMeByServiceIds;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientContacts
     */
    public $Contacts;
    /**
     * The CreatedUser
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_UserAudit
     */
    public $CreatedUser;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CrmCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmCode;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The DataProtectionDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_DataProtectionDetail
     */
    public $DataProtectionDetails;
    /**
     * The DisplayAddress
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayAddress;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The DisplayNoteInClientAlerts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayNoteInClientAlerts;
    /**
     * The DisplayPhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayPhone;
    /**
     * The DoNotMerge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotMerge;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExemptValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExemptValidUntil;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientExtraFields
     */
    public $ExtraFields;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The ForceCreate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForceCreate;
    /**
     * The GrantSoftCreditToRelatives
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GrantSoftCreditToRelatives;
    /**
     * The HasMoreThanOneRelevantMembership
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasMoreThanOneRelevantMembership;
    /**
     * The HomeAddress
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PostalAddress
     */
    public $HomeAddress;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The ImageId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImageId;
    /**
     * The IsCrmAccessAllowed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCrmAccessAllowed;
    /**
     * The IsDataProtectionMissing
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDataProtectionMissing;
    /**
     * The IsGroupLeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupLeader;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The IsOrganizationData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOrganizationData;
    /**
     * The IsTravelGroupLeader
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTravelGroupLeader;
    /**
     * The IsUnconfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUnconfirmed;
    /**
     * The LastUpdateAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastUpdateAuditId;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The Login
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_LoginDetail
     */
    public $Login;
    /**
     * The LoyaltyPointsBalance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LoyaltyPointsBalance;
    /**
     * The MapToCrmSyncEntity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MapToCrmSyncEntity;
    /**
     * The MatchesGifts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MatchesGifts;
    /**
     * The MatchingGiftEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MatchingGiftEmail;
    /**
     * The MatchingGiftMaximum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftMaximum;
    /**
     * The MatchingGiftMinimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftMinimum;
    /**
     * The MatchingGiftPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MatchingGiftPercent;
    /**
     * The MergedWith
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MergedWith;
    /**
     * The MobileDeviceInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobileDeviceInfo;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\OrganizationUnitIds
     */
    public $OrganizationUnitIds;
    /**
     * The PassPhrases
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassPhrases;
    /**
     * The Picture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientImage4Printing
     */
    public $Picture;
    /**
     * The PointsSummary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointsSummary;
    /**
     * The PreferenceDetails
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_Preference
     */
    public $PreferenceDetails;
    /**
     * The PreferenceIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PreferenceIds
     */
    public $PreferenceIds;
    /**
     * The PreferredCulture
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ScreenParts_SupportedCulture
     */
    public $PreferredCulture;
    /**
     * The PreferredCultureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredCultureId;
    /**
     * The PrimaryAddress
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PostalAddress
     */
    public $PrimaryAddress;
    /**
     * The PrimaryMembershipExpiry
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrimaryMembershipExpiry;
    /**
     * The PrimaryMembershipId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrimaryMembershipId;
    /**
     * The PrimaryMembershipName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PrimaryMembershipName;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The QualityPointsBalance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QualityPointsBalance;
    /**
     * The RelatedClients
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_RelatedClient
     */
    public $RelatedClients;
    /**
     * The RelocationWaveIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelocationWaveIds
     */
    public $RelocationWaveIds;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_Remark
     */
    public $Remarks;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_ClientStatusDetail
     */
    public $Status;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The TravelGroupNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TravelGroupNumber;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The TypeString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeString;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite;
    /**
     * Constructor method for Crm.Client4Printing
     * @uses Crm_Client4Printing::setAccountLinkCreatedAt()
     * @uses Crm_Client4Printing::setAccountLinkIsActive()
     * @uses Crm_Client4Printing::setAccountLinkScope()
     * @uses Crm_Client4Printing::setAccountLinkUpdatedAt()
     * @uses Crm_Client4Printing::setAddressDetailIds()
     * @uses Crm_Client4Printing::setAddressDetails()
     * @uses Crm_Client4Printing::setAddressDetails4Printing()
     * @uses Crm_Client4Printing::setAddresses()
     * @uses Crm_Client4Printing::setAllOrganizationUnitIds()
     * @uses Crm_Client4Printing::setAnonymousDonations()
     * @uses Crm_Client4Printing::setAssociationIds()
     * @uses Crm_Client4Printing::setBalance()
     * @uses Crm_Client4Printing::setBulkOperationExternalId()
     * @uses Crm_Client4Printing::setBulkOperationMap()
     * @uses Crm_Client4Printing::setBusinessAddress()
     * @uses Crm_Client4Printing::setBusinessPhone()
     * @uses Crm_Client4Printing::setClientTypes()
     * @uses Crm_Client4Printing::setContactDetails()
     * @uses Crm_Client4Printing::setContactDetails4Printing()
     * @uses Crm_Client4Printing::setContactMeByServiceIds()
     * @uses Crm_Client4Printing::setContacts()
     * @uses Crm_Client4Printing::setCreatedUser()
     * @uses Crm_Client4Printing::setCreationAuditId()
     * @uses Crm_Client4Printing::setCreationDateTime()
     * @uses Crm_Client4Printing::setCrmCode()
     * @uses Crm_Client4Printing::setCrmId()
     * @uses Crm_Client4Printing::setCultureId()
     * @uses Crm_Client4Printing::setDataProtectionDetails()
     * @uses Crm_Client4Printing::setDisplayAddress()
     * @uses Crm_Client4Printing::setDisplayName()
     * @uses Crm_Client4Printing::setDisplayNoteInClientAlerts()
     * @uses Crm_Client4Printing::setDisplayPhone()
     * @uses Crm_Client4Printing::setDoNotMerge()
     * @uses Crm_Client4Printing::setEmail()
     * @uses Crm_Client4Printing::setExemptValidUntil()
     * @uses Crm_Client4Printing::setExternalId()
     * @uses Crm_Client4Printing::setExtraFields()
     * @uses Crm_Client4Printing::setFax()
     * @uses Crm_Client4Printing::setForceCreate()
     * @uses Crm_Client4Printing::setGrantSoftCreditToRelatives()
     * @uses Crm_Client4Printing::setHasMoreThanOneRelevantMembership()
     * @uses Crm_Client4Printing::setHomeAddress()
     * @uses Crm_Client4Printing::setHomePhone()
     * @uses Crm_Client4Printing::setImageId()
     * @uses Crm_Client4Printing::setIsCrmAccessAllowed()
     * @uses Crm_Client4Printing::setIsDataProtectionMissing()
     * @uses Crm_Client4Printing::setIsGroupLeader()
     * @uses Crm_Client4Printing::setIsHidden()
     * @uses Crm_Client4Printing::setIsOrganizationData()
     * @uses Crm_Client4Printing::setIsTravelGroupLeader()
     * @uses Crm_Client4Printing::setIsUnconfirmed()
     * @uses Crm_Client4Printing::setLastUpdateAuditId()
     * @uses Crm_Client4Printing::setLastUpdateDateTime()
     * @uses Crm_Client4Printing::setLedgerId()
     * @uses Crm_Client4Printing::setLogin()
     * @uses Crm_Client4Printing::setLoyaltyPointsBalance()
     * @uses Crm_Client4Printing::setMapToCrmSyncEntity()
     * @uses Crm_Client4Printing::setMatchesGifts()
     * @uses Crm_Client4Printing::setMatchingGiftEmail()
     * @uses Crm_Client4Printing::setMatchingGiftMaximum()
     * @uses Crm_Client4Printing::setMatchingGiftMinimum()
     * @uses Crm_Client4Printing::setMatchingGiftPercent()
     * @uses Crm_Client4Printing::setMergedWith()
     * @uses Crm_Client4Printing::setMobileDeviceInfo()
     * @uses Crm_Client4Printing::setMobilePhone()
     * @uses Crm_Client4Printing::setNote()
     * @uses Crm_Client4Printing::setOrganizationUnitId()
     * @uses Crm_Client4Printing::setOrganizationUnitIds()
     * @uses Crm_Client4Printing::setPassPhrases()
     * @uses Crm_Client4Printing::setPicture()
     * @uses Crm_Client4Printing::setPointsSummary()
     * @uses Crm_Client4Printing::setPreferenceDetails()
     * @uses Crm_Client4Printing::setPreferenceIds()
     * @uses Crm_Client4Printing::setPreferredCulture()
     * @uses Crm_Client4Printing::setPreferredCultureId()
     * @uses Crm_Client4Printing::setPrimaryAddress()
     * @uses Crm_Client4Printing::setPrimaryMembershipExpiry()
     * @uses Crm_Client4Printing::setPrimaryMembershipId()
     * @uses Crm_Client4Printing::setPrimaryMembershipName()
     * @uses Crm_Client4Printing::setProjectIdentifierId()
     * @uses Crm_Client4Printing::setQualityPointsBalance()
     * @uses Crm_Client4Printing::setRelatedClients()
     * @uses Crm_Client4Printing::setRelocationWaveIds()
     * @uses Crm_Client4Printing::setRemarks()
     * @uses Crm_Client4Printing::setSalutationIndividualText()
     * @uses Crm_Client4Printing::setStatus()
     * @uses Crm_Client4Printing::setTaxExemptNumber()
     * @uses Crm_Client4Printing::setTravelGroupNumber()
     * @uses Crm_Client4Printing::setType()
     * @uses Crm_Client4Printing::setTypeString()
     * @uses Crm_Client4Printing::setWebSite()
     * @param string $accountLinkCreatedAt
     * @param bool $accountLinkIsActive
     * @param string $accountLinkScope
     * @param string $accountLinkUpdatedAt
     * @param \patest\StructType\AddressDetailIds $addressDetailIds
     * @param \patest\StructType\RecordSetOfCrm_AddressDetail4Printing $addressDetails
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @param \patest\StructType\AllOrganizationUnitIds $allOrganizationUnitIds
     * @param bool $anonymousDonations
     * @param \patest\StructType\AssociationIds $associationIds
     * @param \patest\StructType\Crm_ClientBalance $balance
     * @param string $bulkOperationExternalId
     * @param int $bulkOperationMap
     * @param \patest\StructType\Crm_PostalAddress $businessAddress
     * @param string $businessPhone
     * @param \patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing $clientTypes
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail4Printing $contactDetails
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing
     * @param \patest\StructType\ContactMeByServiceIds $contactMeByServiceIds
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @param \patest\StructType\Crm_UserAudit $createdUser
     * @param int $creationAuditId
     * @param string $creationDateTime
     * @param string $crmCode
     * @param string $crmId
     * @param int $cultureId
     * @param \patest\StructType\RecordSetOfCrm_DataProtectionDetail $dataProtectionDetails
     * @param string $displayAddress
     * @param string $displayName
     * @param bool $displayNoteInClientAlerts
     * @param string $displayPhone
     * @param bool $doNotMerge
     * @param string $email
     * @param string $exemptValidUntil
     * @param string $externalId
     * @param \patest\StructType\Crm_ClientExtraFields $extraFields
     * @param string $fax
     * @param bool $forceCreate
     * @param bool $grantSoftCreditToRelatives
     * @param bool $hasMoreThanOneRelevantMembership
     * @param \patest\StructType\Crm_PostalAddress $homeAddress
     * @param string $homePhone
     * @param string $imageId
     * @param bool $isCrmAccessAllowed
     * @param bool $isDataProtectionMissing
     * @param bool $isGroupLeader
     * @param bool $isHidden
     * @param bool $isOrganizationData
     * @param bool $isTravelGroupLeader
     * @param bool $isUnconfirmed
     * @param int $lastUpdateAuditId
     * @param string $lastUpdateDateTime
     * @param string $ledgerId
     * @param \patest\StructType\Crm_LoginDetail $login
     * @param float $loyaltyPointsBalance
     * @param int $mapToCrmSyncEntity
     * @param bool $matchesGifts
     * @param string $matchingGiftEmail
     * @param int $matchingGiftMaximum
     * @param int $matchingGiftMinimum
     * @param int $matchingGiftPercent
     * @param string $mergedWith
     * @param string $mobileDeviceInfo
     * @param string $mobilePhone
     * @param \patest\StructType\GlobalString $note
     * @param string $organizationUnitId
     * @param \patest\StructType\OrganizationUnitIds $organizationUnitIds
     * @param string $passPhrases
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @param string $pointsSummary
     * @param \patest\StructType\RecordSetOfCrm_Preference $preferenceDetails
     * @param \patest\StructType\PreferenceIds $preferenceIds
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     * @param string $preferredCultureId
     * @param \patest\StructType\Crm_PostalAddress $primaryAddress
     * @param string $primaryMembershipExpiry
     * @param string $primaryMembershipId
     * @param \patest\StructType\GlobalString $primaryMembershipName
     * @param string $projectIdentifierId
     * @param float $qualityPointsBalance
     * @param \patest\StructType\RecordSetOfCrm_RelatedClient $relatedClients
     * @param \patest\StructType\RelocationWaveIds $relocationWaveIds
     * @param \patest\StructType\RecordSetOfCrm_Remark $remarks
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param \patest\StructType\Crm_ClientStatusDetail $status
     * @param string $taxExemptNumber
     * @param int $travelGroupNumber
     * @param string[] $type
     * @param string $typeString
     * @param string $webSite
     */
    public function __construct($accountLinkCreatedAt = null, $accountLinkIsActive = null, $accountLinkScope = null, $accountLinkUpdatedAt = null, \patest\StructType\AddressDetailIds $addressDetailIds = null, \patest\StructType\RecordSetOfCrm_AddressDetail4Printing $addressDetails = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing = null, \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null, \patest\StructType\AllOrganizationUnitIds $allOrganizationUnitIds = null, $anonymousDonations = null, \patest\StructType\AssociationIds $associationIds = null, \patest\StructType\Crm_ClientBalance $balance = null, $bulkOperationExternalId = null, $bulkOperationMap = null, \patest\StructType\Crm_PostalAddress $businessAddress = null, $businessPhone = null, \patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing $clientTypes = null, \patest\StructType\RecordSetOfCrm_ContactDetail4Printing $contactDetails = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing = null, \patest\StructType\ContactMeByServiceIds $contactMeByServiceIds = null, \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null, \patest\StructType\Crm_UserAudit $createdUser = null, $creationAuditId = null, $creationDateTime = null, $crmCode = null, $crmId = null, $cultureId = null, \patest\StructType\RecordSetOfCrm_DataProtectionDetail $dataProtectionDetails = null, $displayAddress = null, $displayName = null, $displayNoteInClientAlerts = null, $displayPhone = null, $doNotMerge = null, $email = null, $exemptValidUntil = null, $externalId = null, \patest\StructType\Crm_ClientExtraFields $extraFields = null, $fax = null, $forceCreate = null, $grantSoftCreditToRelatives = null, $hasMoreThanOneRelevantMembership = null, \patest\StructType\Crm_PostalAddress $homeAddress = null, $homePhone = null, $imageId = null, $isCrmAccessAllowed = null, $isDataProtectionMissing = null, $isGroupLeader = null, $isHidden = null, $isOrganizationData = null, $isTravelGroupLeader = null, $isUnconfirmed = null, $lastUpdateAuditId = null, $lastUpdateDateTime = null, $ledgerId = null, \patest\StructType\Crm_LoginDetail $login = null, $loyaltyPointsBalance = null, $mapToCrmSyncEntity = null, $matchesGifts = null, $matchingGiftEmail = null, $matchingGiftMaximum = null, $matchingGiftMinimum = null, $matchingGiftPercent = null, $mergedWith = null, $mobileDeviceInfo = null, $mobilePhone = null, \patest\StructType\GlobalString $note = null, $organizationUnitId = null, \patest\StructType\OrganizationUnitIds $organizationUnitIds = null, $passPhrases = null, \patest\StructType\Crm_ClientImage4Printing $picture = null, $pointsSummary = null, \patest\StructType\RecordSetOfCrm_Preference $preferenceDetails = null, \patest\StructType\PreferenceIds $preferenceIds = null, \patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null, $preferredCultureId = null, \patest\StructType\Crm_PostalAddress $primaryAddress = null, $primaryMembershipExpiry = null, $primaryMembershipId = null, \patest\StructType\GlobalString $primaryMembershipName = null, $projectIdentifierId = null, $qualityPointsBalance = null, \patest\StructType\RecordSetOfCrm_RelatedClient $relatedClients = null, \patest\StructType\RelocationWaveIds $relocationWaveIds = null, \patest\StructType\RecordSetOfCrm_Remark $remarks = null, \patest\StructType\GlobalString $salutationIndividualText = null, \patest\StructType\Crm_ClientStatusDetail $status = null, $taxExemptNumber = null, $travelGroupNumber = null, array $type = array(), $typeString = null, $webSite = null)
    {
        $this
            ->setAccountLinkCreatedAt($accountLinkCreatedAt)
            ->setAccountLinkIsActive($accountLinkIsActive)
            ->setAccountLinkScope($accountLinkScope)
            ->setAccountLinkUpdatedAt($accountLinkUpdatedAt)
            ->setAddressDetailIds($addressDetailIds)
            ->setAddressDetails($addressDetails)
            ->setAddressDetails4Printing($addressDetails4Printing)
            ->setAddresses($addresses)
            ->setAllOrganizationUnitIds($allOrganizationUnitIds)
            ->setAnonymousDonations($anonymousDonations)
            ->setAssociationIds($associationIds)
            ->setBalance($balance)
            ->setBulkOperationExternalId($bulkOperationExternalId)
            ->setBulkOperationMap($bulkOperationMap)
            ->setBusinessAddress($businessAddress)
            ->setBusinessPhone($businessPhone)
            ->setClientTypes($clientTypes)
            ->setContactDetails($contactDetails)
            ->setContactDetails4Printing($contactDetails4Printing)
            ->setContactMeByServiceIds($contactMeByServiceIds)
            ->setContacts($contacts)
            ->setCreatedUser($createdUser)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setCrmCode($crmCode)
            ->setCrmId($crmId)
            ->setCultureId($cultureId)
            ->setDataProtectionDetails($dataProtectionDetails)
            ->setDisplayAddress($displayAddress)
            ->setDisplayName($displayName)
            ->setDisplayNoteInClientAlerts($displayNoteInClientAlerts)
            ->setDisplayPhone($displayPhone)
            ->setDoNotMerge($doNotMerge)
            ->setEmail($email)
            ->setExemptValidUntil($exemptValidUntil)
            ->setExternalId($externalId)
            ->setExtraFields($extraFields)
            ->setFax($fax)
            ->setForceCreate($forceCreate)
            ->setGrantSoftCreditToRelatives($grantSoftCreditToRelatives)
            ->setHasMoreThanOneRelevantMembership($hasMoreThanOneRelevantMembership)
            ->setHomeAddress($homeAddress)
            ->setHomePhone($homePhone)
            ->setImageId($imageId)
            ->setIsCrmAccessAllowed($isCrmAccessAllowed)
            ->setIsDataProtectionMissing($isDataProtectionMissing)
            ->setIsGroupLeader($isGroupLeader)
            ->setIsHidden($isHidden)
            ->setIsOrganizationData($isOrganizationData)
            ->setIsTravelGroupLeader($isTravelGroupLeader)
            ->setIsUnconfirmed($isUnconfirmed)
            ->setLastUpdateAuditId($lastUpdateAuditId)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLedgerId($ledgerId)
            ->setLogin($login)
            ->setLoyaltyPointsBalance($loyaltyPointsBalance)
            ->setMapToCrmSyncEntity($mapToCrmSyncEntity)
            ->setMatchesGifts($matchesGifts)
            ->setMatchingGiftEmail($matchingGiftEmail)
            ->setMatchingGiftMaximum($matchingGiftMaximum)
            ->setMatchingGiftMinimum($matchingGiftMinimum)
            ->setMatchingGiftPercent($matchingGiftPercent)
            ->setMergedWith($mergedWith)
            ->setMobileDeviceInfo($mobileDeviceInfo)
            ->setMobilePhone($mobilePhone)
            ->setNote($note)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitIds($organizationUnitIds)
            ->setPassPhrases($passPhrases)
            ->setPicture($picture)
            ->setPointsSummary($pointsSummary)
            ->setPreferenceDetails($preferenceDetails)
            ->setPreferenceIds($preferenceIds)
            ->setPreferredCulture($preferredCulture)
            ->setPreferredCultureId($preferredCultureId)
            ->setPrimaryAddress($primaryAddress)
            ->setPrimaryMembershipExpiry($primaryMembershipExpiry)
            ->setPrimaryMembershipId($primaryMembershipId)
            ->setPrimaryMembershipName($primaryMembershipName)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setQualityPointsBalance($qualityPointsBalance)
            ->setRelatedClients($relatedClients)
            ->setRelocationWaveIds($relocationWaveIds)
            ->setRemarks($remarks)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setStatus($status)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setTravelGroupNumber($travelGroupNumber)
            ->setType($type)
            ->setTypeString($typeString)
            ->setWebSite($webSite);
    }
    /**
     * Get AccountLinkCreatedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountLinkCreatedAt()
    {
        return isset($this->AccountLinkCreatedAt) ? $this->AccountLinkCreatedAt : null;
    }
    /**
     * Set AccountLinkCreatedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountLinkCreatedAt
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAccountLinkCreatedAt($accountLinkCreatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($accountLinkCreatedAt) && !is_string($accountLinkCreatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountLinkCreatedAt, true), gettype($accountLinkCreatedAt)), __LINE__);
        }
        if (is_null($accountLinkCreatedAt) || (is_array($accountLinkCreatedAt) && empty($accountLinkCreatedAt))) {
            unset($this->AccountLinkCreatedAt);
        } else {
            $this->AccountLinkCreatedAt = $accountLinkCreatedAt;
        }
        return $this;
    }
    /**
     * Get AccountLinkIsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAccountLinkIsActive()
    {
        return isset($this->AccountLinkIsActive) ? $this->AccountLinkIsActive : null;
    }
    /**
     * Set AccountLinkIsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $accountLinkIsActive
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAccountLinkIsActive($accountLinkIsActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($accountLinkIsActive) && !is_bool($accountLinkIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($accountLinkIsActive, true), gettype($accountLinkIsActive)), __LINE__);
        }
        if (is_null($accountLinkIsActive) || (is_array($accountLinkIsActive) && empty($accountLinkIsActive))) {
            unset($this->AccountLinkIsActive);
        } else {
            $this->AccountLinkIsActive = $accountLinkIsActive;
        }
        return $this;
    }
    /**
     * Get AccountLinkScope value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountLinkScope()
    {
        return isset($this->AccountLinkScope) ? $this->AccountLinkScope : null;
    }
    /**
     * Set AccountLinkScope value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatGeekAccountLinkScope::valueIsValid()
     * @uses \patest\EnumType\SeatGeekAccountLinkScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accountLinkScope
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAccountLinkScope($accountLinkScope = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatGeekAccountLinkScope::valueIsValid($accountLinkScope)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatGeekAccountLinkScope', is_array($accountLinkScope) ? implode(', ', $accountLinkScope) : var_export($accountLinkScope, true), implode(', ', \patest\EnumType\SeatGeekAccountLinkScope::getValidValues())), __LINE__);
        }
        if (is_null($accountLinkScope) || (is_array($accountLinkScope) && empty($accountLinkScope))) {
            unset($this->AccountLinkScope);
        } else {
            $this->AccountLinkScope = $accountLinkScope;
        }
        return $this;
    }
    /**
     * Get AccountLinkUpdatedAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountLinkUpdatedAt()
    {
        return isset($this->AccountLinkUpdatedAt) ? $this->AccountLinkUpdatedAt : null;
    }
    /**
     * Set AccountLinkUpdatedAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountLinkUpdatedAt
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAccountLinkUpdatedAt($accountLinkUpdatedAt = null)
    {
        // validation for constraint: string
        if (!is_null($accountLinkUpdatedAt) && !is_string($accountLinkUpdatedAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountLinkUpdatedAt, true), gettype($accountLinkUpdatedAt)), __LINE__);
        }
        if (is_null($accountLinkUpdatedAt) || (is_array($accountLinkUpdatedAt) && empty($accountLinkUpdatedAt))) {
            unset($this->AccountLinkUpdatedAt);
        } else {
            $this->AccountLinkUpdatedAt = $accountLinkUpdatedAt;
        }
        return $this;
    }
    /**
     * Get AddressDetailIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AddressDetailIds|null
     */
    public function getAddressDetailIds()
    {
        return isset($this->AddressDetailIds) ? $this->AddressDetailIds : null;
    }
    /**
     * Set AddressDetailIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AddressDetailIds $addressDetailIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAddressDetailIds(\patest\StructType\AddressDetailIds $addressDetailIds = null)
    {
        if (is_null($addressDetailIds) || (is_array($addressDetailIds) && empty($addressDetailIds))) {
            unset($this->AddressDetailIds);
        } else {
            $this->AddressDetailIds = $addressDetailIds;
        }
        return $this;
    }
    /**
     * Get AddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_AddressDetail4Printing|null
     */
    public function getAddressDetails()
    {
        return isset($this->AddressDetails) ? $this->AddressDetails : null;
    }
    /**
     * Set AddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_AddressDetail4Printing $addressDetails
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAddressDetails(\patest\StructType\RecordSetOfCrm_AddressDetail4Printing $addressDetails = null)
    {
        if (is_null($addressDetails) || (is_array($addressDetails) && empty($addressDetails))) {
            unset($this->AddressDetails);
        } else {
            $this->AddressDetails = $addressDetails;
        }
        return $this;
    }
    /**
     * Get AddressDetails4Printing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails|null
     */
    public function getAddressDetails4Printing()
    {
        return isset($this->AddressDetails4Printing) ? $this->AddressDetails4Printing : null;
    }
    /**
     * Set AddressDetails4Printing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAddressDetails4Printing(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails4Printing = null)
    {
        if (is_null($addressDetails4Printing) || (is_array($addressDetails4Printing) && empty($addressDetails4Printing))) {
            unset($this->AddressDetails4Printing);
        } else {
            $this->AddressDetails4Printing = $addressDetails4Printing;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddresses|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAddresses(\patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get AllOrganizationUnitIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllOrganizationUnitIds|null
     */
    public function getAllOrganizationUnitIds()
    {
        return isset($this->AllOrganizationUnitIds) ? $this->AllOrganizationUnitIds : null;
    }
    /**
     * Set AllOrganizationUnitIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllOrganizationUnitIds $allOrganizationUnitIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAllOrganizationUnitIds(\patest\StructType\AllOrganizationUnitIds $allOrganizationUnitIds = null)
    {
        if (is_null($allOrganizationUnitIds) || (is_array($allOrganizationUnitIds) && empty($allOrganizationUnitIds))) {
            unset($this->AllOrganizationUnitIds);
        } else {
            $this->AllOrganizationUnitIds = $allOrganizationUnitIds;
        }
        return $this;
    }
    /**
     * Get AnonymousDonations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAnonymousDonations()
    {
        return isset($this->AnonymousDonations) ? $this->AnonymousDonations : null;
    }
    /**
     * Set AnonymousDonations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $anonymousDonations
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAnonymousDonations($anonymousDonations = null)
    {
        // validation for constraint: boolean
        if (!is_null($anonymousDonations) && !is_bool($anonymousDonations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anonymousDonations, true), gettype($anonymousDonations)), __LINE__);
        }
        if (is_null($anonymousDonations) || (is_array($anonymousDonations) && empty($anonymousDonations))) {
            unset($this->AnonymousDonations);
        } else {
            $this->AnonymousDonations = $anonymousDonations;
        }
        return $this;
    }
    /**
     * Get AssociationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AssociationIds|null
     */
    public function getAssociationIds()
    {
        return isset($this->AssociationIds) ? $this->AssociationIds : null;
    }
    /**
     * Set AssociationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AssociationIds $associationIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setAssociationIds(\patest\StructType\AssociationIds $associationIds = null)
    {
        if (is_null($associationIds) || (is_array($associationIds) && empty($associationIds))) {
            unset($this->AssociationIds);
        } else {
            $this->AssociationIds = $associationIds;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientBalance|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientBalance $balance
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setBalance(\patest\StructType\Crm_ClientBalance $balance = null)
    {
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get BulkOperationExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulkOperationExternalId()
    {
        return isset($this->BulkOperationExternalId) ? $this->BulkOperationExternalId : null;
    }
    /**
     * Set BulkOperationExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulkOperationExternalId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setBulkOperationExternalId($bulkOperationExternalId = null)
    {
        // validation for constraint: string
        if (!is_null($bulkOperationExternalId) && !is_string($bulkOperationExternalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkOperationExternalId, true), gettype($bulkOperationExternalId)), __LINE__);
        }
        if (is_null($bulkOperationExternalId) || (is_array($bulkOperationExternalId) && empty($bulkOperationExternalId))) {
            unset($this->BulkOperationExternalId);
        } else {
            $this->BulkOperationExternalId = $bulkOperationExternalId;
        }
        return $this;
    }
    /**
     * Get BulkOperationMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBulkOperationMap()
    {
        return isset($this->BulkOperationMap) ? $this->BulkOperationMap : null;
    }
    /**
     * Set BulkOperationMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bulkOperationMap
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setBulkOperationMap($bulkOperationMap = null)
    {
        // validation for constraint: int
        if (!is_null($bulkOperationMap) && !(is_int($bulkOperationMap) || ctype_digit($bulkOperationMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bulkOperationMap, true), gettype($bulkOperationMap)), __LINE__);
        }
        if (is_null($bulkOperationMap) || (is_array($bulkOperationMap) && empty($bulkOperationMap))) {
            unset($this->BulkOperationMap);
        } else {
            $this->BulkOperationMap = $bulkOperationMap;
        }
        return $this;
    }
    /**
     * Get BusinessAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PostalAddress|null
     */
    public function getBusinessAddress()
    {
        return isset($this->BusinessAddress) ? $this->BusinessAddress : null;
    }
    /**
     * Set BusinessAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PostalAddress $businessAddress
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setBusinessAddress(\patest\StructType\Crm_PostalAddress $businessAddress = null)
    {
        if (is_null($businessAddress) || (is_array($businessAddress) && empty($businessAddress))) {
            unset($this->BusinessAddress);
        } else {
            $this->BusinessAddress = $businessAddress;
        }
        return $this;
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing $clientTypes
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setClientTypes(\patest\StructType\RecordSetOfCrm_ClientTypeDetail4Printing $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get ContactDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_ContactDetail4Printing|null
     */
    public function getContactDetails()
    {
        return isset($this->ContactDetails) ? $this->ContactDetails : null;
    }
    /**
     * Set ContactDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_ContactDetail4Printing $contactDetails
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setContactDetails(\patest\StructType\RecordSetOfCrm_ContactDetail4Printing $contactDetails = null)
    {
        if (is_null($contactDetails) || (is_array($contactDetails) && empty($contactDetails))) {
            unset($this->ContactDetails);
        } else {
            $this->ContactDetails = $contactDetails;
        }
        return $this;
    }
    /**
     * Get ContactDetails4Printing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail|null
     */
    public function getContactDetails4Printing()
    {
        return isset($this->ContactDetails4Printing) ? $this->ContactDetails4Printing : null;
    }
    /**
     * Set ContactDetails4Printing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setContactDetails4Printing(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails4Printing = null)
    {
        if (is_null($contactDetails4Printing) || (is_array($contactDetails4Printing) && empty($contactDetails4Printing))) {
            unset($this->ContactDetails4Printing);
        } else {
            $this->ContactDetails4Printing = $contactDetails4Printing;
        }
        return $this;
    }
    /**
     * Get ContactMeByServiceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ContactMeByServiceIds|null
     */
    public function getContactMeByServiceIds()
    {
        return isset($this->ContactMeByServiceIds) ? $this->ContactMeByServiceIds : null;
    }
    /**
     * Set ContactMeByServiceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ContactMeByServiceIds $contactMeByServiceIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setContactMeByServiceIds(\patest\StructType\ContactMeByServiceIds $contactMeByServiceIds = null)
    {
        if (is_null($contactMeByServiceIds) || (is_array($contactMeByServiceIds) && empty($contactMeByServiceIds))) {
            unset($this->ContactMeByServiceIds);
        } else {
            $this->ContactMeByServiceIds = $contactMeByServiceIds;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientContacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setContacts(\patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreatedUser value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_UserAudit|null
     */
    public function getCreatedUser()
    {
        return isset($this->CreatedUser) ? $this->CreatedUser : null;
    }
    /**
     * Set CreatedUser value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_UserAudit $createdUser
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCreatedUser(\patest\StructType\Crm_UserAudit $createdUser = null)
    {
        if (is_null($createdUser) || (is_array($createdUser) && empty($createdUser))) {
            unset($this->CreatedUser);
        } else {
            $this->CreatedUser = $createdUser;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CrmCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmCode()
    {
        return isset($this->CrmCode) ? $this->CrmCode : null;
    }
    /**
     * Set CrmCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmCode
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCrmCode($crmCode = null)
    {
        // validation for constraint: string
        if (!is_null($crmCode) && !is_string($crmCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmCode, true), gettype($crmCode)), __LINE__);
        }
        if (is_null($crmCode) || (is_array($crmCode) && empty($crmCode))) {
            unset($this->CrmCode);
        } else {
            $this->CrmCode = $crmCode;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get DataProtectionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_DataProtectionDetail|null
     */
    public function getDataProtectionDetails()
    {
        return isset($this->DataProtectionDetails) ? $this->DataProtectionDetails : null;
    }
    /**
     * Set DataProtectionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_DataProtectionDetail $dataProtectionDetails
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDataProtectionDetails(\patest\StructType\RecordSetOfCrm_DataProtectionDetail $dataProtectionDetails = null)
    {
        if (is_null($dataProtectionDetails) || (is_array($dataProtectionDetails) && empty($dataProtectionDetails))) {
            unset($this->DataProtectionDetails);
        } else {
            $this->DataProtectionDetails = $dataProtectionDetails;
        }
        return $this;
    }
    /**
     * Get DisplayAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayAddress()
    {
        return isset($this->DisplayAddress) ? $this->DisplayAddress : null;
    }
    /**
     * Set DisplayAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayAddress
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDisplayAddress($displayAddress = null)
    {
        // validation for constraint: string
        if (!is_null($displayAddress) && !is_string($displayAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayAddress, true), gettype($displayAddress)), __LINE__);
        }
        if (is_null($displayAddress) || (is_array($displayAddress) && empty($displayAddress))) {
            unset($this->DisplayAddress);
        } else {
            $this->DisplayAddress = $displayAddress;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get DisplayNoteInClientAlerts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayNoteInClientAlerts()
    {
        return isset($this->DisplayNoteInClientAlerts) ? $this->DisplayNoteInClientAlerts : null;
    }
    /**
     * Set DisplayNoteInClientAlerts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayNoteInClientAlerts
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDisplayNoteInClientAlerts($displayNoteInClientAlerts = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayNoteInClientAlerts) && !is_bool($displayNoteInClientAlerts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayNoteInClientAlerts, true), gettype($displayNoteInClientAlerts)), __LINE__);
        }
        if (is_null($displayNoteInClientAlerts) || (is_array($displayNoteInClientAlerts) && empty($displayNoteInClientAlerts))) {
            unset($this->DisplayNoteInClientAlerts);
        } else {
            $this->DisplayNoteInClientAlerts = $displayNoteInClientAlerts;
        }
        return $this;
    }
    /**
     * Get DisplayPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayPhone()
    {
        return isset($this->DisplayPhone) ? $this->DisplayPhone : null;
    }
    /**
     * Set DisplayPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayPhone
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDisplayPhone($displayPhone = null)
    {
        // validation for constraint: string
        if (!is_null($displayPhone) && !is_string($displayPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayPhone, true), gettype($displayPhone)), __LINE__);
        }
        if (is_null($displayPhone) || (is_array($displayPhone) && empty($displayPhone))) {
            unset($this->DisplayPhone);
        } else {
            $this->DisplayPhone = $displayPhone;
        }
        return $this;
    }
    /**
     * Get DoNotMerge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotMerge()
    {
        return isset($this->DoNotMerge) ? $this->DoNotMerge : null;
    }
    /**
     * Set DoNotMerge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotMerge
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setDoNotMerge($doNotMerge = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotMerge) && !is_bool($doNotMerge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotMerge, true), gettype($doNotMerge)), __LINE__);
        }
        if (is_null($doNotMerge) || (is_array($doNotMerge) && empty($doNotMerge))) {
            unset($this->DoNotMerge);
        } else {
            $this->DoNotMerge = $doNotMerge;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExemptValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExemptValidUntil()
    {
        return isset($this->ExemptValidUntil) ? $this->ExemptValidUntil : null;
    }
    /**
     * Set ExemptValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $exemptValidUntil
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setExemptValidUntil($exemptValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($exemptValidUntil) && !is_string($exemptValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exemptValidUntil, true), gettype($exemptValidUntil)), __LINE__);
        }
        if (is_null($exemptValidUntil) || (is_array($exemptValidUntil) && empty($exemptValidUntil))) {
            unset($this->ExemptValidUntil);
        } else {
            $this->ExemptValidUntil = $exemptValidUntil;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientExtraFields|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientExtraFields $extraFields
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setExtraFields(\patest\StructType\Crm_ClientExtraFields $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get ForceCreate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForceCreate()
    {
        return isset($this->ForceCreate) ? $this->ForceCreate : null;
    }
    /**
     * Set ForceCreate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forceCreate
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setForceCreate($forceCreate = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceCreate) && !is_bool($forceCreate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forceCreate, true), gettype($forceCreate)), __LINE__);
        }
        if (is_null($forceCreate) || (is_array($forceCreate) && empty($forceCreate))) {
            unset($this->ForceCreate);
        } else {
            $this->ForceCreate = $forceCreate;
        }
        return $this;
    }
    /**
     * Get GrantSoftCreditToRelatives value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGrantSoftCreditToRelatives()
    {
        return isset($this->GrantSoftCreditToRelatives) ? $this->GrantSoftCreditToRelatives : null;
    }
    /**
     * Set GrantSoftCreditToRelatives value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $grantSoftCreditToRelatives
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setGrantSoftCreditToRelatives($grantSoftCreditToRelatives = null)
    {
        // validation for constraint: boolean
        if (!is_null($grantSoftCreditToRelatives) && !is_bool($grantSoftCreditToRelatives)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($grantSoftCreditToRelatives, true), gettype($grantSoftCreditToRelatives)), __LINE__);
        }
        if (is_null($grantSoftCreditToRelatives) || (is_array($grantSoftCreditToRelatives) && empty($grantSoftCreditToRelatives))) {
            unset($this->GrantSoftCreditToRelatives);
        } else {
            $this->GrantSoftCreditToRelatives = $grantSoftCreditToRelatives;
        }
        return $this;
    }
    /**
     * Get HasMoreThanOneRelevantMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasMoreThanOneRelevantMembership()
    {
        return isset($this->HasMoreThanOneRelevantMembership) ? $this->HasMoreThanOneRelevantMembership : null;
    }
    /**
     * Set HasMoreThanOneRelevantMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasMoreThanOneRelevantMembership
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setHasMoreThanOneRelevantMembership($hasMoreThanOneRelevantMembership = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasMoreThanOneRelevantMembership) && !is_bool($hasMoreThanOneRelevantMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasMoreThanOneRelevantMembership, true), gettype($hasMoreThanOneRelevantMembership)), __LINE__);
        }
        if (is_null($hasMoreThanOneRelevantMembership) || (is_array($hasMoreThanOneRelevantMembership) && empty($hasMoreThanOneRelevantMembership))) {
            unset($this->HasMoreThanOneRelevantMembership);
        } else {
            $this->HasMoreThanOneRelevantMembership = $hasMoreThanOneRelevantMembership;
        }
        return $this;
    }
    /**
     * Get HomeAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PostalAddress|null
     */
    public function getHomeAddress()
    {
        return isset($this->HomeAddress) ? $this->HomeAddress : null;
    }
    /**
     * Set HomeAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PostalAddress $homeAddress
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setHomeAddress(\patest\StructType\Crm_PostalAddress $homeAddress = null)
    {
        if (is_null($homeAddress) || (is_array($homeAddress) && empty($homeAddress))) {
            unset($this->HomeAddress);
        } else {
            $this->HomeAddress = $homeAddress;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get ImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageId()
    {
        return isset($this->ImageId) ? $this->ImageId : null;
    }
    /**
     * Set ImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setImageId($imageId = null)
    {
        // validation for constraint: string
        if (!is_null($imageId) && !is_string($imageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageId, true), gettype($imageId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($imageId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $imageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($imageId, true)), __LINE__);
        }
        if (is_null($imageId) || (is_array($imageId) && empty($imageId))) {
            unset($this->ImageId);
        } else {
            $this->ImageId = $imageId;
        }
        return $this;
    }
    /**
     * Get IsCrmAccessAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCrmAccessAllowed()
    {
        return isset($this->IsCrmAccessAllowed) ? $this->IsCrmAccessAllowed : null;
    }
    /**
     * Set IsCrmAccessAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCrmAccessAllowed
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsCrmAccessAllowed($isCrmAccessAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCrmAccessAllowed) && !is_bool($isCrmAccessAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCrmAccessAllowed, true), gettype($isCrmAccessAllowed)), __LINE__);
        }
        if (is_null($isCrmAccessAllowed) || (is_array($isCrmAccessAllowed) && empty($isCrmAccessAllowed))) {
            unset($this->IsCrmAccessAllowed);
        } else {
            $this->IsCrmAccessAllowed = $isCrmAccessAllowed;
        }
        return $this;
    }
    /**
     * Get IsDataProtectionMissing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDataProtectionMissing()
    {
        return isset($this->IsDataProtectionMissing) ? $this->IsDataProtectionMissing : null;
    }
    /**
     * Set IsDataProtectionMissing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDataProtectionMissing
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsDataProtectionMissing($isDataProtectionMissing = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDataProtectionMissing) && !is_bool($isDataProtectionMissing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDataProtectionMissing, true), gettype($isDataProtectionMissing)), __LINE__);
        }
        if (is_null($isDataProtectionMissing) || (is_array($isDataProtectionMissing) && empty($isDataProtectionMissing))) {
            unset($this->IsDataProtectionMissing);
        } else {
            $this->IsDataProtectionMissing = $isDataProtectionMissing;
        }
        return $this;
    }
    /**
     * Get IsGroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupLeader()
    {
        return isset($this->IsGroupLeader) ? $this->IsGroupLeader : null;
    }
    /**
     * Set IsGroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupLeader
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsGroupLeader($isGroupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupLeader) && !is_bool($isGroupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupLeader, true), gettype($isGroupLeader)), __LINE__);
        }
        if (is_null($isGroupLeader) || (is_array($isGroupLeader) && empty($isGroupLeader))) {
            unset($this->IsGroupLeader);
        } else {
            $this->IsGroupLeader = $isGroupLeader;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get IsOrganizationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOrganizationData()
    {
        return isset($this->IsOrganizationData) ? $this->IsOrganizationData : null;
    }
    /**
     * Set IsOrganizationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOrganizationData
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsOrganizationData($isOrganizationData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrganizationData) && !is_bool($isOrganizationData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrganizationData, true), gettype($isOrganizationData)), __LINE__);
        }
        if (is_null($isOrganizationData) || (is_array($isOrganizationData) && empty($isOrganizationData))) {
            unset($this->IsOrganizationData);
        } else {
            $this->IsOrganizationData = $isOrganizationData;
        }
        return $this;
    }
    /**
     * Get IsTravelGroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTravelGroupLeader()
    {
        return isset($this->IsTravelGroupLeader) ? $this->IsTravelGroupLeader : null;
    }
    /**
     * Set IsTravelGroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTravelGroupLeader
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsTravelGroupLeader($isTravelGroupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTravelGroupLeader) && !is_bool($isTravelGroupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTravelGroupLeader, true), gettype($isTravelGroupLeader)), __LINE__);
        }
        if (is_null($isTravelGroupLeader) || (is_array($isTravelGroupLeader) && empty($isTravelGroupLeader))) {
            unset($this->IsTravelGroupLeader);
        } else {
            $this->IsTravelGroupLeader = $isTravelGroupLeader;
        }
        return $this;
    }
    /**
     * Get IsUnconfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUnconfirmed()
    {
        return isset($this->IsUnconfirmed) ? $this->IsUnconfirmed : null;
    }
    /**
     * Set IsUnconfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUnconfirmed
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setIsUnconfirmed($isUnconfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUnconfirmed) && !is_bool($isUnconfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUnconfirmed, true), gettype($isUnconfirmed)), __LINE__);
        }
        if (is_null($isUnconfirmed) || (is_array($isUnconfirmed) && empty($isUnconfirmed))) {
            unset($this->IsUnconfirmed);
        } else {
            $this->IsUnconfirmed = $isUnconfirmed;
        }
        return $this;
    }
    /**
     * Get LastUpdateAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastUpdateAuditId()
    {
        return isset($this->LastUpdateAuditId) ? $this->LastUpdateAuditId : null;
    }
    /**
     * Set LastUpdateAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastUpdateAuditId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setLastUpdateAuditId($lastUpdateAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdateAuditId) && !(is_int($lastUpdateAuditId) || ctype_digit($lastUpdateAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastUpdateAuditId, true), gettype($lastUpdateAuditId)), __LINE__);
        }
        if (is_null($lastUpdateAuditId) || (is_array($lastUpdateAuditId) && empty($lastUpdateAuditId))) {
            unset($this->LastUpdateAuditId);
        } else {
            $this->LastUpdateAuditId = $lastUpdateAuditId;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get Login value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_LoginDetail|null
     */
    public function getLogin()
    {
        return isset($this->Login) ? $this->Login : null;
    }
    /**
     * Set Login value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_LoginDetail $login
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setLogin(\patest\StructType\Crm_LoginDetail $login = null)
    {
        if (is_null($login) || (is_array($login) && empty($login))) {
            unset($this->Login);
        } else {
            $this->Login = $login;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLoyaltyPointsBalance()
    {
        return isset($this->LoyaltyPointsBalance) ? $this->LoyaltyPointsBalance : null;
    }
    /**
     * Set LoyaltyPointsBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $loyaltyPointsBalance
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setLoyaltyPointsBalance($loyaltyPointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPointsBalance) && !(is_float($loyaltyPointsBalance) || is_numeric($loyaltyPointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPointsBalance, true), gettype($loyaltyPointsBalance)), __LINE__);
        }
        if (is_null($loyaltyPointsBalance) || (is_array($loyaltyPointsBalance) && empty($loyaltyPointsBalance))) {
            unset($this->LoyaltyPointsBalance);
        } else {
            $this->LoyaltyPointsBalance = $loyaltyPointsBalance;
        }
        return $this;
    }
    /**
     * Get MapToCrmSyncEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMapToCrmSyncEntity()
    {
        return isset($this->MapToCrmSyncEntity) ? $this->MapToCrmSyncEntity : null;
    }
    /**
     * Set MapToCrmSyncEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mapToCrmSyncEntity
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMapToCrmSyncEntity($mapToCrmSyncEntity = null)
    {
        // validation for constraint: int
        if (!is_null($mapToCrmSyncEntity) && !(is_int($mapToCrmSyncEntity) || ctype_digit($mapToCrmSyncEntity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mapToCrmSyncEntity, true), gettype($mapToCrmSyncEntity)), __LINE__);
        }
        if (is_null($mapToCrmSyncEntity) || (is_array($mapToCrmSyncEntity) && empty($mapToCrmSyncEntity))) {
            unset($this->MapToCrmSyncEntity);
        } else {
            $this->MapToCrmSyncEntity = $mapToCrmSyncEntity;
        }
        return $this;
    }
    /**
     * Get MatchesGifts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMatchesGifts()
    {
        return isset($this->MatchesGifts) ? $this->MatchesGifts : null;
    }
    /**
     * Set MatchesGifts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $matchesGifts
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMatchesGifts($matchesGifts = null)
    {
        // validation for constraint: boolean
        if (!is_null($matchesGifts) && !is_bool($matchesGifts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($matchesGifts, true), gettype($matchesGifts)), __LINE__);
        }
        if (is_null($matchesGifts) || (is_array($matchesGifts) && empty($matchesGifts))) {
            unset($this->MatchesGifts);
        } else {
            $this->MatchesGifts = $matchesGifts;
        }
        return $this;
    }
    /**
     * Get MatchingGiftEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMatchingGiftEmail()
    {
        return isset($this->MatchingGiftEmail) ? $this->MatchingGiftEmail : null;
    }
    /**
     * Set MatchingGiftEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $matchingGiftEmail
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMatchingGiftEmail($matchingGiftEmail = null)
    {
        // validation for constraint: string
        if (!is_null($matchingGiftEmail) && !is_string($matchingGiftEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($matchingGiftEmail, true), gettype($matchingGiftEmail)), __LINE__);
        }
        if (is_null($matchingGiftEmail) || (is_array($matchingGiftEmail) && empty($matchingGiftEmail))) {
            unset($this->MatchingGiftEmail);
        } else {
            $this->MatchingGiftEmail = $matchingGiftEmail;
        }
        return $this;
    }
    /**
     * Get MatchingGiftMaximum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftMaximum()
    {
        return isset($this->MatchingGiftMaximum) ? $this->MatchingGiftMaximum : null;
    }
    /**
     * Set MatchingGiftMaximum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftMaximum
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMatchingGiftMaximum($matchingGiftMaximum = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftMaximum) && !(is_int($matchingGiftMaximum) || ctype_digit($matchingGiftMaximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftMaximum, true), gettype($matchingGiftMaximum)), __LINE__);
        }
        if (is_null($matchingGiftMaximum) || (is_array($matchingGiftMaximum) && empty($matchingGiftMaximum))) {
            unset($this->MatchingGiftMaximum);
        } else {
            $this->MatchingGiftMaximum = $matchingGiftMaximum;
        }
        return $this;
    }
    /**
     * Get MatchingGiftMinimum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftMinimum()
    {
        return isset($this->MatchingGiftMinimum) ? $this->MatchingGiftMinimum : null;
    }
    /**
     * Set MatchingGiftMinimum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftMinimum
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMatchingGiftMinimum($matchingGiftMinimum = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftMinimum) && !(is_int($matchingGiftMinimum) || ctype_digit($matchingGiftMinimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftMinimum, true), gettype($matchingGiftMinimum)), __LINE__);
        }
        if (is_null($matchingGiftMinimum) || (is_array($matchingGiftMinimum) && empty($matchingGiftMinimum))) {
            unset($this->MatchingGiftMinimum);
        } else {
            $this->MatchingGiftMinimum = $matchingGiftMinimum;
        }
        return $this;
    }
    /**
     * Get MatchingGiftPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMatchingGiftPercent()
    {
        return isset($this->MatchingGiftPercent) ? $this->MatchingGiftPercent : null;
    }
    /**
     * Set MatchingGiftPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $matchingGiftPercent
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMatchingGiftPercent($matchingGiftPercent = null)
    {
        // validation for constraint: int
        if (!is_null($matchingGiftPercent) && !(is_int($matchingGiftPercent) || ctype_digit($matchingGiftPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($matchingGiftPercent, true), gettype($matchingGiftPercent)), __LINE__);
        }
        if (is_null($matchingGiftPercent) || (is_array($matchingGiftPercent) && empty($matchingGiftPercent))) {
            unset($this->MatchingGiftPercent);
        } else {
            $this->MatchingGiftPercent = $matchingGiftPercent;
        }
        return $this;
    }
    /**
     * Get MergedWith value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMergedWith()
    {
        return isset($this->MergedWith) ? $this->MergedWith : null;
    }
    /**
     * Set MergedWith value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mergedWith
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMergedWith($mergedWith = null)
    {
        // validation for constraint: string
        if (!is_null($mergedWith) && !is_string($mergedWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mergedWith, true), gettype($mergedWith)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mergedWith) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mergedWith)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mergedWith, true)), __LINE__);
        }
        if (is_null($mergedWith) || (is_array($mergedWith) && empty($mergedWith))) {
            unset($this->MergedWith);
        } else {
            $this->MergedWith = $mergedWith;
        }
        return $this;
    }
    /**
     * Get MobileDeviceInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobileDeviceInfo()
    {
        return isset($this->MobileDeviceInfo) ? $this->MobileDeviceInfo : null;
    }
    /**
     * Set MobileDeviceInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobileDeviceInfo
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMobileDeviceInfo($mobileDeviceInfo = null)
    {
        // validation for constraint: string
        if (!is_null($mobileDeviceInfo) && !is_string($mobileDeviceInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobileDeviceInfo, true), gettype($mobileDeviceInfo)), __LINE__);
        }
        if (is_null($mobileDeviceInfo) || (is_array($mobileDeviceInfo) && empty($mobileDeviceInfo))) {
            unset($this->MobileDeviceInfo);
        } else {
            $this->MobileDeviceInfo = $mobileDeviceInfo;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\OrganizationUnitIds|null
     */
    public function getOrganizationUnitIds()
    {
        return isset($this->OrganizationUnitIds) ? $this->OrganizationUnitIds : null;
    }
    /**
     * Set OrganizationUnitIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\OrganizationUnitIds $organizationUnitIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setOrganizationUnitIds(\patest\StructType\OrganizationUnitIds $organizationUnitIds = null)
    {
        if (is_null($organizationUnitIds) || (is_array($organizationUnitIds) && empty($organizationUnitIds))) {
            unset($this->OrganizationUnitIds);
        } else {
            $this->OrganizationUnitIds = $organizationUnitIds;
        }
        return $this;
    }
    /**
     * Get PassPhrases value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassPhrases()
    {
        return isset($this->PassPhrases) ? $this->PassPhrases : null;
    }
    /**
     * Set PassPhrases value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passPhrases
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPassPhrases($passPhrases = null)
    {
        // validation for constraint: string
        if (!is_null($passPhrases) && !is_string($passPhrases)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passPhrases, true), gettype($passPhrases)), __LINE__);
        }
        if (is_null($passPhrases) || (is_array($passPhrases) && empty($passPhrases))) {
            unset($this->PassPhrases);
        } else {
            $this->PassPhrases = $passPhrases;
        }
        return $this;
    }
    /**
     * Get Picture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientImage4Printing|null
     */
    public function getPicture()
    {
        return isset($this->Picture) ? $this->Picture : null;
    }
    /**
     * Set Picture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientImage4Printing $picture
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPicture(\patest\StructType\Crm_ClientImage4Printing $picture = null)
    {
        if (is_null($picture) || (is_array($picture) && empty($picture))) {
            unset($this->Picture);
        } else {
            $this->Picture = $picture;
        }
        return $this;
    }
    /**
     * Get PointsSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointsSummary()
    {
        return isset($this->PointsSummary) ? $this->PointsSummary : null;
    }
    /**
     * Set PointsSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointsSummary
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPointsSummary($pointsSummary = null)
    {
        // validation for constraint: string
        if (!is_null($pointsSummary) && !is_string($pointsSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointsSummary, true), gettype($pointsSummary)), __LINE__);
        }
        if (is_null($pointsSummary) || (is_array($pointsSummary) && empty($pointsSummary))) {
            unset($this->PointsSummary);
        } else {
            $this->PointsSummary = $pointsSummary;
        }
        return $this;
    }
    /**
     * Get PreferenceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_Preference|null
     */
    public function getPreferenceDetails()
    {
        return isset($this->PreferenceDetails) ? $this->PreferenceDetails : null;
    }
    /**
     * Set PreferenceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_Preference $preferenceDetails
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPreferenceDetails(\patest\StructType\RecordSetOfCrm_Preference $preferenceDetails = null)
    {
        if (is_null($preferenceDetails) || (is_array($preferenceDetails) && empty($preferenceDetails))) {
            unset($this->PreferenceDetails);
        } else {
            $this->PreferenceDetails = $preferenceDetails;
        }
        return $this;
    }
    /**
     * Get PreferenceIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PreferenceIds|null
     */
    public function getPreferenceIds()
    {
        return isset($this->PreferenceIds) ? $this->PreferenceIds : null;
    }
    /**
     * Set PreferenceIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PreferenceIds $preferenceIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPreferenceIds(\patest\StructType\PreferenceIds $preferenceIds = null)
    {
        if (is_null($preferenceIds) || (is_array($preferenceIds) && empty($preferenceIds))) {
            unset($this->PreferenceIds);
        } else {
            $this->PreferenceIds = $preferenceIds;
        }
        return $this;
    }
    /**
     * Get PreferredCulture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ScreenParts_SupportedCulture|null
     */
    public function getPreferredCulture()
    {
        return isset($this->PreferredCulture) ? $this->PreferredCulture : null;
    }
    /**
     * Set PreferredCulture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ScreenParts_SupportedCulture $preferredCulture
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPreferredCulture(\patest\StructType\ScreenParts_SupportedCulture $preferredCulture = null)
    {
        if (is_null($preferredCulture) || (is_array($preferredCulture) && empty($preferredCulture))) {
            unset($this->PreferredCulture);
        } else {
            $this->PreferredCulture = $preferredCulture;
        }
        return $this;
    }
    /**
     * Get PreferredCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredCultureId()
    {
        return isset($this->PreferredCultureId) ? $this->PreferredCultureId : null;
    }
    /**
     * Set PreferredCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredCultureId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPreferredCultureId($preferredCultureId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCultureId) && !is_string($preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCultureId, true), gettype($preferredCultureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($preferredCultureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($preferredCultureId, true)), __LINE__);
        }
        if (is_null($preferredCultureId) || (is_array($preferredCultureId) && empty($preferredCultureId))) {
            unset($this->PreferredCultureId);
        } else {
            $this->PreferredCultureId = $preferredCultureId;
        }
        return $this;
    }
    /**
     * Get PrimaryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PostalAddress|null
     */
    public function getPrimaryAddress()
    {
        return isset($this->PrimaryAddress) ? $this->PrimaryAddress : null;
    }
    /**
     * Set PrimaryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PostalAddress $primaryAddress
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPrimaryAddress(\patest\StructType\Crm_PostalAddress $primaryAddress = null)
    {
        if (is_null($primaryAddress) || (is_array($primaryAddress) && empty($primaryAddress))) {
            unset($this->PrimaryAddress);
        } else {
            $this->PrimaryAddress = $primaryAddress;
        }
        return $this;
    }
    /**
     * Get PrimaryMembershipExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryMembershipExpiry()
    {
        return isset($this->PrimaryMembershipExpiry) ? $this->PrimaryMembershipExpiry : null;
    }
    /**
     * Set PrimaryMembershipExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryMembershipExpiry
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPrimaryMembershipExpiry($primaryMembershipExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($primaryMembershipExpiry) && !is_string($primaryMembershipExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryMembershipExpiry, true), gettype($primaryMembershipExpiry)), __LINE__);
        }
        if (is_null($primaryMembershipExpiry) || (is_array($primaryMembershipExpiry) && empty($primaryMembershipExpiry))) {
            unset($this->PrimaryMembershipExpiry);
        } else {
            $this->PrimaryMembershipExpiry = $primaryMembershipExpiry;
        }
        return $this;
    }
    /**
     * Get PrimaryMembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryMembershipId()
    {
        return isset($this->PrimaryMembershipId) ? $this->PrimaryMembershipId : null;
    }
    /**
     * Set PrimaryMembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryMembershipId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPrimaryMembershipId($primaryMembershipId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryMembershipId) && !is_string($primaryMembershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryMembershipId, true), gettype($primaryMembershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($primaryMembershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $primaryMembershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($primaryMembershipId, true)), __LINE__);
        }
        if (is_null($primaryMembershipId) || (is_array($primaryMembershipId) && empty($primaryMembershipId))) {
            unset($this->PrimaryMembershipId);
        } else {
            $this->PrimaryMembershipId = $primaryMembershipId;
        }
        return $this;
    }
    /**
     * Get PrimaryMembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPrimaryMembershipName()
    {
        return isset($this->PrimaryMembershipName) ? $this->PrimaryMembershipName : null;
    }
    /**
     * Set PrimaryMembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $primaryMembershipName
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setPrimaryMembershipName(\patest\StructType\GlobalString $primaryMembershipName = null)
    {
        if (is_null($primaryMembershipName) || (is_array($primaryMembershipName) && empty($primaryMembershipName))) {
            unset($this->PrimaryMembershipName);
        } else {
            $this->PrimaryMembershipName = $primaryMembershipName;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get QualityPointsBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQualityPointsBalance()
    {
        return isset($this->QualityPointsBalance) ? $this->QualityPointsBalance : null;
    }
    /**
     * Set QualityPointsBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qualityPointsBalance
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setQualityPointsBalance($qualityPointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($qualityPointsBalance) && !(is_float($qualityPointsBalance) || is_numeric($qualityPointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qualityPointsBalance, true), gettype($qualityPointsBalance)), __LINE__);
        }
        if (is_null($qualityPointsBalance) || (is_array($qualityPointsBalance) && empty($qualityPointsBalance))) {
            unset($this->QualityPointsBalance);
        } else {
            $this->QualityPointsBalance = $qualityPointsBalance;
        }
        return $this;
    }
    /**
     * Get RelatedClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_RelatedClient|null
     */
    public function getRelatedClients()
    {
        return isset($this->RelatedClients) ? $this->RelatedClients : null;
    }
    /**
     * Set RelatedClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_RelatedClient $relatedClients
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setRelatedClients(\patest\StructType\RecordSetOfCrm_RelatedClient $relatedClients = null)
    {
        if (is_null($relatedClients) || (is_array($relatedClients) && empty($relatedClients))) {
            unset($this->RelatedClients);
        } else {
            $this->RelatedClients = $relatedClients;
        }
        return $this;
    }
    /**
     * Get RelocationWaveIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelocationWaveIds|null
     */
    public function getRelocationWaveIds()
    {
        return isset($this->RelocationWaveIds) ? $this->RelocationWaveIds : null;
    }
    /**
     * Set RelocationWaveIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelocationWaveIds $relocationWaveIds
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setRelocationWaveIds(\patest\StructType\RelocationWaveIds $relocationWaveIds = null)
    {
        if (is_null($relocationWaveIds) || (is_array($relocationWaveIds) && empty($relocationWaveIds))) {
            unset($this->RelocationWaveIds);
        } else {
            $this->RelocationWaveIds = $relocationWaveIds;
        }
        return $this;
    }
    /**
     * Get Remarks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_Remark|null
     */
    public function getRemarks()
    {
        return isset($this->Remarks) ? $this->Remarks : null;
    }
    /**
     * Set Remarks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_Remark $remarks
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setRemarks(\patest\StructType\RecordSetOfCrm_Remark $remarks = null)
    {
        if (is_null($remarks) || (is_array($remarks) && empty($remarks))) {
            unset($this->Remarks);
        } else {
            $this->Remarks = $remarks;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_ClientStatusDetail|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_ClientStatusDetail $status
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setStatus(\patest\StructType\Crm_ClientStatusDetail $status = null)
    {
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get TravelGroupNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTravelGroupNumber()
    {
        return isset($this->TravelGroupNumber) ? $this->TravelGroupNumber : null;
    }
    /**
     * Set TravelGroupNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $travelGroupNumber
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setTravelGroupNumber($travelGroupNumber = null)
    {
        // validation for constraint: int
        if (!is_null($travelGroupNumber) && !(is_int($travelGroupNumber) || ctype_digit($travelGroupNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelGroupNumber, true), gettype($travelGroupNumber)), __LINE__);
        }
        if (is_null($travelGroupNumber) || (is_array($travelGroupNumber) && empty($travelGroupNumber))) {
            unset($this->TravelGroupNumber);
        } else {
            $this->TravelGroupNumber = $travelGroupNumber;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crm_Client4PrintingTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crm_Client4PrintingTypeItem)) {
                $invalidValues[] = is_object($crm_Client4PrintingTypeItem) ? get_class($crm_Client4PrintingTypeItem) : sprintf('%s(%s)', gettype($crm_Client4PrintingTypeItem), var_export($crm_Client4PrintingTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get TypeString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeString()
    {
        return isset($this->TypeString) ? $this->TypeString : null;
    }
    /**
     * Set TypeString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeString
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setTypeString($typeString = null)
    {
        // validation for constraint: string
        if (!is_null($typeString) && !is_string($typeString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeString, true), gettype($typeString)), __LINE__);
        }
        if (is_null($typeString) || (is_array($typeString) && empty($typeString))) {
            unset($this->TypeString);
        } else {
            $this->TypeString = $typeString;
        }
        return $this;
    }
    /**
     * Get WebSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite()
    {
        return isset($this->WebSite) ? $this->WebSite : null;
    }
    /**
     * Set WebSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite
     * @return \patest\StructType\Crm_Client4Printing
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        if (is_null($webSite) || (is_array($webSite) && empty($webSite))) {
            unset($this->WebSite);
        } else {
            $this->WebSite = $webSite;
        }
        return $this;
    }
}
