<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm-ChangePassword-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Crm-ChangePassword-Request
 * @subpackage Structs
 */
class Crm_ChangePassword_Request extends AbstractStructBase
{
    /**
     * The CustomerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerId;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * The NewPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewPassword;
    /**
     * The OldPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldPassword;
    /**
     * Constructor method for Crm-ChangePassword-Request
     * @uses Crm_ChangePassword_Request::setCustomerId()
     * @uses Crm_ChangePassword_Request::setLoginName()
     * @uses Crm_ChangePassword_Request::setNewPassword()
     * @uses Crm_ChangePassword_Request::setOldPassword()
     * @param string $customerId
     * @param string $loginName
     * @param string $newPassword
     * @param string $oldPassword
     */
    public function __construct($customerId = null, $loginName = null, $newPassword = null, $oldPassword = null)
    {
        $this
            ->setCustomerId($customerId)
            ->setLoginName($loginName)
            ->setNewPassword($newPassword)
            ->setOldPassword($oldPassword);
    }
    /**
     * Get CustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerId()
    {
        return isset($this->CustomerId) ? $this->CustomerId : null;
    }
    /**
     * Set CustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerId
     * @return \patest\StructType\Crm_ChangePassword_Request
     */
    public function setCustomerId($customerId = null)
    {
        // validation for constraint: string
        if (!is_null($customerId) && !is_string($customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerId, true), gettype($customerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerId, true)), __LINE__);
        }
        if (is_null($customerId) || (is_array($customerId) && empty($customerId))) {
            unset($this->CustomerId);
        } else {
            $this->CustomerId = $customerId;
        }
        return $this;
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\Crm_ChangePassword_Request
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
    /**
     * Get NewPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewPassword()
    {
        return isset($this->NewPassword) ? $this->NewPassword : null;
    }
    /**
     * Set NewPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newPassword
     * @return \patest\StructType\Crm_ChangePassword_Request
     */
    public function setNewPassword($newPassword = null)
    {
        // validation for constraint: string
        if (!is_null($newPassword) && !is_string($newPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPassword, true), gettype($newPassword)), __LINE__);
        }
        if (is_null($newPassword) || (is_array($newPassword) && empty($newPassword))) {
            unset($this->NewPassword);
        } else {
            $this->NewPassword = $newPassword;
        }
        return $this;
    }
    /**
     * Get OldPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldPassword()
    {
        return isset($this->OldPassword) ? $this->OldPassword : null;
    }
    /**
     * Set OldPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldPassword
     * @return \patest\StructType\Crm_ChangePassword_Request
     */
    public function setOldPassword($oldPassword = null)
    {
        // validation for constraint: string
        if (!is_null($oldPassword) && !is_string($oldPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldPassword, true), gettype($oldPassword)), __LINE__);
        }
        if (is_null($oldPassword) || (is_array($oldPassword) && empty($oldPassword))) {
            unset($this->OldPassword);
        } else {
            $this->OldPassword = $oldPassword;
        }
        return $this;
    }
}
