<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Crm.BatchMembershipClientEnrollment StructType
 * @subpackage Structs
 */
class Crm_BatchMembershipClientEnrollment extends Crm_ClientEnrollment
{
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The MembershipExpiry
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipExpiry;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentToken
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentToken;
    /**
     * The PaymentTokenExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokenExpiryDate;
    /**
     * Constructor method for Crm.BatchMembershipClientEnrollment
     * @uses Crm_BatchMembershipClientEnrollment::setClientName()
     * @uses Crm_BatchMembershipClientEnrollment::setCrmId()
     * @uses Crm_BatchMembershipClientEnrollment::setMembershipExpiry()
     * @uses Crm_BatchMembershipClientEnrollment::setMembershipNumber()
     * @uses Crm_BatchMembershipClientEnrollment::setPaymentMethodName()
     * @uses Crm_BatchMembershipClientEnrollment::setPaymentToken()
     * @uses Crm_BatchMembershipClientEnrollment::setPaymentTokenExpiryDate()
     * @param string $clientName
     * @param string $crmId
     * @param string $membershipExpiry
     * @param string $membershipNumber
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentToken
     * @param string $paymentTokenExpiryDate
     */
    public function __construct($clientName = null, $crmId = null, $membershipExpiry = null, $membershipNumber = null, \patest\StructType\GlobalString $paymentMethodName = null, $paymentToken = null, $paymentTokenExpiryDate = null)
    {
        $this
            ->setClientName($clientName)
            ->setCrmId($crmId)
            ->setMembershipExpiry($membershipExpiry)
            ->setMembershipNumber($membershipNumber)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentToken($paymentToken)
            ->setPaymentTokenExpiryDate($paymentTokenExpiryDate);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get MembershipExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipExpiry()
    {
        return isset($this->MembershipExpiry) ? $this->MembershipExpiry : null;
    }
    /**
     * Set MembershipExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipExpiry
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setMembershipExpiry($membershipExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($membershipExpiry) && !is_string($membershipExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipExpiry, true), gettype($membershipExpiry)), __LINE__);
        }
        if (is_null($membershipExpiry) || (is_array($membershipExpiry) && empty($membershipExpiry))) {
            unset($this->MembershipExpiry);
        } else {
            $this->MembershipExpiry = $membershipExpiry;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentToken()
    {
        return isset($this->PaymentToken) ? $this->PaymentToken : null;
    }
    /**
     * Set PaymentToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentToken
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentToken, true), gettype($paymentToken)), __LINE__);
        }
        if (is_null($paymentToken) || (is_array($paymentToken) && empty($paymentToken))) {
            unset($this->PaymentToken);
        } else {
            $this->PaymentToken = $paymentToken;
        }
        return $this;
    }
    /**
     * Get PaymentTokenExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenExpiryDate()
    {
        return isset($this->PaymentTokenExpiryDate) ? $this->PaymentTokenExpiryDate : null;
    }
    /**
     * Set PaymentTokenExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenExpiryDate
     * @return \patest\StructType\Crm_BatchMembershipClientEnrollment
     */
    public function setPaymentTokenExpiryDate($paymentTokenExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenExpiryDate) && !is_string($paymentTokenExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenExpiryDate, true), gettype($paymentTokenExpiryDate)), __LINE__);
        }
        if (is_null($paymentTokenExpiryDate) || (is_array($paymentTokenExpiryDate) && empty($paymentTokenExpiryDate))) {
            unset($this->PaymentTokenExpiryDate);
        } else {
            $this->PaymentTokenExpiryDate = $paymentTokenExpiryDate;
        }
        return $this;
    }
}
