<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmSyncEntitySync.Remark StructType
 * @subpackage Structs
 */
class CrmSyncEntitySync_Remark extends CrmSyncEntitySubObject
{
    /**
     * The Attachement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Attachement;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsAlert
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAlert;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsHidden;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LastUpdateUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LastUpdateUserId;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TypeName;
    /**
     * Constructor method for CrmSyncEntitySync.Remark
     * @uses CrmSyncEntitySync_Remark::setAttachement()
     * @uses CrmSyncEntitySync_Remark::setFromDate()
     * @uses CrmSyncEntitySync_Remark::setIsAlert()
     * @uses CrmSyncEntitySync_Remark::setIsHidden()
     * @uses CrmSyncEntitySync_Remark::setLastUpdateDateTime()
     * @uses CrmSyncEntitySync_Remark::setLastUpdateUserId()
     * @uses CrmSyncEntitySync_Remark::setNote()
     * @uses CrmSyncEntitySync_Remark::setPriority()
     * @uses CrmSyncEntitySync_Remark::setToDate()
     * @uses CrmSyncEntitySync_Remark::setTypeName()
     * @param string $attachement
     * @param string $fromDate
     * @param bool $isAlert
     * @param bool $isHidden
     * @param string $lastUpdateDateTime
     * @param string $lastUpdateUserId
     * @param \patest\StructType\GlobalString $note
     * @param int $priority
     * @param string $toDate
     * @param \patest\StructType\GlobalString $typeName
     */
    public function __construct($attachement = null, $fromDate = null, $isAlert = null, $isHidden = null, $lastUpdateDateTime = null, $lastUpdateUserId = null, \patest\StructType\GlobalString $note = null, $priority = null, $toDate = null, \patest\StructType\GlobalString $typeName = null)
    {
        $this
            ->setAttachement($attachement)
            ->setFromDate($fromDate)
            ->setIsAlert($isAlert)
            ->setIsHidden($isHidden)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLastUpdateUserId($lastUpdateUserId)
            ->setNote($note)
            ->setPriority($priority)
            ->setToDate($toDate)
            ->setTypeName($typeName);
    }
    /**
     * Get Attachement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachement()
    {
        return isset($this->Attachement) ? $this->Attachement : null;
    }
    /**
     * Set Attachement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attachement
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setAttachement($attachement = null)
    {
        // validation for constraint: string
        if (!is_null($attachement) && !is_string($attachement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attachement, true), gettype($attachement)), __LINE__);
        }
        if (is_null($attachement) || (is_array($attachement) && empty($attachement))) {
            unset($this->Attachement);
        } else {
            $this->Attachement = $attachement;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsAlert value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAlert()
    {
        return isset($this->IsAlert) ? $this->IsAlert : null;
    }
    /**
     * Set IsAlert value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAlert
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setIsAlert($isAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAlert) && !is_bool($isAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAlert, true), gettype($isAlert)), __LINE__);
        }
        if (is_null($isAlert) || (is_array($isAlert) && empty($isAlert))) {
            unset($this->IsAlert);
        } else {
            $this->IsAlert = $isAlert;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsHidden()
    {
        return isset($this->IsHidden) ? $this->IsHidden : null;
    }
    /**
     * Set IsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isHidden
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        if (is_null($isHidden) || (is_array($isHidden) && empty($isHidden))) {
            unset($this->IsHidden);
        } else {
            $this->IsHidden = $isHidden;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LastUpdateUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateUserId()
    {
        return isset($this->LastUpdateUserId) ? $this->LastUpdateUserId : null;
    }
    /**
     * Set LastUpdateUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateUserId
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setLastUpdateUserId($lastUpdateUserId = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserId) && !is_string($lastUpdateUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateUserId, true), gettype($lastUpdateUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lastUpdateUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lastUpdateUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lastUpdateUserId, true)), __LINE__);
        }
        if (is_null($lastUpdateUserId) || (is_array($lastUpdateUserId) && empty($lastUpdateUserId))) {
            unset($this->LastUpdateUserId);
        } else {
            $this->LastUpdateUserId = $lastUpdateUserId;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get TypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTypeName()
    {
        return isset($this->TypeName) ? $this->TypeName : null;
    }
    /**
     * Set TypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $typeName
     * @return \patest\StructType\CrmSyncEntitySync_Remark
     */
    public function setTypeName(\patest\StructType\GlobalString $typeName = null)
    {
        if (is_null($typeName) || (is_array($typeName) && empty($typeName))) {
            unset($this->TypeName);
        } else {
            $this->TypeName = $typeName;
        }
        return $this;
    }
}
