<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmSyncEntitySync.DataProtectionDetail StructType
 * @subpackage Structs
 */
class CrmSyncEntitySync_DataProtectionDetail extends CrmSyncEntitySync_IntegrationBase
{
    /**
     * The Answer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Answer;
    /**
     * The AnsweredDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnsweredDate;
    /**
     * The Question
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Question;
    /**
     * The QuestionShortName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $QuestionShortName;
    /**
     * Constructor method for CrmSyncEntitySync.DataProtectionDetail
     * @uses CrmSyncEntitySync_DataProtectionDetail::setAnswer()
     * @uses CrmSyncEntitySync_DataProtectionDetail::setAnsweredDate()
     * @uses CrmSyncEntitySync_DataProtectionDetail::setQuestion()
     * @uses CrmSyncEntitySync_DataProtectionDetail::setQuestionShortName()
     * @param string $answer
     * @param string $answeredDate
     * @param \patest\StructType\GlobalString $question
     * @param \patest\StructType\GlobalString $questionShortName
     */
    public function __construct($answer = null, $answeredDate = null, \patest\StructType\GlobalString $question = null, \patest\StructType\GlobalString $questionShortName = null)
    {
        $this
            ->setAnswer($answer)
            ->setAnsweredDate($answeredDate)
            ->setQuestion($question)
            ->setQuestionShortName($questionShortName);
    }
    /**
     * Get Answer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnswer()
    {
        return isset($this->Answer) ? $this->Answer : null;
    }
    /**
     * Set Answer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DataProtectionAnswerKind::valueIsValid()
     * @uses \patest\EnumType\DataProtectionAnswerKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $answer
     * @return \patest\StructType\CrmSyncEntitySync_DataProtectionDetail
     */
    public function setAnswer($answer = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DataProtectionAnswerKind::valueIsValid($answer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DataProtectionAnswerKind', is_array($answer) ? implode(', ', $answer) : var_export($answer, true), implode(', ', \patest\EnumType\DataProtectionAnswerKind::getValidValues())), __LINE__);
        }
        if (is_null($answer) || (is_array($answer) && empty($answer))) {
            unset($this->Answer);
        } else {
            $this->Answer = $answer;
        }
        return $this;
    }
    /**
     * Get AnsweredDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnsweredDate()
    {
        return isset($this->AnsweredDate) ? $this->AnsweredDate : null;
    }
    /**
     * Set AnsweredDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $answeredDate
     * @return \patest\StructType\CrmSyncEntitySync_DataProtectionDetail
     */
    public function setAnsweredDate($answeredDate = null)
    {
        // validation for constraint: string
        if (!is_null($answeredDate) && !is_string($answeredDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($answeredDate, true), gettype($answeredDate)), __LINE__);
        }
        if (is_null($answeredDate) || (is_array($answeredDate) && empty($answeredDate))) {
            unset($this->AnsweredDate);
        } else {
            $this->AnsweredDate = $answeredDate;
        }
        return $this;
    }
    /**
     * Get Question value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getQuestion()
    {
        return isset($this->Question) ? $this->Question : null;
    }
    /**
     * Set Question value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $question
     * @return \patest\StructType\CrmSyncEntitySync_DataProtectionDetail
     */
    public function setQuestion(\patest\StructType\GlobalString $question = null)
    {
        if (is_null($question) || (is_array($question) && empty($question))) {
            unset($this->Question);
        } else {
            $this->Question = $question;
        }
        return $this;
    }
    /**
     * Get QuestionShortName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getQuestionShortName()
    {
        return isset($this->QuestionShortName) ? $this->QuestionShortName : null;
    }
    /**
     * Set QuestionShortName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $questionShortName
     * @return \patest\StructType\CrmSyncEntitySync_DataProtectionDetail
     */
    public function setQuestionShortName(\patest\StructType\GlobalString $questionShortName = null)
    {
        if (is_null($questionShortName) || (is_array($questionShortName) && empty($questionShortName))) {
            unset($this->QuestionShortName);
        } else {
            $this->QuestionShortName = $questionShortName;
        }
        return $this;
    }
}
