<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CrmSyncEntitySync.Client StructType
 * @subpackage Structs
 */
class CrmSyncEntitySync_Client extends CrmSyncEntitySync_IntegrationBase
{
    /**
     * The AddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrmSyncEntitySync_Address
     */
    public $AddressDetails;
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail
     */
    public $ClientTypes;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail
     */
    public $ContactDetails;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The DataProtectionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail
     */
    public $DataProtectionDetails;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LastUpdateDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdateDateTime;
    /**
     * The LoyaltyPointsBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $LoyaltyPointsBalance;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The PointsSummary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointsSummary;
    /**
     * The PreferredCultureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredCultureId;
    /**
     * The QualityPointsBalance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QualityPointsBalance;
    /**
     * The Remarks
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrmSyncEntitySync_Remark
     */
    public $Remarks;
    /**
     * The StringField1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField1;
    /**
     * The StringField2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField2;
    /**
     * The StringField3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField3;
    /**
     * The StringField4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField4;
    /**
     * The StringField5
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField5;
    /**
     * The StringField6
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField6;
    /**
     * The StringField7
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField7;
    /**
     * The StringField8
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField8;
    /**
     * The StringField9
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringField9;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite;
    /**
     * Constructor method for CrmSyncEntitySync.Client
     * @uses CrmSyncEntitySync_Client::setAddressDetails()
     * @uses CrmSyncEntitySync_Client::setBusinessPhone()
     * @uses CrmSyncEntitySync_Client::setClientTypes()
     * @uses CrmSyncEntitySync_Client::setContactDetails()
     * @uses CrmSyncEntitySync_Client::setCreationDateTime()
     * @uses CrmSyncEntitySync_Client::setCrmId()
     * @uses CrmSyncEntitySync_Client::setDataProtectionDetails()
     * @uses CrmSyncEntitySync_Client::setEmail()
     * @uses CrmSyncEntitySync_Client::setFax()
     * @uses CrmSyncEntitySync_Client::setHomePhone()
     * @uses CrmSyncEntitySync_Client::setIsActive()
     * @uses CrmSyncEntitySync_Client::setLastUpdateDateTime()
     * @uses CrmSyncEntitySync_Client::setLoyaltyPointsBalance()
     * @uses CrmSyncEntitySync_Client::setMobilePhone()
     * @uses CrmSyncEntitySync_Client::setNote()
     * @uses CrmSyncEntitySync_Client::setPointsSummary()
     * @uses CrmSyncEntitySync_Client::setPreferredCultureId()
     * @uses CrmSyncEntitySync_Client::setQualityPointsBalance()
     * @uses CrmSyncEntitySync_Client::setRemarks()
     * @uses CrmSyncEntitySync_Client::setStringField1()
     * @uses CrmSyncEntitySync_Client::setStringField2()
     * @uses CrmSyncEntitySync_Client::setStringField3()
     * @uses CrmSyncEntitySync_Client::setStringField4()
     * @uses CrmSyncEntitySync_Client::setStringField5()
     * @uses CrmSyncEntitySync_Client::setStringField6()
     * @uses CrmSyncEntitySync_Client::setStringField7()
     * @uses CrmSyncEntitySync_Client::setStringField8()
     * @uses CrmSyncEntitySync_Client::setStringField9()
     * @uses CrmSyncEntitySync_Client::setTaxExemptNumber()
     * @uses CrmSyncEntitySync_Client::setType()
     * @uses CrmSyncEntitySync_Client::setWebSite()
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_Address $addressDetails
     * @param string $businessPhone
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail $clientTypes
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail $contactDetails
     * @param string $creationDateTime
     * @param string $crmId
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail $dataProtectionDetails
     * @param string $email
     * @param string $fax
     * @param string $homePhone
     * @param bool $isActive
     * @param string $lastUpdateDateTime
     * @param float $loyaltyPointsBalance
     * @param string $mobilePhone
     * @param string $note
     * @param string $pointsSummary
     * @param string $preferredCultureId
     * @param float $qualityPointsBalance
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_Remark $remarks
     * @param string $stringField1
     * @param string $stringField2
     * @param string $stringField3
     * @param string $stringField4
     * @param string $stringField5
     * @param string $stringField6
     * @param string $stringField7
     * @param string $stringField8
     * @param string $stringField9
     * @param string $taxExemptNumber
     * @param string[] $type
     * @param string $webSite
     */
    public function __construct(\patest\StructType\RecordSetOfCrmSyncEntitySync_Address $addressDetails = null, $businessPhone = null, \patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail $clientTypes = null, \patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail $contactDetails = null, $creationDateTime = null, $crmId = null, \patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail $dataProtectionDetails = null, $email = null, $fax = null, $homePhone = null, $isActive = null, $lastUpdateDateTime = null, $loyaltyPointsBalance = null, $mobilePhone = null, $note = null, $pointsSummary = null, $preferredCultureId = null, $qualityPointsBalance = null, \patest\StructType\RecordSetOfCrmSyncEntitySync_Remark $remarks = null, $stringField1 = null, $stringField2 = null, $stringField3 = null, $stringField4 = null, $stringField5 = null, $stringField6 = null, $stringField7 = null, $stringField8 = null, $stringField9 = null, $taxExemptNumber = null, array $type = array(), $webSite = null)
    {
        $this
            ->setAddressDetails($addressDetails)
            ->setBusinessPhone($businessPhone)
            ->setClientTypes($clientTypes)
            ->setContactDetails($contactDetails)
            ->setCreationDateTime($creationDateTime)
            ->setCrmId($crmId)
            ->setDataProtectionDetails($dataProtectionDetails)
            ->setEmail($email)
            ->setFax($fax)
            ->setHomePhone($homePhone)
            ->setIsActive($isActive)
            ->setLastUpdateDateTime($lastUpdateDateTime)
            ->setLoyaltyPointsBalance($loyaltyPointsBalance)
            ->setMobilePhone($mobilePhone)
            ->setNote($note)
            ->setPointsSummary($pointsSummary)
            ->setPreferredCultureId($preferredCultureId)
            ->setQualityPointsBalance($qualityPointsBalance)
            ->setRemarks($remarks)
            ->setStringField1($stringField1)
            ->setStringField2($stringField2)
            ->setStringField3($stringField3)
            ->setStringField4($stringField4)
            ->setStringField5($stringField5)
            ->setStringField6($stringField6)
            ->setStringField7($stringField7)
            ->setStringField8($stringField8)
            ->setStringField9($stringField9)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setType($type)
            ->setWebSite($webSite);
    }
    /**
     * Get AddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrmSyncEntitySync_Address|null
     */
    public function getAddressDetails()
    {
        return isset($this->AddressDetails) ? $this->AddressDetails : null;
    }
    /**
     * Set AddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_Address $addressDetails
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setAddressDetails(\patest\StructType\RecordSetOfCrmSyncEntitySync_Address $addressDetails = null)
    {
        if (is_null($addressDetails) || (is_array($addressDetails) && empty($addressDetails))) {
            unset($this->AddressDetails);
        } else {
            $this->AddressDetails = $addressDetails;
        }
        return $this;
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail $clientTypes
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setClientTypes(\patest\StructType\RecordSetOfCrmSyncEntitySync_ClientTypeDetail $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get ContactDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail|null
     */
    public function getContactDetails()
    {
        return isset($this->ContactDetails) ? $this->ContactDetails : null;
    }
    /**
     * Set ContactDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail $contactDetails
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setContactDetails(\patest\StructType\RecordSetOfCrmSyncEntitySync_ContactDetail $contactDetails = null)
    {
        if (is_null($contactDetails) || (is_array($contactDetails) && empty($contactDetails))) {
            unset($this->ContactDetails);
        } else {
            $this->ContactDetails = $contactDetails;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get DataProtectionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail|null
     */
    public function getDataProtectionDetails()
    {
        return isset($this->DataProtectionDetails) ? $this->DataProtectionDetails : null;
    }
    /**
     * Set DataProtectionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail $dataProtectionDetails
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setDataProtectionDetails(\patest\StructType\RecordSetOfCrmSyncEntitySync_DataProtectionDetail $dataProtectionDetails = null)
    {
        if (is_null($dataProtectionDetails) || (is_array($dataProtectionDetails) && empty($dataProtectionDetails))) {
            unset($this->DataProtectionDetails);
        } else {
            $this->DataProtectionDetails = $dataProtectionDetails;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LastUpdateDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdateDateTime()
    {
        return isset($this->LastUpdateDateTime) ? $this->LastUpdateDateTime : null;
    }
    /**
     * Set LastUpdateDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdateDateTime
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setLastUpdateDateTime($lastUpdateDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDateTime) && !is_string($lastUpdateDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdateDateTime, true), gettype($lastUpdateDateTime)), __LINE__);
        }
        if (is_null($lastUpdateDateTime) || (is_array($lastUpdateDateTime) && empty($lastUpdateDateTime))) {
            unset($this->LastUpdateDateTime);
        } else {
            $this->LastUpdateDateTime = $lastUpdateDateTime;
        }
        return $this;
    }
    /**
     * Get LoyaltyPointsBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLoyaltyPointsBalance()
    {
        return isset($this->LoyaltyPointsBalance) ? $this->LoyaltyPointsBalance : null;
    }
    /**
     * Set LoyaltyPointsBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $loyaltyPointsBalance
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setLoyaltyPointsBalance($loyaltyPointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($loyaltyPointsBalance) && !(is_float($loyaltyPointsBalance) || is_numeric($loyaltyPointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($loyaltyPointsBalance, true), gettype($loyaltyPointsBalance)), __LINE__);
        }
        if (is_null($loyaltyPointsBalance) || (is_array($loyaltyPointsBalance) && empty($loyaltyPointsBalance))) {
            unset($this->LoyaltyPointsBalance);
        } else {
            $this->LoyaltyPointsBalance = $loyaltyPointsBalance;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PointsSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointsSummary()
    {
        return isset($this->PointsSummary) ? $this->PointsSummary : null;
    }
    /**
     * Set PointsSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pointsSummary
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setPointsSummary($pointsSummary = null)
    {
        // validation for constraint: string
        if (!is_null($pointsSummary) && !is_string($pointsSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pointsSummary, true), gettype($pointsSummary)), __LINE__);
        }
        if (is_null($pointsSummary) || (is_array($pointsSummary) && empty($pointsSummary))) {
            unset($this->PointsSummary);
        } else {
            $this->PointsSummary = $pointsSummary;
        }
        return $this;
    }
    /**
     * Get PreferredCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredCultureId()
    {
        return isset($this->PreferredCultureId) ? $this->PreferredCultureId : null;
    }
    /**
     * Set PreferredCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredCultureId
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setPreferredCultureId($preferredCultureId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCultureId) && !is_string($preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCultureId, true), gettype($preferredCultureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($preferredCultureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($preferredCultureId, true)), __LINE__);
        }
        if (is_null($preferredCultureId) || (is_array($preferredCultureId) && empty($preferredCultureId))) {
            unset($this->PreferredCultureId);
        } else {
            $this->PreferredCultureId = $preferredCultureId;
        }
        return $this;
    }
    /**
     * Get QualityPointsBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQualityPointsBalance()
    {
        return isset($this->QualityPointsBalance) ? $this->QualityPointsBalance : null;
    }
    /**
     * Set QualityPointsBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qualityPointsBalance
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setQualityPointsBalance($qualityPointsBalance = null)
    {
        // validation for constraint: float
        if (!is_null($qualityPointsBalance) && !(is_float($qualityPointsBalance) || is_numeric($qualityPointsBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($qualityPointsBalance, true), gettype($qualityPointsBalance)), __LINE__);
        }
        if (is_null($qualityPointsBalance) || (is_array($qualityPointsBalance) && empty($qualityPointsBalance))) {
            unset($this->QualityPointsBalance);
        } else {
            $this->QualityPointsBalance = $qualityPointsBalance;
        }
        return $this;
    }
    /**
     * Get Remarks value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrmSyncEntitySync_Remark|null
     */
    public function getRemarks()
    {
        return isset($this->Remarks) ? $this->Remarks : null;
    }
    /**
     * Set Remarks value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrmSyncEntitySync_Remark $remarks
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setRemarks(\patest\StructType\RecordSetOfCrmSyncEntitySync_Remark $remarks = null)
    {
        if (is_null($remarks) || (is_array($remarks) && empty($remarks))) {
            unset($this->Remarks);
        } else {
            $this->Remarks = $remarks;
        }
        return $this;
    }
    /**
     * Get StringField1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField1()
    {
        return isset($this->StringField1) ? $this->StringField1 : null;
    }
    /**
     * Set StringField1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField1
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField1($stringField1 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField1) && !is_string($stringField1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField1, true), gettype($stringField1)), __LINE__);
        }
        if (is_null($stringField1) || (is_array($stringField1) && empty($stringField1))) {
            unset($this->StringField1);
        } else {
            $this->StringField1 = $stringField1;
        }
        return $this;
    }
    /**
     * Get StringField2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField2()
    {
        return isset($this->StringField2) ? $this->StringField2 : null;
    }
    /**
     * Set StringField2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField2
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField2($stringField2 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField2) && !is_string($stringField2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField2, true), gettype($stringField2)), __LINE__);
        }
        if (is_null($stringField2) || (is_array($stringField2) && empty($stringField2))) {
            unset($this->StringField2);
        } else {
            $this->StringField2 = $stringField2;
        }
        return $this;
    }
    /**
     * Get StringField3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField3()
    {
        return isset($this->StringField3) ? $this->StringField3 : null;
    }
    /**
     * Set StringField3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField3
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField3($stringField3 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField3) && !is_string($stringField3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField3, true), gettype($stringField3)), __LINE__);
        }
        if (is_null($stringField3) || (is_array($stringField3) && empty($stringField3))) {
            unset($this->StringField3);
        } else {
            $this->StringField3 = $stringField3;
        }
        return $this;
    }
    /**
     * Get StringField4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField4()
    {
        return isset($this->StringField4) ? $this->StringField4 : null;
    }
    /**
     * Set StringField4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField4
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField4($stringField4 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField4) && !is_string($stringField4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField4, true), gettype($stringField4)), __LINE__);
        }
        if (is_null($stringField4) || (is_array($stringField4) && empty($stringField4))) {
            unset($this->StringField4);
        } else {
            $this->StringField4 = $stringField4;
        }
        return $this;
    }
    /**
     * Get StringField5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField5()
    {
        return isset($this->StringField5) ? $this->StringField5 : null;
    }
    /**
     * Set StringField5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField5
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField5($stringField5 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField5) && !is_string($stringField5)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField5, true), gettype($stringField5)), __LINE__);
        }
        if (is_null($stringField5) || (is_array($stringField5) && empty($stringField5))) {
            unset($this->StringField5);
        } else {
            $this->StringField5 = $stringField5;
        }
        return $this;
    }
    /**
     * Get StringField6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField6()
    {
        return isset($this->StringField6) ? $this->StringField6 : null;
    }
    /**
     * Set StringField6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField6
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField6($stringField6 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField6) && !is_string($stringField6)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField6, true), gettype($stringField6)), __LINE__);
        }
        if (is_null($stringField6) || (is_array($stringField6) && empty($stringField6))) {
            unset($this->StringField6);
        } else {
            $this->StringField6 = $stringField6;
        }
        return $this;
    }
    /**
     * Get StringField7 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField7()
    {
        return isset($this->StringField7) ? $this->StringField7 : null;
    }
    /**
     * Set StringField7 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField7
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField7($stringField7 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField7) && !is_string($stringField7)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField7, true), gettype($stringField7)), __LINE__);
        }
        if (is_null($stringField7) || (is_array($stringField7) && empty($stringField7))) {
            unset($this->StringField7);
        } else {
            $this->StringField7 = $stringField7;
        }
        return $this;
    }
    /**
     * Get StringField8 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField8()
    {
        return isset($this->StringField8) ? $this->StringField8 : null;
    }
    /**
     * Set StringField8 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField8
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField8($stringField8 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField8) && !is_string($stringField8)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField8, true), gettype($stringField8)), __LINE__);
        }
        if (is_null($stringField8) || (is_array($stringField8) && empty($stringField8))) {
            unset($this->StringField8);
        } else {
            $this->StringField8 = $stringField8;
        }
        return $this;
    }
    /**
     * Get StringField9 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringField9()
    {
        return isset($this->StringField9) ? $this->StringField9 : null;
    }
    /**
     * Set StringField9 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringField9
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setStringField9($stringField9 = null)
    {
        // validation for constraint: string
        if (!is_null($stringField9) && !is_string($stringField9)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringField9, true), gettype($stringField9)), __LINE__);
        }
        if (is_null($stringField9) || (is_array($stringField9) && empty($stringField9))) {
            unset($this->StringField9);
        } else {
            $this->StringField9 = $stringField9;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $crmSyncEntitySync_ClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($crmSyncEntitySync_ClientTypeItem)) {
                $invalidValues[] = is_object($crmSyncEntitySync_ClientTypeItem) ? get_class($crmSyncEntitySync_ClientTypeItem) : sprintf('%s(%s)', gettype($crmSyncEntitySync_ClientTypeItem), var_export($crmSyncEntitySync_ClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get WebSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite()
    {
        return isset($this->WebSite) ? $this->WebSite : null;
    }
    /**
     * Set WebSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite
     * @return \patest\StructType\CrmSyncEntitySync_Client
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        if (is_null($webSite) || (is_array($webSite) && empty($webSite))) {
            unset($this->WebSite);
        } else {
            $this->WebSite = $webSite;
        }
        return $this;
    }
}
