<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CriteriaVector StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CriteriaVector
 * @subpackage Structs
 */
class CriteriaVector extends AbstractStructBase
{
    /**
     * The CriteriaFromAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAbstractCriteria
     */
    public $CriteriaFromAreas;
    /**
     * The LogicType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LogicType;
    /**
     * The MaxNumberOfResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxNumberOfResults;
    /**
     * The SortData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSortKeyData
     */
    public $SortData;
    /**
     * Constructor method for CriteriaVector
     * @uses CriteriaVector::setCriteriaFromAreas()
     * @uses CriteriaVector::setLogicType()
     * @uses CriteriaVector::setMaxNumberOfResults()
     * @uses CriteriaVector::setSortData()
     * @param \patest\ArrayType\ArrayOfAbstractCriteria $criteriaFromAreas
     * @param string $logicType
     * @param int $maxNumberOfResults
     * @param \patest\ArrayType\ArrayOfSortKeyData $sortData
     */
    public function __construct(\patest\ArrayType\ArrayOfAbstractCriteria $criteriaFromAreas = null, $logicType = null, $maxNumberOfResults = null, \patest\ArrayType\ArrayOfSortKeyData $sortData = null)
    {
        $this
            ->setCriteriaFromAreas($criteriaFromAreas)
            ->setLogicType($logicType)
            ->setMaxNumberOfResults($maxNumberOfResults)
            ->setSortData($sortData);
    }
    /**
     * Get CriteriaFromAreas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAbstractCriteria|null
     */
    public function getCriteriaFromAreas()
    {
        return isset($this->CriteriaFromAreas) ? $this->CriteriaFromAreas : null;
    }
    /**
     * Set CriteriaFromAreas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAbstractCriteria $criteriaFromAreas
     * @return \patest\StructType\CriteriaVector
     */
    public function setCriteriaFromAreas(\patest\ArrayType\ArrayOfAbstractCriteria $criteriaFromAreas = null)
    {
        if (is_null($criteriaFromAreas) || (is_array($criteriaFromAreas) && empty($criteriaFromAreas))) {
            unset($this->CriteriaFromAreas);
        } else {
            $this->CriteriaFromAreas = $criteriaFromAreas;
        }
        return $this;
    }
    /**
     * Get LogicType value
     * @return string|null
     */
    public function getLogicType()
    {
        return $this->LogicType;
    }
    /**
     * Set LogicType value
     * @uses \patest\EnumType\CrossServiceSearchCriteriaType::valueIsValid()
     * @uses \patest\EnumType\CrossServiceSearchCriteriaType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logicType
     * @return \patest\StructType\CriteriaVector
     */
    public function setLogicType($logicType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossServiceSearchCriteriaType::valueIsValid($logicType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossServiceSearchCriteriaType', is_array($logicType) ? implode(', ', $logicType) : var_export($logicType, true), implode(', ', \patest\EnumType\CrossServiceSearchCriteriaType::getValidValues())), __LINE__);
        }
        $this->LogicType = $logicType;
        return $this;
    }
    /**
     * Get MaxNumberOfResults value
     * @return int|null
     */
    public function getMaxNumberOfResults()
    {
        return $this->MaxNumberOfResults;
    }
    /**
     * Set MaxNumberOfResults value
     * @param int $maxNumberOfResults
     * @return \patest\StructType\CriteriaVector
     */
    public function setMaxNumberOfResults($maxNumberOfResults = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfResults) && !(is_int($maxNumberOfResults) || ctype_digit($maxNumberOfResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfResults, true), gettype($maxNumberOfResults)), __LINE__);
        }
        $this->MaxNumberOfResults = $maxNumberOfResults;
        return $this;
    }
    /**
     * Get SortData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSortKeyData|null
     */
    public function getSortData()
    {
        return isset($this->SortData) ? $this->SortData : null;
    }
    /**
     * Set SortData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSortKeyData $sortData
     * @return \patest\StructType\CriteriaVector
     */
    public function setSortData(\patest\ArrayType\ArrayOfSortKeyData $sortData = null)
    {
        if (is_null($sortData) || (is_array($sortData) && empty($sortData))) {
            unset($this->SortData);
        } else {
            $this->SortData = $sortData;
        }
        return $this;
    }
}
