<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCardPartnerDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreditCardPartnerDescriptor
 * @subpackage Structs
 */
class CreditCardPartnerDescriptor extends AbstractStructBase
{
    /**
     * The BINCodesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BINCodesCount;
    /**
     * The CreditCardCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CreditCardCompanyId;
    /**
     * The Image
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image;
    /**
     * The IsCreditCardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCreditCardType;
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Key;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Value;
    /**
     * Constructor method for CreditCardPartnerDescriptor
     * @uses CreditCardPartnerDescriptor::setBINCodesCount()
     * @uses CreditCardPartnerDescriptor::setCreditCardCompanyId()
     * @uses CreditCardPartnerDescriptor::setImage()
     * @uses CreditCardPartnerDescriptor::setIsCreditCardType()
     * @uses CreditCardPartnerDescriptor::setKey()
     * @uses CreditCardPartnerDescriptor::setValue()
     * @param int $bINCodesCount
     * @param string $creditCardCompanyId
     * @param string $image
     * @param bool $isCreditCardType
     * @param string $key
     * @param string $value
     */
    public function __construct($bINCodesCount = null, $creditCardCompanyId = null, $image = null, $isCreditCardType = null, $key = null, $value = null)
    {
        $this
            ->setBINCodesCount($bINCodesCount)
            ->setCreditCardCompanyId($creditCardCompanyId)
            ->setImage($image)
            ->setIsCreditCardType($isCreditCardType)
            ->setKey($key)
            ->setValue($value);
    }
    /**
     * Get BINCodesCount value
     * @return int|null
     */
    public function getBINCodesCount()
    {
        return $this->BINCodesCount;
    }
    /**
     * Set BINCodesCount value
     * @param int $bINCodesCount
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setBINCodesCount($bINCodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($bINCodesCount) && !(is_int($bINCodesCount) || ctype_digit($bINCodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bINCodesCount, true), gettype($bINCodesCount)), __LINE__);
        }
        $this->BINCodesCount = $bINCodesCount;
        return $this;
    }
    /**
     * Get CreditCardCompanyId value
     * @return string|null
     */
    public function getCreditCardCompanyId()
    {
        return $this->CreditCardCompanyId;
    }
    /**
     * Set CreditCardCompanyId value
     * @param string $creditCardCompanyId
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setCreditCardCompanyId($creditCardCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($creditCardCompanyId) && !is_string($creditCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creditCardCompanyId, true), gettype($creditCardCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($creditCardCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $creditCardCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($creditCardCompanyId, true)), __LINE__);
        }
        $this->CreditCardCompanyId = $creditCardCompanyId;
        return $this;
    }
    /**
     * Get Image value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage()
    {
        return isset($this->Image) ? $this->Image : null;
    }
    /**
     * Set Image value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setImage($image = null)
    {
        // validation for constraint: string
        if (!is_null($image) && !is_string($image)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image, true), gettype($image)), __LINE__);
        }
        if (is_null($image) || (is_array($image) && empty($image))) {
            unset($this->Image);
        } else {
            $this->Image = $image;
        }
        return $this;
    }
    /**
     * Get IsCreditCardType value
     * @return bool|null
     */
    public function getIsCreditCardType()
    {
        return $this->IsCreditCardType;
    }
    /**
     * Set IsCreditCardType value
     * @param bool $isCreditCardType
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setIsCreditCardType($isCreditCardType = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCreditCardType) && !is_bool($isCreditCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCreditCardType, true), gettype($isCreditCardType)), __LINE__);
        }
        $this->IsCreditCardType = $isCreditCardType;
        return $this;
    }
    /**
     * Get Key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * Set Key value
     * @param string $key
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($key) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($key, true)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $value
     * @return \patest\StructType\CreditCardPartnerDescriptor
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
