<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePresale-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePresale-Request
 * @subpackage Structs
 */
class CreatePresale_Request extends ExtensibleDataContract
{
    /**
     * The Presale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PresaleDescriptor
     */
    public $Presale;
    /**
     * The UseBestEffort
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseBestEffort;
    /**
     * Constructor method for CreatePresale-Request
     * @uses CreatePresale_Request::setPresale()
     * @uses CreatePresale_Request::setUseBestEffort()
     * @param \patest\StructType\PresaleDescriptor $presale
     * @param bool $useBestEffort
     */
    public function __construct(\patest\StructType\PresaleDescriptor $presale = null, $useBestEffort = null)
    {
        $this
            ->setPresale($presale)
            ->setUseBestEffort($useBestEffort);
    }
    /**
     * Get Presale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PresaleDescriptor|null
     */
    public function getPresale()
    {
        return isset($this->Presale) ? $this->Presale : null;
    }
    /**
     * Set Presale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PresaleDescriptor $presale
     * @return \patest\StructType\CreatePresale_Request
     */
    public function setPresale(\patest\StructType\PresaleDescriptor $presale = null)
    {
        if (is_null($presale) || (is_array($presale) && empty($presale))) {
            unset($this->Presale);
        } else {
            $this->Presale = $presale;
        }
        return $this;
    }
    /**
     * Get UseBestEffort value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseBestEffort()
    {
        return isset($this->UseBestEffort) ? $this->UseBestEffort : null;
    }
    /**
     * Set UseBestEffort value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useBestEffort
     * @return \patest\StructType\CreatePresale_Request
     */
    public function setUseBestEffort($useBestEffort = null)
    {
        // validation for constraint: boolean
        if (!is_null($useBestEffort) && !is_bool($useBestEffort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useBestEffort, true), gettype($useBestEffort)), __LINE__);
        }
        if (is_null($useBestEffort) || (is_array($useBestEffort) && empty($useBestEffort))) {
            unset($this->UseBestEffort);
        } else {
            $this->UseBestEffort = $useBestEffort;
        }
        return $this;
    }
}
