<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePaymentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreatePaymentRequest
 * @subpackage Structs
 */
class CreatePaymentRequest extends CreatePaymentContextRequest
{
    /**
     * The BackofficeClientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BackofficeClientId;
    /**
     * The ConfigurationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationId;
    /**
     * The ProviderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderId;
    /**
     * Constructor method for CreatePaymentRequest
     * @uses CreatePaymentRequest::setBackofficeClientId()
     * @uses CreatePaymentRequest::setConfigurationId()
     * @uses CreatePaymentRequest::setProviderId()
     * @param string $backofficeClientId
     * @param string $configurationId
     * @param string $providerId
     */
    public function __construct($backofficeClientId = null, $configurationId = null, $providerId = null)
    {
        $this
            ->setBackofficeClientId($backofficeClientId)
            ->setConfigurationId($configurationId)
            ->setProviderId($providerId);
    }
    /**
     * Get BackofficeClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackofficeClientId()
    {
        return isset($this->BackofficeClientId) ? $this->BackofficeClientId : null;
    }
    /**
     * Set BackofficeClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backofficeClientId
     * @return \patest\StructType\CreatePaymentRequest
     */
    public function setBackofficeClientId($backofficeClientId = null)
    {
        // validation for constraint: string
        if (!is_null($backofficeClientId) && !is_string($backofficeClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backofficeClientId, true), gettype($backofficeClientId)), __LINE__);
        }
        if (is_null($backofficeClientId) || (is_array($backofficeClientId) && empty($backofficeClientId))) {
            unset($this->BackofficeClientId);
        } else {
            $this->BackofficeClientId = $backofficeClientId;
        }
        return $this;
    }
    /**
     * Get ConfigurationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationId()
    {
        return isset($this->ConfigurationId) ? $this->ConfigurationId : null;
    }
    /**
     * Set ConfigurationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configurationId
     * @return \patest\StructType\CreatePaymentRequest
     */
    public function setConfigurationId($configurationId = null)
    {
        // validation for constraint: string
        if (!is_null($configurationId) && !is_string($configurationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurationId, true), gettype($configurationId)), __LINE__);
        }
        if (is_null($configurationId) || (is_array($configurationId) && empty($configurationId))) {
            unset($this->ConfigurationId);
        } else {
            $this->ConfigurationId = $configurationId;
        }
        return $this;
    }
    /**
     * Get ProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderId()
    {
        return isset($this->ProviderId) ? $this->ProviderId : null;
    }
    /**
     * Set ProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerId
     * @return \patest\StructType\CreatePaymentRequest
     */
    public function setProviderId($providerId = null)
    {
        // validation for constraint: string
        if (!is_null($providerId) && !is_string($providerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerId, true), gettype($providerId)), __LINE__);
        }
        if (is_null($providerId) || (is_array($providerId) && empty($providerId))) {
            unset($this->ProviderId);
        } else {
            $this->ProviderId = $providerId;
        }
        return $this;
    }
}
