<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdateTicketViewComponentRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateOrUpdateTicketViewComponentRequestBase
 * @subpackage Structs
 */
class CreateOrUpdateTicketViewComponentRequestBase extends ExtensibleDataContract
{
    /**
     * The AdditionalTicketBackNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AdditionalTicketBackNotes
     */
    public $AdditionalTicketBackNotes;
    /**
     * The ComponentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComponentName;
    /**
     * The ComponentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ComponentType;
    /**
     * The EventHeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventHeaderOverrideRequest
     */
    public $EventHeader;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHidden;
    /**
     * The MyTicketsCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MyTicketsCardRequest
     */
    public $MyTicketsCard;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The TicketDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketDetailsOverride
     */
    public $TicketDetails;
    /**
     * The TicketFooterNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketFooterNoteOverride
     */
    public $TicketFooterNotes;
    /**
     * The TicketStyle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketStyleOverrideRequest
     */
    public $TicketStyle;
    /**
     * Constructor method for CreateOrUpdateTicketViewComponentRequestBase
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setAdditionalTicketBackNotes()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setComponentName()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setComponentType()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setEventHeader()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setIsHidden()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setMyTicketsCard()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setOrganizationUnitId()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setTicketDetails()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setTicketFooterNotes()
     * @uses CreateOrUpdateTicketViewComponentRequestBase::setTicketStyle()
     * @param \patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes
     * @param string $componentName
     * @param string $componentType
     * @param \patest\StructType\EventHeaderOverrideRequest $eventHeader
     * @param bool $isHidden
     * @param \patest\StructType\MyTicketsCardRequest $myTicketsCard
     * @param string $organizationUnitId
     * @param \patest\StructType\TicketDetailsOverride $ticketDetails
     * @param \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes
     * @param \patest\StructType\TicketStyleOverrideRequest $ticketStyle
     */
    public function __construct(\patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes = null, $componentName = null, $componentType = null, \patest\StructType\EventHeaderOverrideRequest $eventHeader = null, $isHidden = null, \patest\StructType\MyTicketsCardRequest $myTicketsCard = null, $organizationUnitId = null, \patest\StructType\TicketDetailsOverride $ticketDetails = null, \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes = null, \patest\StructType\TicketStyleOverrideRequest $ticketStyle = null)
    {
        $this
            ->setAdditionalTicketBackNotes($additionalTicketBackNotes)
            ->setComponentName($componentName)
            ->setComponentType($componentType)
            ->setEventHeader($eventHeader)
            ->setIsHidden($isHidden)
            ->setMyTicketsCard($myTicketsCard)
            ->setOrganizationUnitId($organizationUnitId)
            ->setTicketDetails($ticketDetails)
            ->setTicketFooterNotes($ticketFooterNotes)
            ->setTicketStyle($ticketStyle);
    }
    /**
     * Get AdditionalTicketBackNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AdditionalTicketBackNotes|null
     */
    public function getAdditionalTicketBackNotes()
    {
        return isset($this->AdditionalTicketBackNotes) ? $this->AdditionalTicketBackNotes : null;
    }
    /**
     * Set AdditionalTicketBackNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setAdditionalTicketBackNotes(\patest\StructType\AdditionalTicketBackNotes $additionalTicketBackNotes = null)
    {
        if (is_null($additionalTicketBackNotes) || (is_array($additionalTicketBackNotes) && empty($additionalTicketBackNotes))) {
            unset($this->AdditionalTicketBackNotes);
        } else {
            $this->AdditionalTicketBackNotes = $additionalTicketBackNotes;
        }
        return $this;
    }
    /**
     * Get ComponentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComponentName()
    {
        return isset($this->ComponentName) ? $this->ComponentName : null;
    }
    /**
     * Set ComponentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $componentName
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setComponentName($componentName = null)
    {
        // validation for constraint: string
        if (!is_null($componentName) && !is_string($componentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentName, true), gettype($componentName)), __LINE__);
        }
        if (is_null($componentName) || (is_array($componentName) && empty($componentName))) {
            unset($this->ComponentName);
        } else {
            $this->ComponentName = $componentName;
        }
        return $this;
    }
    /**
     * Get ComponentType value
     * @return string|null
     */
    public function getComponentType()
    {
        return $this->ComponentType;
    }
    /**
     * Set ComponentType value
     * @uses \patest\EnumType\TicketConfigurationComponentType::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationComponentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $componentType
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setComponentType($componentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationComponentType::valueIsValid($componentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationComponentType', is_array($componentType) ? implode(', ', $componentType) : var_export($componentType, true), implode(', ', \patest\EnumType\TicketConfigurationComponentType::getValidValues())), __LINE__);
        }
        $this->ComponentType = $componentType;
        return $this;
    }
    /**
     * Get EventHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventHeaderOverrideRequest|null
     */
    public function getEventHeader()
    {
        return isset($this->EventHeader) ? $this->EventHeader : null;
    }
    /**
     * Set EventHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventHeaderOverrideRequest $eventHeader
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setEventHeader(\patest\StructType\EventHeaderOverrideRequest $eventHeader = null)
    {
        if (is_null($eventHeader) || (is_array($eventHeader) && empty($eventHeader))) {
            unset($this->EventHeader);
        } else {
            $this->EventHeader = $eventHeader;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param bool $isHidden
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get MyTicketsCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MyTicketsCardRequest|null
     */
    public function getMyTicketsCard()
    {
        return isset($this->MyTicketsCard) ? $this->MyTicketsCard : null;
    }
    /**
     * Set MyTicketsCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MyTicketsCardRequest $myTicketsCard
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setMyTicketsCard(\patest\StructType\MyTicketsCardRequest $myTicketsCard = null)
    {
        if (is_null($myTicketsCard) || (is_array($myTicketsCard) && empty($myTicketsCard))) {
            unset($this->MyTicketsCard);
        } else {
            $this->MyTicketsCard = $myTicketsCard;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get TicketDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketDetailsOverride|null
     */
    public function getTicketDetails()
    {
        return isset($this->TicketDetails) ? $this->TicketDetails : null;
    }
    /**
     * Set TicketDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketDetailsOverride $ticketDetails
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setTicketDetails(\patest\StructType\TicketDetailsOverride $ticketDetails = null)
    {
        if (is_null($ticketDetails) || (is_array($ticketDetails) && empty($ticketDetails))) {
            unset($this->TicketDetails);
        } else {
            $this->TicketDetails = $ticketDetails;
        }
        return $this;
    }
    /**
     * Get TicketFooterNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketFooterNoteOverride|null
     */
    public function getTicketFooterNotes()
    {
        return isset($this->TicketFooterNotes) ? $this->TicketFooterNotes : null;
    }
    /**
     * Set TicketFooterNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketFooterNoteOverride $ticketFooterNotes
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setTicketFooterNotes(\patest\StructType\TicketFooterNoteOverride $ticketFooterNotes = null)
    {
        if (is_null($ticketFooterNotes) || (is_array($ticketFooterNotes) && empty($ticketFooterNotes))) {
            unset($this->TicketFooterNotes);
        } else {
            $this->TicketFooterNotes = $ticketFooterNotes;
        }
        return $this;
    }
    /**
     * Get TicketStyle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketStyleOverrideRequest|null
     */
    public function getTicketStyle()
    {
        return isset($this->TicketStyle) ? $this->TicketStyle : null;
    }
    /**
     * Set TicketStyle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketStyleOverrideRequest $ticketStyle
     * @return \patest\StructType\CreateOrUpdateTicketViewComponentRequestBase
     */
    public function setTicketStyle(\patest\StructType\TicketStyleOverrideRequest $ticketStyle = null)
    {
        if (is_null($ticketStyle) || (is_array($ticketStyle) && empty($ticketStyle))) {
            unset($this->TicketStyle);
        } else {
            $this->TicketStyle = $ticketStyle;
        }
        return $this;
    }
}
