<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdatePriceList-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateOrUpdatePriceList-Request
 * @subpackage Structs
 */
class CreateOrUpdatePriceList_Request extends AbstractStructBase
{
    /**
     * The NewBasePrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBasePriceListCell
     */
    public $NewBasePrices;
    /**
     * The NewPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPriceListCell
     */
    public $NewPrices;
    /**
     * The PriceListId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceListId;
    /**
     * The OperationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationType;
    /**
     * The PriceListName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceListName;
    /**
     * Constructor method for CreateOrUpdatePriceList-Request
     * @uses CreateOrUpdatePriceList_Request::setNewBasePrices()
     * @uses CreateOrUpdatePriceList_Request::setNewPrices()
     * @uses CreateOrUpdatePriceList_Request::setPriceListId()
     * @uses CreateOrUpdatePriceList_Request::setOperationType()
     * @uses CreateOrUpdatePriceList_Request::setPriceListName()
     * @param \patest\ArrayType\ArrayOfBasePriceListCell $newBasePrices
     * @param \patest\ArrayType\ArrayOfPriceListCell $newPrices
     * @param string $priceListId
     * @param string $operationType
     * @param string $priceListName
     */
    public function __construct(\patest\ArrayType\ArrayOfBasePriceListCell $newBasePrices = null, \patest\ArrayType\ArrayOfPriceListCell $newPrices = null, $priceListId = null, $operationType = null, $priceListName = null)
    {
        $this
            ->setNewBasePrices($newBasePrices)
            ->setNewPrices($newPrices)
            ->setPriceListId($priceListId)
            ->setOperationType($operationType)
            ->setPriceListName($priceListName);
    }
    /**
     * Get NewBasePrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBasePriceListCell|null
     */
    public function getNewBasePrices()
    {
        return isset($this->NewBasePrices) ? $this->NewBasePrices : null;
    }
    /**
     * Set NewBasePrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBasePriceListCell $newBasePrices
     * @return \patest\StructType\CreateOrUpdatePriceList_Request
     */
    public function setNewBasePrices(\patest\ArrayType\ArrayOfBasePriceListCell $newBasePrices = null)
    {
        if (is_null($newBasePrices) || (is_array($newBasePrices) && empty($newBasePrices))) {
            unset($this->NewBasePrices);
        } else {
            $this->NewBasePrices = $newBasePrices;
        }
        return $this;
    }
    /**
     * Get NewPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPriceListCell|null
     */
    public function getNewPrices()
    {
        return isset($this->NewPrices) ? $this->NewPrices : null;
    }
    /**
     * Set NewPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPriceListCell $newPrices
     * @return \patest\StructType\CreateOrUpdatePriceList_Request
     */
    public function setNewPrices(\patest\ArrayType\ArrayOfPriceListCell $newPrices = null)
    {
        if (is_null($newPrices) || (is_array($newPrices) && empty($newPrices))) {
            unset($this->NewPrices);
        } else {
            $this->NewPrices = $newPrices;
        }
        return $this;
    }
    /**
     * Get PriceListId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListId()
    {
        return isset($this->PriceListId) ? $this->PriceListId : null;
    }
    /**
     * Set PriceListId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListId
     * @return \patest\StructType\CreateOrUpdatePriceList_Request
     */
    public function setPriceListId($priceListId = null)
    {
        // validation for constraint: string
        if (!is_null($priceListId) && !is_string($priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListId, true), gettype($priceListId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceListId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceListId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceListId, true)), __LINE__);
        }
        if (is_null($priceListId) || (is_array($priceListId) && empty($priceListId))) {
            unset($this->PriceListId);
        } else {
            $this->PriceListId = $priceListId;
        }
        return $this;
    }
    /**
     * Get OperationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationType()
    {
        return isset($this->OperationType) ? $this->OperationType : null;
    }
    /**
     * Set OperationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationType
     * @return \patest\StructType\CreateOrUpdatePriceList_Request
     */
    public function setOperationType($operationType = null)
    {
        // validation for constraint: string
        if (!is_null($operationType) && !is_string($operationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationType, true), gettype($operationType)), __LINE__);
        }
        if (is_null($operationType) || (is_array($operationType) && empty($operationType))) {
            unset($this->OperationType);
        } else {
            $this->OperationType = $operationType;
        }
        return $this;
    }
    /**
     * Get PriceListName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceListName()
    {
        return isset($this->PriceListName) ? $this->PriceListName : null;
    }
    /**
     * Set PriceListName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceListName
     * @return \patest\StructType\CreateOrUpdatePriceList_Request
     */
    public function setPriceListName($priceListName = null)
    {
        // validation for constraint: string
        if (!is_null($priceListName) && !is_string($priceListName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceListName, true), gettype($priceListName)), __LINE__);
        }
        if (is_null($priceListName) || (is_array($priceListName) && empty($priceListName))) {
            unset($this->PriceListName);
        } else {
            $this->PriceListName = $priceListName;
        }
        return $this;
    }
}
