<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateDraftInvoices-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CreateDraftInvoices-Request
 * @subpackage Structs
 */
class CreateDraftInvoices_Request extends AbstractStructBase
{
    /**
     * The Defaults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CreateDraftInvoicesDefaults
     */
    public $Defaults;
    /**
     * The EmailDataIsSetPerSingleRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EmailDataIsSetPerSingleRequest;
    /**
     * The InvoiceDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceDocumentId;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The Requests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest
     */
    public $Requests;
    /**
     * The SendByEmailData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SendByEmailData
     */
    public $SendByEmailData;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * Constructor method for CreateDraftInvoices-Request
     * @uses CreateDraftInvoices_Request::setDefaults()
     * @uses CreateDraftInvoices_Request::setEmailDataIsSetPerSingleRequest()
     * @uses CreateDraftInvoices_Request::setInvoiceDocumentId()
     * @uses CreateDraftInvoices_Request::setIsSendByEmail()
     * @uses CreateDraftInvoices_Request::setRequests()
     * @uses CreateDraftInvoices_Request::setSendByEmailData()
     * @uses CreateDraftInvoices_Request::setTargetPrinterId()
     * @param \patest\StructType\CreateDraftInvoicesDefaults $defaults
     * @param bool $emailDataIsSetPerSingleRequest
     * @param string $invoiceDocumentId
     * @param bool $isSendByEmail
     * @param \patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest $requests
     * @param \patest\StructType\SendByEmailData $sendByEmailData
     * @param string $targetPrinterId
     */
    public function __construct(\patest\StructType\CreateDraftInvoicesDefaults $defaults = null, $emailDataIsSetPerSingleRequest = null, $invoiceDocumentId = null, $isSendByEmail = null, \patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest $requests = null, \patest\StructType\SendByEmailData $sendByEmailData = null, $targetPrinterId = null)
    {
        $this
            ->setDefaults($defaults)
            ->setEmailDataIsSetPerSingleRequest($emailDataIsSetPerSingleRequest)
            ->setInvoiceDocumentId($invoiceDocumentId)
            ->setIsSendByEmail($isSendByEmail)
            ->setRequests($requests)
            ->setSendByEmailData($sendByEmailData)
            ->setTargetPrinterId($targetPrinterId);
    }
    /**
     * Get Defaults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CreateDraftInvoicesDefaults|null
     */
    public function getDefaults()
    {
        return isset($this->Defaults) ? $this->Defaults : null;
    }
    /**
     * Set Defaults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CreateDraftInvoicesDefaults $defaults
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setDefaults(\patest\StructType\CreateDraftInvoicesDefaults $defaults = null)
    {
        if (is_null($defaults) || (is_array($defaults) && empty($defaults))) {
            unset($this->Defaults);
        } else {
            $this->Defaults = $defaults;
        }
        return $this;
    }
    /**
     * Get EmailDataIsSetPerSingleRequest value
     * @return bool|null
     */
    public function getEmailDataIsSetPerSingleRequest()
    {
        return $this->EmailDataIsSetPerSingleRequest;
    }
    /**
     * Set EmailDataIsSetPerSingleRequest value
     * @param bool $emailDataIsSetPerSingleRequest
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setEmailDataIsSetPerSingleRequest($emailDataIsSetPerSingleRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($emailDataIsSetPerSingleRequest) && !is_bool($emailDataIsSetPerSingleRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($emailDataIsSetPerSingleRequest, true), gettype($emailDataIsSetPerSingleRequest)), __LINE__);
        }
        $this->EmailDataIsSetPerSingleRequest = $emailDataIsSetPerSingleRequest;
        return $this;
    }
    /**
     * Get InvoiceDocumentId value
     * @return string|null
     */
    public function getInvoiceDocumentId()
    {
        return $this->InvoiceDocumentId;
    }
    /**
     * Set InvoiceDocumentId value
     * @param string $invoiceDocumentId
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setInvoiceDocumentId($invoiceDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDocumentId) && !is_string($invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDocumentId, true), gettype($invoiceDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceDocumentId, true)), __LINE__);
        }
        $this->InvoiceDocumentId = $invoiceDocumentId;
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return $this->IsSendByEmail;
    }
    /**
     * Set IsSendByEmail value
     * @param bool $isSendByEmail
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        $this->IsSendByEmail = $isSendByEmail;
        return $this;
    }
    /**
     * Get Requests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest|null
     */
    public function getRequests()
    {
        return isset($this->Requests) ? $this->Requests : null;
    }
    /**
     * Set Requests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest $requests
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setRequests(\patest\ArrayType\ArrayOfCreateSingleDraftInvoiceRequest $requests = null)
    {
        if (is_null($requests) || (is_array($requests) && empty($requests))) {
            unset($this->Requests);
        } else {
            $this->Requests = $requests;
        }
        return $this;
    }
    /**
     * Get SendByEmailData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SendByEmailData|null
     */
    public function getSendByEmailData()
    {
        return isset($this->SendByEmailData) ? $this->SendByEmailData : null;
    }
    /**
     * Set SendByEmailData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SendByEmailData $sendByEmailData
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setSendByEmailData(\patest\StructType\SendByEmailData $sendByEmailData = null)
    {
        if (is_null($sendByEmailData) || (is_array($sendByEmailData) && empty($sendByEmailData))) {
            unset($this->SendByEmailData);
        } else {
            $this->SendByEmailData = $sendByEmailData;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\CreateDraftInvoices_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
}
