<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CopyEvent-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CopyEvent-Response
 * @subpackage Structs
 */
class CopyEvent_Response extends ExtensibleDataContract
{
    /**
     * The AllCopiesCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllCopiesCreated;
    /**
     * The NumberOfEventsCreated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfEventsCreated;
    /**
     * The DatesOfOverlaps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $DatesOfOverlaps;
    /**
     * The EventsDatesAndTimes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfdateTime
     */
    public $EventsDatesAndTimes;
    /**
     * The NewEventsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $NewEventsIds;
    /**
     * Constructor method for CopyEvent-Response
     * @uses CopyEvent_Response::setAllCopiesCreated()
     * @uses CopyEvent_Response::setNumberOfEventsCreated()
     * @uses CopyEvent_Response::setDatesOfOverlaps()
     * @uses CopyEvent_Response::setEventsDatesAndTimes()
     * @uses CopyEvent_Response::setNewEventsIds()
     * @param bool $allCopiesCreated
     * @param int $numberOfEventsCreated
     * @param \patest\ArrayType\ArrayOfdateTime $datesOfOverlaps
     * @param \patest\ArrayType\ArrayOfdateTime $eventsDatesAndTimes
     * @param \patest\ArrayType\ArrayOfguid $newEventsIds
     */
    public function __construct($allCopiesCreated = null, $numberOfEventsCreated = null, \patest\ArrayType\ArrayOfdateTime $datesOfOverlaps = null, \patest\ArrayType\ArrayOfdateTime $eventsDatesAndTimes = null, \patest\ArrayType\ArrayOfguid $newEventsIds = null)
    {
        $this
            ->setAllCopiesCreated($allCopiesCreated)
            ->setNumberOfEventsCreated($numberOfEventsCreated)
            ->setDatesOfOverlaps($datesOfOverlaps)
            ->setEventsDatesAndTimes($eventsDatesAndTimes)
            ->setNewEventsIds($newEventsIds);
    }
    /**
     * Get AllCopiesCreated value
     * @return bool|null
     */
    public function getAllCopiesCreated()
    {
        return $this->AllCopiesCreated;
    }
    /**
     * Set AllCopiesCreated value
     * @param bool $allCopiesCreated
     * @return \patest\StructType\CopyEvent_Response
     */
    public function setAllCopiesCreated($allCopiesCreated = null)
    {
        // validation for constraint: boolean
        if (!is_null($allCopiesCreated) && !is_bool($allCopiesCreated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allCopiesCreated, true), gettype($allCopiesCreated)), __LINE__);
        }
        $this->AllCopiesCreated = $allCopiesCreated;
        return $this;
    }
    /**
     * Get NumberOfEventsCreated value
     * @return int|null
     */
    public function getNumberOfEventsCreated()
    {
        return $this->NumberOfEventsCreated;
    }
    /**
     * Set NumberOfEventsCreated value
     * @param int $numberOfEventsCreated
     * @return \patest\StructType\CopyEvent_Response
     */
    public function setNumberOfEventsCreated($numberOfEventsCreated = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfEventsCreated) && !(is_int($numberOfEventsCreated) || ctype_digit($numberOfEventsCreated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfEventsCreated, true), gettype($numberOfEventsCreated)), __LINE__);
        }
        $this->NumberOfEventsCreated = $numberOfEventsCreated;
        return $this;
    }
    /**
     * Get DatesOfOverlaps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getDatesOfOverlaps()
    {
        return isset($this->DatesOfOverlaps) ? $this->DatesOfOverlaps : null;
    }
    /**
     * Set DatesOfOverlaps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $datesOfOverlaps
     * @return \patest\StructType\CopyEvent_Response
     */
    public function setDatesOfOverlaps(\patest\ArrayType\ArrayOfdateTime $datesOfOverlaps = null)
    {
        if (is_null($datesOfOverlaps) || (is_array($datesOfOverlaps) && empty($datesOfOverlaps))) {
            unset($this->DatesOfOverlaps);
        } else {
            $this->DatesOfOverlaps = $datesOfOverlaps;
        }
        return $this;
    }
    /**
     * Get EventsDatesAndTimes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfdateTime|null
     */
    public function getEventsDatesAndTimes()
    {
        return isset($this->EventsDatesAndTimes) ? $this->EventsDatesAndTimes : null;
    }
    /**
     * Set EventsDatesAndTimes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfdateTime $eventsDatesAndTimes
     * @return \patest\StructType\CopyEvent_Response
     */
    public function setEventsDatesAndTimes(\patest\ArrayType\ArrayOfdateTime $eventsDatesAndTimes = null)
    {
        if (is_null($eventsDatesAndTimes) || (is_array($eventsDatesAndTimes) && empty($eventsDatesAndTimes))) {
            unset($this->EventsDatesAndTimes);
        } else {
            $this->EventsDatesAndTimes = $eventsDatesAndTimes;
        }
        return $this;
    }
    /**
     * Get NewEventsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getNewEventsIds()
    {
        return isset($this->NewEventsIds) ? $this->NewEventsIds : null;
    }
    /**
     * Set NewEventsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $newEventsIds
     * @return \patest\StructType\CopyEvent_Response
     */
    public function setNewEventsIds(\patest\ArrayType\ArrayOfguid $newEventsIds = null)
    {
        if (is_null($newEventsIds) || (is_array($newEventsIds) && empty($newEventsIds))) {
            unset($this->NewEventsIds);
        } else {
            $this->NewEventsIds = $newEventsIds;
        }
        return $this;
    }
}
