<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Connect-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Connect-Request
 * @subpackage Structs
 */
class Connect_Request extends ExtensibleDataContract
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The CultureName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CultureName;
    /**
     * The ExplicitAuthentication
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExplicitAuthentication;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The TenantCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TenantCompanyId;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * The UserLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserLogin;
    /**
     * The UserPassword
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserPassword;
    /**
     * The WebLinkUri
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebLinkUri;
    /**
     * The SalePointIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointIdentifier;
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The UserToImpersonate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserToImpersonate;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * The WorkflowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WorkflowType;
    /**
     * Constructor method for Connect-Request
     * @uses Connect_Request::setApplicationChannel()
     * @uses Connect_Request::setCultureName()
     * @uses Connect_Request::setExplicitAuthentication()
     * @uses Connect_Request::setSalePointId()
     * @uses Connect_Request::setTenantCompanyId()
     * @uses Connect_Request::setTillId()
     * @uses Connect_Request::setUserLogin()
     * @uses Connect_Request::setUserPassword()
     * @uses Connect_Request::setWebLinkUri()
     * @uses Connect_Request::setSalePointIdentifier()
     * @uses Connect_Request::setApplication()
     * @uses Connect_Request::setUserToImpersonate()
     * @uses Connect_Request::setSecurityTokenId()
     * @uses Connect_Request::setWorkflowType()
     * @param string $applicationChannel
     * @param string $cultureName
     * @param bool $explicitAuthentication
     * @param string $salePointId
     * @param int $tenantCompanyId
     * @param string $tillId
     * @param string $userLogin
     * @param string $userPassword
     * @param string $webLinkUri
     * @param string $salePointIdentifier
     * @param string $application
     * @param string $userToImpersonate
     * @param string $securityTokenId
     * @param string $workflowType
     */
    public function __construct($applicationChannel = null, $cultureName = null, $explicitAuthentication = null, $salePointId = null, $tenantCompanyId = null, $tillId = null, $userLogin = null, $userPassword = null, $webLinkUri = null, $salePointIdentifier = null, $application = null, $userToImpersonate = null, $securityTokenId = null, $workflowType = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setCultureName($cultureName)
            ->setExplicitAuthentication($explicitAuthentication)
            ->setSalePointId($salePointId)
            ->setTenantCompanyId($tenantCompanyId)
            ->setTillId($tillId)
            ->setUserLogin($userLogin)
            ->setUserPassword($userPassword)
            ->setWebLinkUri($webLinkUri)
            ->setSalePointIdentifier($salePointIdentifier)
            ->setApplication($application)
            ->setUserToImpersonate($userToImpersonate)
            ->setSecurityTokenId($securityTokenId)
            ->setWorkflowType($workflowType);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Connect_Request
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get CultureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCultureName()
    {
        return isset($this->CultureName) ? $this->CultureName : null;
    }
    /**
     * Set CultureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cultureName
     * @return \patest\StructType\Connect_Request
     */
    public function setCultureName($cultureName = null)
    {
        // validation for constraint: string
        if (!is_null($cultureName) && !is_string($cultureName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cultureName, true), gettype($cultureName)), __LINE__);
        }
        if (is_null($cultureName) || (is_array($cultureName) && empty($cultureName))) {
            unset($this->CultureName);
        } else {
            $this->CultureName = $cultureName;
        }
        return $this;
    }
    /**
     * Get ExplicitAuthentication value
     * @return bool|null
     */
    public function getExplicitAuthentication()
    {
        return $this->ExplicitAuthentication;
    }
    /**
     * Set ExplicitAuthentication value
     * @param bool $explicitAuthentication
     * @return \patest\StructType\Connect_Request
     */
    public function setExplicitAuthentication($explicitAuthentication = null)
    {
        // validation for constraint: boolean
        if (!is_null($explicitAuthentication) && !is_bool($explicitAuthentication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($explicitAuthentication, true), gettype($explicitAuthentication)), __LINE__);
        }
        $this->ExplicitAuthentication = $explicitAuthentication;
        return $this;
    }
    /**
     * Get SalePointId value
     * @return string|null
     */
    public function getSalePointId()
    {
        return $this->SalePointId;
    }
    /**
     * Set SalePointId value
     * @param string $salePointId
     * @return \patest\StructType\Connect_Request
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        $this->SalePointId = $salePointId;
        return $this;
    }
    /**
     * Get TenantCompanyId value
     * @return int|null
     */
    public function getTenantCompanyId()
    {
        return $this->TenantCompanyId;
    }
    /**
     * Set TenantCompanyId value
     * @param int $tenantCompanyId
     * @return \patest\StructType\Connect_Request
     */
    public function setTenantCompanyId($tenantCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($tenantCompanyId) && !(is_int($tenantCompanyId) || ctype_digit($tenantCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tenantCompanyId, true), gettype($tenantCompanyId)), __LINE__);
        }
        $this->TenantCompanyId = $tenantCompanyId;
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\Connect_Request
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
    /**
     * Get UserLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserLogin()
    {
        return isset($this->UserLogin) ? $this->UserLogin : null;
    }
    /**
     * Set UserLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userLogin
     * @return \patest\StructType\Connect_Request
     */
    public function setUserLogin($userLogin = null)
    {
        // validation for constraint: string
        if (!is_null($userLogin) && !is_string($userLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userLogin, true), gettype($userLogin)), __LINE__);
        }
        if (is_null($userLogin) || (is_array($userLogin) && empty($userLogin))) {
            unset($this->UserLogin);
        } else {
            $this->UserLogin = $userLogin;
        }
        return $this;
    }
    /**
     * Get UserPassword value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserPassword()
    {
        return isset($this->UserPassword) ? $this->UserPassword : null;
    }
    /**
     * Set UserPassword value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userPassword
     * @return \patest\StructType\Connect_Request
     */
    public function setUserPassword($userPassword = null)
    {
        // validation for constraint: string
        if (!is_null($userPassword) && !is_string($userPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userPassword, true), gettype($userPassword)), __LINE__);
        }
        if (is_null($userPassword) || (is_array($userPassword) && empty($userPassword))) {
            unset($this->UserPassword);
        } else {
            $this->UserPassword = $userPassword;
        }
        return $this;
    }
    /**
     * Get WebLinkUri value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebLinkUri()
    {
        return isset($this->WebLinkUri) ? $this->WebLinkUri : null;
    }
    /**
     * Set WebLinkUri value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webLinkUri
     * @return \patest\StructType\Connect_Request
     */
    public function setWebLinkUri($webLinkUri = null)
    {
        // validation for constraint: string
        if (!is_null($webLinkUri) && !is_string($webLinkUri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webLinkUri, true), gettype($webLinkUri)), __LINE__);
        }
        if (is_null($webLinkUri) || (is_array($webLinkUri) && empty($webLinkUri))) {
            unset($this->WebLinkUri);
        } else {
            $this->WebLinkUri = $webLinkUri;
        }
        return $this;
    }
    /**
     * Get SalePointIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointIdentifier()
    {
        return isset($this->SalePointIdentifier) ? $this->SalePointIdentifier : null;
    }
    /**
     * Set SalePointIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointIdentifier
     * @return \patest\StructType\Connect_Request
     */
    public function setSalePointIdentifier($salePointIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($salePointIdentifier) && !is_string($salePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointIdentifier, true), gettype($salePointIdentifier)), __LINE__);
        }
        if (is_null($salePointIdentifier) || (is_array($salePointIdentifier) && empty($salePointIdentifier))) {
            unset($this->SalePointIdentifier);
        } else {
            $this->SalePointIdentifier = $salePointIdentifier;
        }
        return $this;
    }
    /**
     * Get Application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplication()
    {
        return isset($this->Application) ? $this->Application : null;
    }
    /**
     * Set Application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $application
     * @return \patest\StructType\Connect_Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->Application);
        } else {
            $this->Application = $application;
        }
        return $this;
    }
    /**
     * Get UserToImpersonate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserToImpersonate()
    {
        return isset($this->UserToImpersonate) ? $this->UserToImpersonate : null;
    }
    /**
     * Set UserToImpersonate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userToImpersonate
     * @return \patest\StructType\Connect_Request
     */
    public function setUserToImpersonate($userToImpersonate = null)
    {
        // validation for constraint: string
        if (!is_null($userToImpersonate) && !is_string($userToImpersonate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userToImpersonate, true), gettype($userToImpersonate)), __LINE__);
        }
        if (is_null($userToImpersonate) || (is_array($userToImpersonate) && empty($userToImpersonate))) {
            unset($this->UserToImpersonate);
        } else {
            $this->UserToImpersonate = $userToImpersonate;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\Connect_Request
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
    /**
     * Get WorkflowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkflowType()
    {
        return isset($this->WorkflowType) ? $this->WorkflowType : null;
    }
    /**
     * Set WorkflowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkflowType::valueIsValid()
     * @uses \patest\EnumType\WorkflowType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $workflowType
     * @return \patest\StructType\Connect_Request
     */
    public function setWorkflowType($workflowType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkflowType::valueIsValid($workflowType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkflowType', is_array($workflowType) ? implode(', ', $workflowType) : var_export($workflowType, true), implode(', ', \patest\EnumType\WorkflowType::getValidValues())), __LINE__);
        }
        if (is_null($workflowType) || (is_array($workflowType) && empty($workflowType))) {
            unset($this->WorkflowType);
        } else {
            $this->WorkflowType = $workflowType;
        }
        return $this;
    }
}
