<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectWithContextToken-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConnectWithContextToken-Request
 * @subpackage Structs
 */
class ConnectWithContextToken_Request extends ExtensibleDataContract
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ContextId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextId;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The TenantCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TenantCompanyId;
    /**
     * Constructor method for ConnectWithContextToken-Request
     * @uses ConnectWithContextToken_Request::setApplicationChannel()
     * @uses ConnectWithContextToken_Request::setContextId()
     * @uses ConnectWithContextToken_Request::setSalePointId()
     * @uses ConnectWithContextToken_Request::setTenantCompanyId()
     * @param string $applicationChannel
     * @param string $contextId
     * @param string $salePointId
     * @param int $tenantCompanyId
     */
    public function __construct($applicationChannel = null, $contextId = null, $salePointId = null, $tenantCompanyId = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setContextId($contextId)
            ->setSalePointId($salePointId)
            ->setTenantCompanyId($tenantCompanyId);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\ConnectWithContextToken_Request
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ContextId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextId()
    {
        return isset($this->ContextId) ? $this->ContextId : null;
    }
    /**
     * Set ContextId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextId
     * @return \patest\StructType\ConnectWithContextToken_Request
     */
    public function setContextId($contextId = null)
    {
        // validation for constraint: string
        if (!is_null($contextId) && !is_string($contextId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextId, true), gettype($contextId)), __LINE__);
        }
        if (is_null($contextId) || (is_array($contextId) && empty($contextId))) {
            unset($this->ContextId);
        } else {
            $this->ContextId = $contextId;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\ConnectWithContextToken_Request
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get TenantCompanyId value
     * @return int|null
     */
    public function getTenantCompanyId()
    {
        return $this->TenantCompanyId;
    }
    /**
     * Set TenantCompanyId value
     * @param int $tenantCompanyId
     * @return \patest\StructType\ConnectWithContextToken_Request
     */
    public function setTenantCompanyId($tenantCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($tenantCompanyId) && !(is_int($tenantCompanyId) || ctype_digit($tenantCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tenantCompanyId, true), gettype($tenantCompanyId)), __LINE__);
        }
        $this->TenantCompanyId = $tenantCompanyId;
        return $this;
    }
}
