<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitTransaction-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommitTransaction-Response
 * @subpackage Structs
 */
class CommitTransaction_Response extends ExtensibleDataContract
{
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfCodeDescription
     */
    public $Warnings;
    /**
     * The RequiredUserInteraction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\UserInteractionRequiredMessage
     */
    public $RequiredUserInteraction;
    /**
     * The IsCommitted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCommitted;
    /**
     * The ValidationMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTransactionMessageBase
     */
    public $ValidationMessages;
    /**
     * Constructor method for CommitTransaction-Response
     * @uses CommitTransaction_Response::setTransactionSnapshot()
     * @uses CommitTransaction_Response::setWarnings()
     * @uses CommitTransaction_Response::setRequiredUserInteraction()
     * @uses CommitTransaction_Response::setIsCommitted()
     * @uses CommitTransaction_Response::setValidationMessages()
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     * @param \patest\StructType\UserInteractionRequiredMessage $requiredUserInteraction
     * @param bool $isCommitted
     * @param \patest\ArrayType\ArrayOfTransactionMessageBase $validationMessages
     */
    public function __construct(\patest\StructType\TransactionSnapshot $transactionSnapshot = null, \patest\ArrayType\ArrayOfCodeDescription $warnings = null, \patest\StructType\UserInteractionRequiredMessage $requiredUserInteraction = null, $isCommitted = null, \patest\ArrayType\ArrayOfTransactionMessageBase $validationMessages = null)
    {
        $this
            ->setTransactionSnapshot($transactionSnapshot)
            ->setWarnings($warnings)
            ->setRequiredUserInteraction($requiredUserInteraction)
            ->setIsCommitted($isCommitted)
            ->setValidationMessages($validationMessages);
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\CommitTransaction_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfCodeDescription|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfCodeDescription $warnings
     * @return \patest\StructType\CommitTransaction_Response
     */
    public function setWarnings(\patest\ArrayType\ArrayOfCodeDescription $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get RequiredUserInteraction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\UserInteractionRequiredMessage|null
     */
    public function getRequiredUserInteraction()
    {
        return isset($this->RequiredUserInteraction) ? $this->RequiredUserInteraction : null;
    }
    /**
     * Set RequiredUserInteraction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\UserInteractionRequiredMessage $requiredUserInteraction
     * @return \patest\StructType\CommitTransaction_Response
     */
    public function setRequiredUserInteraction(\patest\StructType\UserInteractionRequiredMessage $requiredUserInteraction = null)
    {
        if (is_null($requiredUserInteraction) || (is_array($requiredUserInteraction) && empty($requiredUserInteraction))) {
            unset($this->RequiredUserInteraction);
        } else {
            $this->RequiredUserInteraction = $requiredUserInteraction;
        }
        return $this;
    }
    /**
     * Get IsCommitted value
     * @return bool|null
     */
    public function getIsCommitted()
    {
        return $this->IsCommitted;
    }
    /**
     * Set IsCommitted value
     * @param bool $isCommitted
     * @return \patest\StructType\CommitTransaction_Response
     */
    public function setIsCommitted($isCommitted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCommitted) && !is_bool($isCommitted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCommitted, true), gettype($isCommitted)), __LINE__);
        }
        $this->IsCommitted = $isCommitted;
        return $this;
    }
    /**
     * Get ValidationMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTransactionMessageBase|null
     */
    public function getValidationMessages()
    {
        return isset($this->ValidationMessages) ? $this->ValidationMessages : null;
    }
    /**
     * Set ValidationMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTransactionMessageBase $validationMessages
     * @return \patest\StructType\CommitTransaction_Response
     */
    public function setValidationMessages(\patest\ArrayType\ArrayOfTransactionMessageBase $validationMessages = null)
    {
        if (is_null($validationMessages) || (is_array($validationMessages) && empty($validationMessages))) {
            unset($this->ValidationMessages);
        } else {
            $this->ValidationMessages = $validationMessages;
        }
        return $this;
    }
}
