<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommitTransaction-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CommitTransaction-Request
 * @subpackage Structs
 */
class CommitTransaction_Request extends ExtensibleDataContract
{
    /**
     * The RetailerTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerTransactionNumber;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The UseSettlementPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseSettlementPayment;
    /**
     * The IsUserInteractionSupported
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsUserInteractionSupported;
    /**
     * The IsGetValidationMessages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGetValidationMessages;
    /**
     * The ExpectNotFullyPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExpectNotFullyPaid;
    /**
     * Constructor method for CommitTransaction-Request
     * @uses CommitTransaction_Request::setRetailerTransactionNumber()
     * @uses CommitTransaction_Request::setTransactionGuid()
     * @uses CommitTransaction_Request::setTransactionSnapshotType()
     * @uses CommitTransaction_Request::setUseSettlementPayment()
     * @uses CommitTransaction_Request::setIsUserInteractionSupported()
     * @uses CommitTransaction_Request::setIsGetValidationMessages()
     * @uses CommitTransaction_Request::setExpectNotFullyPaid()
     * @param int $retailerTransactionNumber
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $useSettlementPayment
     * @param bool $isUserInteractionSupported
     * @param bool $isGetValidationMessages
     * @param bool $expectNotFullyPaid
     */
    public function __construct($retailerTransactionNumber = null, $transactionGuid = null, $transactionSnapshotType = null, $useSettlementPayment = null, $isUserInteractionSupported = null, $isGetValidationMessages = null, $expectNotFullyPaid = null)
    {
        $this
            ->setRetailerTransactionNumber($retailerTransactionNumber)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setUseSettlementPayment($useSettlementPayment)
            ->setIsUserInteractionSupported($isUserInteractionSupported)
            ->setIsGetValidationMessages($isGetValidationMessages)
            ->setExpectNotFullyPaid($expectNotFullyPaid);
    }
    /**
     * Get RetailerTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerTransactionNumber()
    {
        return isset($this->RetailerTransactionNumber) ? $this->RetailerTransactionNumber : null;
    }
    /**
     * Set RetailerTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerTransactionNumber
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setRetailerTransactionNumber($retailerTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($retailerTransactionNumber) && !(is_int($retailerTransactionNumber) || ctype_digit($retailerTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerTransactionNumber, true), gettype($retailerTransactionNumber)), __LINE__);
        }
        if (is_null($retailerTransactionNumber) || (is_array($retailerTransactionNumber) && empty($retailerTransactionNumber))) {
            unset($this->RetailerTransactionNumber);
        } else {
            $this->RetailerTransactionNumber = $retailerTransactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get UseSettlementPayment value
     * @return bool|null
     */
    public function getUseSettlementPayment()
    {
        return $this->UseSettlementPayment;
    }
    /**
     * Set UseSettlementPayment value
     * @param bool $useSettlementPayment
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setUseSettlementPayment($useSettlementPayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($useSettlementPayment) && !is_bool($useSettlementPayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useSettlementPayment, true), gettype($useSettlementPayment)), __LINE__);
        }
        $this->UseSettlementPayment = $useSettlementPayment;
        return $this;
    }
    /**
     * Get IsUserInteractionSupported value
     * @return bool|null
     */
    public function getIsUserInteractionSupported()
    {
        return $this->IsUserInteractionSupported;
    }
    /**
     * Set IsUserInteractionSupported value
     * @param bool $isUserInteractionSupported
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setIsUserInteractionSupported($isUserInteractionSupported = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUserInteractionSupported) && !is_bool($isUserInteractionSupported)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUserInteractionSupported, true), gettype($isUserInteractionSupported)), __LINE__);
        }
        $this->IsUserInteractionSupported = $isUserInteractionSupported;
        return $this;
    }
    /**
     * Get IsGetValidationMessages value
     * @return bool|null
     */
    public function getIsGetValidationMessages()
    {
        return $this->IsGetValidationMessages;
    }
    /**
     * Set IsGetValidationMessages value
     * @param bool $isGetValidationMessages
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setIsGetValidationMessages($isGetValidationMessages = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGetValidationMessages) && !is_bool($isGetValidationMessages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGetValidationMessages, true), gettype($isGetValidationMessages)), __LINE__);
        }
        $this->IsGetValidationMessages = $isGetValidationMessages;
        return $this;
    }
    /**
     * Get ExpectNotFullyPaid value
     * @return bool|null
     */
    public function getExpectNotFullyPaid()
    {
        return $this->ExpectNotFullyPaid;
    }
    /**
     * Set ExpectNotFullyPaid value
     * @param bool $expectNotFullyPaid
     * @return \patest\StructType\CommitTransaction_Request
     */
    public function setExpectNotFullyPaid($expectNotFullyPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($expectNotFullyPaid) && !is_bool($expectNotFullyPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($expectNotFullyPaid, true), gettype($expectNotFullyPaid)), __LINE__);
        }
        $this->ExpectNotFullyPaid = $expectNotFullyPaid;
        return $this;
    }
}
