<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CollectAndPrintTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CollectAndPrintTickets-Request
 * @subpackage Structs
 */
class CollectAndPrintTickets_Request extends ExtensibleDataContract
{
    /**
     * The CollectTicketsForClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectTicketsForClient;
    /**
     * The CollectTicketsForNearEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectTicketsForNearEvents;
    /**
     * The CollectTicketsNearEventsTimeSpan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CollectTicketsNearEventsTimeSpan;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * The TokenType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TokenType;
    /**
     * Constructor method for CollectAndPrintTickets-Request
     * @uses CollectAndPrintTickets_Request::setCollectTicketsForClient()
     * @uses CollectAndPrintTickets_Request::setCollectTicketsForNearEvents()
     * @uses CollectAndPrintTickets_Request::setCollectTicketsNearEventsTimeSpan()
     * @uses CollectAndPrintTickets_Request::setToken()
     * @uses CollectAndPrintTickets_Request::setTokenType()
     * @param string $collectTicketsForClient
     * @param string $collectTicketsForNearEvents
     * @param int $collectTicketsNearEventsTimeSpan
     * @param string $token
     * @param string $tokenType
     */
    public function __construct($collectTicketsForClient = null, $collectTicketsForNearEvents = null, $collectTicketsNearEventsTimeSpan = null, $token = null, $tokenType = null)
    {
        $this
            ->setCollectTicketsForClient($collectTicketsForClient)
            ->setCollectTicketsForNearEvents($collectTicketsForNearEvents)
            ->setCollectTicketsNearEventsTimeSpan($collectTicketsNearEventsTimeSpan)
            ->setToken($token)
            ->setTokenType($tokenType);
    }
    /**
     * Get CollectTicketsForClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectTicketsForClient()
    {
        return isset($this->CollectTicketsForClient) ? $this->CollectTicketsForClient : null;
    }
    /**
     * Set CollectTicketsForClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CollectTicketsForClient::valueIsValid()
     * @uses \patest\EnumType\CollectTicketsForClient::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectTicketsForClient
     * @return \patest\StructType\CollectAndPrintTickets_Request
     */
    public function setCollectTicketsForClient($collectTicketsForClient = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CollectTicketsForClient::valueIsValid($collectTicketsForClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CollectTicketsForClient', is_array($collectTicketsForClient) ? implode(', ', $collectTicketsForClient) : var_export($collectTicketsForClient, true), implode(', ', \patest\EnumType\CollectTicketsForClient::getValidValues())), __LINE__);
        }
        if (is_null($collectTicketsForClient) || (is_array($collectTicketsForClient) && empty($collectTicketsForClient))) {
            unset($this->CollectTicketsForClient);
        } else {
            $this->CollectTicketsForClient = $collectTicketsForClient;
        }
        return $this;
    }
    /**
     * Get CollectTicketsForNearEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectTicketsForNearEvents()
    {
        return isset($this->CollectTicketsForNearEvents) ? $this->CollectTicketsForNearEvents : null;
    }
    /**
     * Set CollectTicketsForNearEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CollectTicketsForNearEvents::valueIsValid()
     * @uses \patest\EnumType\CollectTicketsForNearEvents::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectTicketsForNearEvents
     * @return \patest\StructType\CollectAndPrintTickets_Request
     */
    public function setCollectTicketsForNearEvents($collectTicketsForNearEvents = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CollectTicketsForNearEvents::valueIsValid($collectTicketsForNearEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CollectTicketsForNearEvents', is_array($collectTicketsForNearEvents) ? implode(', ', $collectTicketsForNearEvents) : var_export($collectTicketsForNearEvents, true), implode(', ', \patest\EnumType\CollectTicketsForNearEvents::getValidValues())), __LINE__);
        }
        if (is_null($collectTicketsForNearEvents) || (is_array($collectTicketsForNearEvents) && empty($collectTicketsForNearEvents))) {
            unset($this->CollectTicketsForNearEvents);
        } else {
            $this->CollectTicketsForNearEvents = $collectTicketsForNearEvents;
        }
        return $this;
    }
    /**
     * Get CollectTicketsNearEventsTimeSpan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCollectTicketsNearEventsTimeSpan()
    {
        return isset($this->CollectTicketsNearEventsTimeSpan) ? $this->CollectTicketsNearEventsTimeSpan : null;
    }
    /**
     * Set CollectTicketsNearEventsTimeSpan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $collectTicketsNearEventsTimeSpan
     * @return \patest\StructType\CollectAndPrintTickets_Request
     */
    public function setCollectTicketsNearEventsTimeSpan($collectTicketsNearEventsTimeSpan = null)
    {
        // validation for constraint: int
        if (!is_null($collectTicketsNearEventsTimeSpan) && !(is_int($collectTicketsNearEventsTimeSpan) || ctype_digit($collectTicketsNearEventsTimeSpan))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectTicketsNearEventsTimeSpan, true), gettype($collectTicketsNearEventsTimeSpan)), __LINE__);
        }
        if (is_null($collectTicketsNearEventsTimeSpan) || (is_array($collectTicketsNearEventsTimeSpan) && empty($collectTicketsNearEventsTimeSpan))) {
            unset($this->CollectTicketsNearEventsTimeSpan);
        } else {
            $this->CollectTicketsNearEventsTimeSpan = $collectTicketsNearEventsTimeSpan;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \patest\StructType\CollectAndPrintTickets_Request
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
    /**
     * Get TokenType value
     * @return string|null
     */
    public function getTokenType()
    {
        return $this->TokenType;
    }
    /**
     * Set TokenType value
     * @uses \patest\EnumType\CollectAndPrintTicketsTokenType::valueIsValid()
     * @uses \patest\EnumType\CollectAndPrintTicketsTokenType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tokenType
     * @return \patest\StructType\CollectAndPrintTickets_Request
     */
    public function setTokenType($tokenType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CollectAndPrintTicketsTokenType::valueIsValid($tokenType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CollectAndPrintTicketsTokenType', is_array($tokenType) ? implode(', ', $tokenType) : var_export($tokenType, true), implode(', ', \patest\EnumType\CollectAndPrintTicketsTokenType::getValidValues())), __LINE__);
        }
        $this->TokenType = $tokenType;
        return $this;
    }
}
