<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CloseScanningSessionRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CloseScanningSessionRequest
 * @subpackage Structs
 */
class CloseScanningSessionRequest extends ExtensibleDataContract
{
    /**
     * The ScanningSession
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningSession;
    /**
     * Constructor method for CloseScanningSessionRequest
     * @uses CloseScanningSessionRequest::setScanningSession()
     * @param string $scanningSession
     */
    public function __construct($scanningSession = null)
    {
        $this
            ->setScanningSession($scanningSession);
    }
    /**
     * Get ScanningSession value
     * @return string|null
     */
    public function getScanningSession()
    {
        return $this->ScanningSession;
    }
    /**
     * Set ScanningSession value
     * @param string $scanningSession
     * @return \patest\StructType\CloseScanningSessionRequest
     */
    public function setScanningSession($scanningSession = null)
    {
        // validation for constraint: string
        if (!is_null($scanningSession) && !is_string($scanningSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningSession, true), gettype($scanningSession)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningSession) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningSession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningSession, true)), __LINE__);
        }
        $this->ScanningSession = $scanningSession;
        return $this;
    }
}
