<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientEventInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientEventInfo
 * @subpackage Structs
 */
class ClientEventInfo extends AbstractStructBase
{
    /**
     * The AllDayEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllDayEvent;
    /**
     * The AssociatedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDate;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFormatOptions;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventDateUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateUtc;
    /**
     * The EventDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDetails;
    /**
     * The FormattedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedDate;
    /**
     * The Genres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGenreDescription
     */
    public $Genres;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HallName;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Image1Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image1Url;
    /**
     * The Image2Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image2Url;
    /**
     * The Image3Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Image3Url;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The NameAndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameAndDate;
    /**
     * The NumberOfTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfTickets;
    /**
     * The OnlineDateFormatAdditionalText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDateFormatAdditionalText;
    /**
     * The OnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineHeroImageUrl;
    /**
     * The OnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineThumbnailImageUrl;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ShowMinutes;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VenueName;
    /**
     * Constructor method for ClientEventInfo
     * @uses ClientEventInfo::setAllDayEvent()
     * @uses ClientEventInfo::setAssociatedDate()
     * @uses ClientEventInfo::setDateFormatOptions()
     * @uses ClientEventInfo::setEventDate()
     * @uses ClientEventInfo::setEventDateUtc()
     * @uses ClientEventInfo::setEventDetails()
     * @uses ClientEventInfo::setFormattedDate()
     * @uses ClientEventInfo::setGenres()
     * @uses ClientEventInfo::setHallName()
     * @uses ClientEventInfo::setId()
     * @uses ClientEventInfo::setImage1Url()
     * @uses ClientEventInfo::setImage2Url()
     * @uses ClientEventInfo::setImage3Url()
     * @uses ClientEventInfo::setLocalId()
     * @uses ClientEventInfo::setName()
     * @uses ClientEventInfo::setNameAndDate()
     * @uses ClientEventInfo::setNumberOfTickets()
     * @uses ClientEventInfo::setOnlineDateFormatAdditionalText()
     * @uses ClientEventInfo::setOnlineHeroImageUrl()
     * @uses ClientEventInfo::setOnlineThumbnailImageUrl()
     * @uses ClientEventInfo::setShowMinutes()
     * @uses ClientEventInfo::setVenueName()
     * @param bool $allDayEvent
     * @param string $associatedDate
     * @param string $dateFormatOptions
     * @param string $eventDate
     * @param string $eventDateUtc
     * @param string $eventDetails
     * @param string $formattedDate
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @param string $hallName
     * @param string $id
     * @param string $image1Url
     * @param string $image2Url
     * @param string $image3Url
     * @param int $localId
     * @param string $name
     * @param string $nameAndDate
     * @param int $numberOfTickets
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @param string $onlineHeroImageUrl
     * @param string $onlineThumbnailImageUrl
     * @param int $showMinutes
     * @param string $venueName
     */
    public function __construct($allDayEvent = null, $associatedDate = null, $dateFormatOptions = null, $eventDate = null, $eventDateUtc = null, $eventDetails = null, $formattedDate = null, \patest\ArrayType\ArrayOfGenreDescription $genres = null, $hallName = null, $id = null, $image1Url = null, $image2Url = null, $image3Url = null, $localId = null, $name = null, $nameAndDate = null, $numberOfTickets = null, \patest\StructType\GlobalString $onlineDateFormatAdditionalText = null, $onlineHeroImageUrl = null, $onlineThumbnailImageUrl = null, $showMinutes = null, $venueName = null)
    {
        $this
            ->setAllDayEvent($allDayEvent)
            ->setAssociatedDate($associatedDate)
            ->setDateFormatOptions($dateFormatOptions)
            ->setEventDate($eventDate)
            ->setEventDateUtc($eventDateUtc)
            ->setEventDetails($eventDetails)
            ->setFormattedDate($formattedDate)
            ->setGenres($genres)
            ->setHallName($hallName)
            ->setId($id)
            ->setImage1Url($image1Url)
            ->setImage2Url($image2Url)
            ->setImage3Url($image3Url)
            ->setLocalId($localId)
            ->setName($name)
            ->setNameAndDate($nameAndDate)
            ->setNumberOfTickets($numberOfTickets)
            ->setOnlineDateFormatAdditionalText($onlineDateFormatAdditionalText)
            ->setOnlineHeroImageUrl($onlineHeroImageUrl)
            ->setOnlineThumbnailImageUrl($onlineThumbnailImageUrl)
            ->setShowMinutes($showMinutes)
            ->setVenueName($venueName);
    }
    /**
     * Get AllDayEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return isset($this->AllDayEvent) ? $this->AllDayEvent : null;
    }
    /**
     * Set AllDayEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allDayEvent
     * @return \patest\StructType\ClientEventInfo
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allDayEvent, true), gettype($allDayEvent)), __LINE__);
        }
        if (is_null($allDayEvent) || (is_array($allDayEvent) && empty($allDayEvent))) {
            unset($this->AllDayEvent);
        } else {
            $this->AllDayEvent = $allDayEvent;
        }
        return $this;
    }
    /**
     * Get AssociatedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDate()
    {
        return isset($this->AssociatedDate) ? $this->AssociatedDate : null;
    }
    /**
     * Set AssociatedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDate
     * @return \patest\StructType\ClientEventInfo
     */
    public function setAssociatedDate($associatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDate) && !is_string($associatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDate, true), gettype($associatedDate)), __LINE__);
        }
        if (is_null($associatedDate) || (is_array($associatedDate) && empty($associatedDate))) {
            unset($this->AssociatedDate);
        } else {
            $this->AssociatedDate = $associatedDate;
        }
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return isset($this->DateFormatOptions) ? $this->DateFormatOptions : null;
    }
    /**
     * Set DateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\ClientEventInfo
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        if (is_null($dateFormatOptions) || (is_array($dateFormatOptions) && empty($dateFormatOptions))) {
            unset($this->DateFormatOptions);
        } else {
            $this->DateFormatOptions = $dateFormatOptions;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\ClientEventInfo
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateUtc()
    {
        return isset($this->EventDateUtc) ? $this->EventDateUtc : null;
    }
    /**
     * Set EventDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateUtc
     * @return \patest\StructType\ClientEventInfo
     */
    public function setEventDateUtc($eventDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateUtc) && !is_string($eventDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateUtc, true), gettype($eventDateUtc)), __LINE__);
        }
        if (is_null($eventDateUtc) || (is_array($eventDateUtc) && empty($eventDateUtc))) {
            unset($this->EventDateUtc);
        } else {
            $this->EventDateUtc = $eventDateUtc;
        }
        return $this;
    }
    /**
     * Get EventDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDetails()
    {
        return isset($this->EventDetails) ? $this->EventDetails : null;
    }
    /**
     * Set EventDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDetails
     * @return \patest\StructType\ClientEventInfo
     */
    public function setEventDetails($eventDetails = null)
    {
        // validation for constraint: string
        if (!is_null($eventDetails) && !is_string($eventDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDetails, true), gettype($eventDetails)), __LINE__);
        }
        if (is_null($eventDetails) || (is_array($eventDetails) && empty($eventDetails))) {
            unset($this->EventDetails);
        } else {
            $this->EventDetails = $eventDetails;
        }
        return $this;
    }
    /**
     * Get FormattedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedDate()
    {
        return isset($this->FormattedDate) ? $this->FormattedDate : null;
    }
    /**
     * Set FormattedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedDate
     * @return \patest\StructType\ClientEventInfo
     */
    public function setFormattedDate($formattedDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedDate) && !is_string($formattedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedDate, true), gettype($formattedDate)), __LINE__);
        }
        if (is_null($formattedDate) || (is_array($formattedDate) && empty($formattedDate))) {
            unset($this->FormattedDate);
        } else {
            $this->FormattedDate = $formattedDate;
        }
        return $this;
    }
    /**
     * Get Genres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGenreDescription|null
     */
    public function getGenres()
    {
        return isset($this->Genres) ? $this->Genres : null;
    }
    /**
     * Set Genres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGenreDescription $genres
     * @return \patest\StructType\ClientEventInfo
     */
    public function setGenres(\patest\ArrayType\ArrayOfGenreDescription $genres = null)
    {
        if (is_null($genres) || (is_array($genres) && empty($genres))) {
            unset($this->Genres);
        } else {
            $this->Genres = $genres;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallName
     * @return \patest\StructType\ClientEventInfo
     */
    public function setHallName($hallName = null)
    {
        // validation for constraint: string
        if (!is_null($hallName) && !is_string($hallName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallName, true), gettype($hallName)), __LINE__);
        }
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\ClientEventInfo
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Image1Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage1Url()
    {
        return isset($this->Image1Url) ? $this->Image1Url : null;
    }
    /**
     * Set Image1Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image1Url
     * @return \patest\StructType\ClientEventInfo
     */
    public function setImage1Url($image1Url = null)
    {
        // validation for constraint: string
        if (!is_null($image1Url) && !is_string($image1Url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image1Url, true), gettype($image1Url)), __LINE__);
        }
        if (is_null($image1Url) || (is_array($image1Url) && empty($image1Url))) {
            unset($this->Image1Url);
        } else {
            $this->Image1Url = $image1Url;
        }
        return $this;
    }
    /**
     * Get Image2Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage2Url()
    {
        return isset($this->Image2Url) ? $this->Image2Url : null;
    }
    /**
     * Set Image2Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image2Url
     * @return \patest\StructType\ClientEventInfo
     */
    public function setImage2Url($image2Url = null)
    {
        // validation for constraint: string
        if (!is_null($image2Url) && !is_string($image2Url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image2Url, true), gettype($image2Url)), __LINE__);
        }
        if (is_null($image2Url) || (is_array($image2Url) && empty($image2Url))) {
            unset($this->Image2Url);
        } else {
            $this->Image2Url = $image2Url;
        }
        return $this;
    }
    /**
     * Get Image3Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImage3Url()
    {
        return isset($this->Image3Url) ? $this->Image3Url : null;
    }
    /**
     * Set Image3Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $image3Url
     * @return \patest\StructType\ClientEventInfo
     */
    public function setImage3Url($image3Url = null)
    {
        // validation for constraint: string
        if (!is_null($image3Url) && !is_string($image3Url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($image3Url, true), gettype($image3Url)), __LINE__);
        }
        if (is_null($image3Url) || (is_array($image3Url) && empty($image3Url))) {
            unset($this->Image3Url);
        } else {
            $this->Image3Url = $image3Url;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\ClientEventInfo
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ClientEventInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameAndDate()
    {
        return isset($this->NameAndDate) ? $this->NameAndDate : null;
    }
    /**
     * Set NameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameAndDate
     * @return \patest\StructType\ClientEventInfo
     */
    public function setNameAndDate($nameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($nameAndDate) && !is_string($nameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameAndDate, true), gettype($nameAndDate)), __LINE__);
        }
        if (is_null($nameAndDate) || (is_array($nameAndDate) && empty($nameAndDate))) {
            unset($this->NameAndDate);
        } else {
            $this->NameAndDate = $nameAndDate;
        }
        return $this;
    }
    /**
     * Get NumberOfTickets value
     * @return int|null
     */
    public function getNumberOfTickets()
    {
        return $this->NumberOfTickets;
    }
    /**
     * Set NumberOfTickets value
     * @param int $numberOfTickets
     * @return \patest\StructType\ClientEventInfo
     */
    public function setNumberOfTickets($numberOfTickets = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfTickets) && !(is_int($numberOfTickets) || ctype_digit($numberOfTickets))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfTickets, true), gettype($numberOfTickets)), __LINE__);
        }
        $this->NumberOfTickets = $numberOfTickets;
        return $this;
    }
    /**
     * Get OnlineDateFormatAdditionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDateFormatAdditionalText()
    {
        return isset($this->OnlineDateFormatAdditionalText) ? $this->OnlineDateFormatAdditionalText : null;
    }
    /**
     * Set OnlineDateFormatAdditionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @return \patest\StructType\ClientEventInfo
     */
    public function setOnlineDateFormatAdditionalText(\patest\StructType\GlobalString $onlineDateFormatAdditionalText = null)
    {
        if (is_null($onlineDateFormatAdditionalText) || (is_array($onlineDateFormatAdditionalText) && empty($onlineDateFormatAdditionalText))) {
            unset($this->OnlineDateFormatAdditionalText);
        } else {
            $this->OnlineDateFormatAdditionalText = $onlineDateFormatAdditionalText;
        }
        return $this;
    }
    /**
     * Get OnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineHeroImageUrl()
    {
        return isset($this->OnlineHeroImageUrl) ? $this->OnlineHeroImageUrl : null;
    }
    /**
     * Set OnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineHeroImageUrl
     * @return \patest\StructType\ClientEventInfo
     */
    public function setOnlineHeroImageUrl($onlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineHeroImageUrl) && !is_string($onlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineHeroImageUrl, true), gettype($onlineHeroImageUrl)), __LINE__);
        }
        if (is_null($onlineHeroImageUrl) || (is_array($onlineHeroImageUrl) && empty($onlineHeroImageUrl))) {
            unset($this->OnlineHeroImageUrl);
        } else {
            $this->OnlineHeroImageUrl = $onlineHeroImageUrl;
        }
        return $this;
    }
    /**
     * Get OnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineThumbnailImageUrl()
    {
        return isset($this->OnlineThumbnailImageUrl) ? $this->OnlineThumbnailImageUrl : null;
    }
    /**
     * Set OnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineThumbnailImageUrl
     * @return \patest\StructType\ClientEventInfo
     */
    public function setOnlineThumbnailImageUrl($onlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($onlineThumbnailImageUrl) && !is_string($onlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineThumbnailImageUrl, true), gettype($onlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($onlineThumbnailImageUrl) || (is_array($onlineThumbnailImageUrl) && empty($onlineThumbnailImageUrl))) {
            unset($this->OnlineThumbnailImageUrl);
        } else {
            $this->OnlineThumbnailImageUrl = $onlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * @return int|null
     */
    public function getShowMinutes()
    {
        return $this->ShowMinutes;
    }
    /**
     * Set ShowMinutes value
     * @param int $showMinutes
     * @return \patest\StructType\ClientEventInfo
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        $this->ShowMinutes = $showMinutes;
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $venueName
     * @return \patest\StructType\ClientEventInfo
     */
    public function setVenueName($venueName = null)
    {
        // validation for constraint: string
        if (!is_null($venueName) && !is_string($venueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($venueName, true), gettype($venueName)), __LINE__);
        }
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
}
