<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientCreditItemData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientCreditItemData
 * @subpackage Structs
 */
class ClientCreditItemData extends AbstractStructBase
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The CreditType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CreditType;
    /**
     * The DepositTargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepositTargetType;
    /**
     * Constructor method for ClientCreditItemData
     * @uses ClientCreditItemData::setAmount()
     * @uses ClientCreditItemData::setCreditType()
     * @uses ClientCreditItemData::setDepositTargetType()
     * @param \patest\StructType\Money $amount
     * @param int $creditType
     * @param string $depositTargetType
     */
    public function __construct(\patest\StructType\Money $amount = null, $creditType = null, $depositTargetType = null)
    {
        $this
            ->setAmount($amount)
            ->setCreditType($creditType)
            ->setDepositTargetType($depositTargetType);
    }
    /**
     * Get Amount value
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\ClientCreditItemData
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CreditType value
     * @return int|null
     */
    public function getCreditType()
    {
        return $this->CreditType;
    }
    /**
     * Set CreditType value
     * @param int $creditType
     * @return \patest\StructType\ClientCreditItemData
     */
    public function setCreditType($creditType = null)
    {
        // validation for constraint: int
        if (!is_null($creditType) && !(is_int($creditType) || ctype_digit($creditType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creditType, true), gettype($creditType)), __LINE__);
        }
        $this->CreditType = $creditType;
        return $this;
    }
    /**
     * Get DepositTargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositTargetType()
    {
        return isset($this->DepositTargetType) ? $this->DepositTargetType : null;
    }
    /**
     * Set DepositTargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DepositTargetType::valueIsValid()
     * @uses \patest\EnumType\DepositTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $depositTargetType
     * @return \patest\StructType\ClientCreditItemData
     */
    public function setDepositTargetType($depositTargetType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DepositTargetType::valueIsValid($depositTargetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DepositTargetType', is_array($depositTargetType) ? implode(', ', $depositTargetType) : var_export($depositTargetType, true), implode(', ', \patest\EnumType\DepositTargetType::getValidValues())), __LINE__);
        }
        if (is_null($depositTargetType) || (is_array($depositTargetType) && empty($depositTargetType))) {
            unset($this->DepositTargetType);
        } else {
            $this->DepositTargetType = $depositTargetType;
        }
        return $this;
    }
}
