<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClientCreditItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClientCreditItem
 * @subpackage Structs
 */
class ClientCreditItem extends AbstractProductItem
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The TargetId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetId;
    /**
     * The TargetType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetType;
    /**
     * The OriginalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $OriginalAmount;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * The DebtDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DebtDetails
     */
    public $DebtDetails;
    /**
     * Constructor method for ClientCreditItem
     * @uses ClientCreditItem::setCategoryId()
     * @uses ClientCreditItem::setClientAmount()
     * @uses ClientCreditItem::setTargetId()
     * @uses ClientCreditItem::setTargetType()
     * @uses ClientCreditItem::setOriginalAmount()
     * @uses ClientCreditItem::setRemainingAmount()
     * @uses ClientCreditItem::setDebtDetails()
     * @param string $categoryId
     * @param \patest\StructType\Money $clientAmount
     * @param string $targetId
     * @param string $targetType
     * @param \patest\StructType\Money $originalAmount
     * @param \patest\StructType\Money $remainingAmount
     * @param \patest\StructType\DebtDetails $debtDetails
     */
    public function __construct($categoryId = null, \patest\StructType\Money $clientAmount = null, $targetId = null, $targetType = null, \patest\StructType\Money $originalAmount = null, \patest\StructType\Money $remainingAmount = null, \patest\StructType\DebtDetails $debtDetails = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setClientAmount($clientAmount)
            ->setTargetId($targetId)
            ->setTargetType($targetType)
            ->setOriginalAmount($originalAmount)
            ->setRemainingAmount($remainingAmount)
            ->setDebtDetails($debtDetails);
    }
    /**
     * Get CategoryId value
     * @return string|null
     */
    public function getCategoryId()
    {
        return $this->CategoryId;
    }
    /**
     * Set CategoryId value
     * @param string $categoryId
     * @return \patest\StructType\ClientCreditItem
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        $this->CategoryId = $categoryId;
        return $this;
    }
    /**
     * Get ClientAmount value
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return $this->ClientAmount;
    }
    /**
     * Set ClientAmount value
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\ClientCreditItem
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        $this->ClientAmount = $clientAmount;
        return $this;
    }
    /**
     * Get TargetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetId()
    {
        return isset($this->TargetId) ? $this->TargetId : null;
    }
    /**
     * Set TargetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetId
     * @return \patest\StructType\ClientCreditItem
     */
    public function setTargetId($targetId = null)
    {
        // validation for constraint: string
        if (!is_null($targetId) && !is_string($targetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetId, true), gettype($targetId)), __LINE__);
        }
        if (is_null($targetId) || (is_array($targetId) && empty($targetId))) {
            unset($this->TargetId);
        } else {
            $this->TargetId = $targetId;
        }
        return $this;
    }
    /**
     * Get TargetType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetType()
    {
        return isset($this->TargetType) ? $this->TargetType : null;
    }
    /**
     * Set TargetType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DepositTargetType::valueIsValid()
     * @uses \patest\EnumType\DepositTargetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetType
     * @return \patest\StructType\ClientCreditItem
     */
    public function setTargetType($targetType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DepositTargetType::valueIsValid($targetType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DepositTargetType', is_array($targetType) ? implode(', ', $targetType) : var_export($targetType, true), implode(', ', \patest\EnumType\DepositTargetType::getValidValues())), __LINE__);
        }
        if (is_null($targetType) || (is_array($targetType) && empty($targetType))) {
            unset($this->TargetType);
        } else {
            $this->TargetType = $targetType;
        }
        return $this;
    }
    /**
     * Get OriginalAmount value
     * @return \patest\StructType\Money|null
     */
    public function getOriginalAmount()
    {
        return $this->OriginalAmount;
    }
    /**
     * Set OriginalAmount value
     * @param \patest\StructType\Money $originalAmount
     * @return \patest\StructType\ClientCreditItem
     */
    public function setOriginalAmount(\patest\StructType\Money $originalAmount = null)
    {
        $this->OriginalAmount = $originalAmount;
        return $this;
    }
    /**
     * Get RemainingAmount value
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }
    /**
     * Set RemainingAmount value
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\ClientCreditItem
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        $this->RemainingAmount = $remainingAmount;
        return $this;
    }
    /**
     * Get DebtDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DebtDetails|null
     */
    public function getDebtDetails()
    {
        return isset($this->DebtDetails) ? $this->DebtDetails : null;
    }
    /**
     * Set DebtDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DebtDetails $debtDetails
     * @return \patest\StructType\ClientCreditItem
     */
    public function setDebtDetails(\patest\StructType\DebtDetails $debtDetails = null)
    {
        if (is_null($debtDetails) || (is_array($debtDetails) && empty($debtDetails))) {
            unset($this->DebtDetails);
        } else {
            $this->DebtDetails = $debtDetails;
        }
        return $this;
    }
}
