<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeTicketOwnerRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeTicketOwnerRequest
 * @subpackage Structs
 */
class ChangeTicketOwnerRequest extends AbstractStructBase
{
    /**
     * The AllowDowngrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowDowngrade;
    /**
     * The ChangeSubsTicketAppliedPriceList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ChangeSubsTicketAppliedPriceListType
     */
    public $ChangeSubsTicketAppliedPriceList;
    /**
     * The ItemIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ServiceSpecificItemIdentity
     */
    public $ItemIdentity;
    /**
     * The NewOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwnerId;
    /**
     * The NewPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewPriceType;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for ChangeTicketOwnerRequest
     * @uses ChangeTicketOwnerRequest::setAllowDowngrade()
     * @uses ChangeTicketOwnerRequest::setChangeSubsTicketAppliedPriceList()
     * @uses ChangeTicketOwnerRequest::setItemIdentity()
     * @uses ChangeTicketOwnerRequest::setNewOwnerId()
     * @uses ChangeTicketOwnerRequest::setNewPriceType()
     * @uses ChangeTicketOwnerRequest::setTransactionId()
     * @uses ChangeTicketOwnerRequest::setTransactionSnapshotType()
     * @param bool $allowDowngrade
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @param \patest\StructType\ServiceSpecificItemIdentity $itemIdentity
     * @param string $newOwnerId
     * @param string $newPriceType
     * @param string $transactionId
     * @param string $transactionSnapshotType
     */
    public function __construct($allowDowngrade = null, \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null, \patest\StructType\ServiceSpecificItemIdentity $itemIdentity = null, $newOwnerId = null, $newPriceType = null, $transactionId = null, $transactionSnapshotType = null)
    {
        $this
            ->setAllowDowngrade($allowDowngrade)
            ->setChangeSubsTicketAppliedPriceList($changeSubsTicketAppliedPriceList)
            ->setItemIdentity($itemIdentity)
            ->setNewOwnerId($newOwnerId)
            ->setNewPriceType($newPriceType)
            ->setTransactionId($transactionId)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get AllowDowngrade value
     * @return bool|null
     */
    public function getAllowDowngrade()
    {
        return $this->AllowDowngrade;
    }
    /**
     * Set AllowDowngrade value
     * @param bool $allowDowngrade
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setAllowDowngrade($allowDowngrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowDowngrade) && !is_bool($allowDowngrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowDowngrade, true), gettype($allowDowngrade)), __LINE__);
        }
        $this->AllowDowngrade = $allowDowngrade;
        return $this;
    }
    /**
     * Get ChangeSubsTicketAppliedPriceList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ChangeSubsTicketAppliedPriceListType|null
     */
    public function getChangeSubsTicketAppliedPriceList()
    {
        return isset($this->ChangeSubsTicketAppliedPriceList) ? $this->ChangeSubsTicketAppliedPriceList : null;
    }
    /**
     * Set ChangeSubsTicketAppliedPriceList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setChangeSubsTicketAppliedPriceList(\patest\StructType\ChangeSubsTicketAppliedPriceListType $changeSubsTicketAppliedPriceList = null)
    {
        if (is_null($changeSubsTicketAppliedPriceList) || (is_array($changeSubsTicketAppliedPriceList) && empty($changeSubsTicketAppliedPriceList))) {
            unset($this->ChangeSubsTicketAppliedPriceList);
        } else {
            $this->ChangeSubsTicketAppliedPriceList = $changeSubsTicketAppliedPriceList;
        }
        return $this;
    }
    /**
     * Get ItemIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ServiceSpecificItemIdentity|null
     */
    public function getItemIdentity()
    {
        return isset($this->ItemIdentity) ? $this->ItemIdentity : null;
    }
    /**
     * Set ItemIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ServiceSpecificItemIdentity $itemIdentity
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setItemIdentity(\patest\StructType\ServiceSpecificItemIdentity $itemIdentity = null)
    {
        if (is_null($itemIdentity) || (is_array($itemIdentity) && empty($itemIdentity))) {
            unset($this->ItemIdentity);
        } else {
            $this->ItemIdentity = $itemIdentity;
        }
        return $this;
    }
    /**
     * Get NewOwnerId value
     * @return string|null
     */
    public function getNewOwnerId()
    {
        return $this->NewOwnerId;
    }
    /**
     * Set NewOwnerId value
     * @param string $newOwnerId
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setNewOwnerId($newOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($newOwnerId) && !is_string($newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwnerId, true), gettype($newOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwnerId, true)), __LINE__);
        }
        $this->NewOwnerId = $newOwnerId;
        return $this;
    }
    /**
     * Get NewPriceType value
     * @return string|null
     */
    public function getNewPriceType()
    {
        return $this->NewPriceType;
    }
    /**
     * Set NewPriceType value
     * @param string $newPriceType
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setNewPriceType($newPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($newPriceType) && !is_string($newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newPriceType, true), gettype($newPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newPriceType, true)), __LINE__);
        }
        $this->NewPriceType = $newPriceType;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\ChangeTicketOwnerRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
