<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ChangeOfOwnershipRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChangeOfOwnershipRequest
 * @subpackage Structs
 */
class ChangeOfOwnershipRequest extends AbstractStructBase
{
    /**
     * The TicketsToTransfer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l
     */
    public $TicketsToTransfer;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * Constructor method for ChangeOfOwnershipRequest
     * @uses ChangeOfOwnershipRequest::setTicketsToTransfer()
     * @uses ChangeOfOwnershipRequest::setTransactionId()
     * @uses ChangeOfOwnershipRequest::setTransactionSnapshotType()
     * @param \patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l $ticketsToTransfer
     * @param string $transactionId
     * @param string $transactionSnapshotType
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l $ticketsToTransfer = null, $transactionId = null, $transactionSnapshotType = null)
    {
        $this
            ->setTicketsToTransfer($ticketsToTransfer)
            ->setTransactionId($transactionId)
            ->setTransactionSnapshotType($transactionSnapshotType);
    }
    /**
     * Get TicketsToTransfer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l|null
     */
    public function getTicketsToTransfer()
    {
        return isset($this->TicketsToTransfer) ? $this->TicketsToTransfer : null;
    }
    /**
     * Set TicketsToTransfer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l $ticketsToTransfer
     * @return \patest\StructType\ChangeOfOwnershipRequest
     */
    public function setTicketsToTransfer(\patest\ArrayType\ArrayOfKeyValueOfServiceSpecificItemIdentityTicketOwnershipChangeDetailsn51wGZ5l $ticketsToTransfer = null)
    {
        if (is_null($ticketsToTransfer) || (is_array($ticketsToTransfer) && empty($ticketsToTransfer))) {
            unset($this->TicketsToTransfer);
        } else {
            $this->TicketsToTransfer = $ticketsToTransfer;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\ChangeOfOwnershipRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\ChangeOfOwnershipRequest
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
}
