<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CatchSeatRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CatchSeatRequest
 * @subpackage Structs
 */
class CatchSeatRequest extends AbstractStructBase
{
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The PriceLevelGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelGuid;
    /**
     * The PriceTypeGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeGuid;
    /**
     * The ReservationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReservationMode;
    /**
     * The SeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatCount;
    /**
     * The SeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $SeatIds;
    /**
     * The LockIdToUSe
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LockIdToUSe;
    /**
     * The AllowSnakePath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowSnakePath;
    /**
     * The AdvancedCatchInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAdvancedTicketCatchInfo
     */
    public $AdvancedCatchInfo;
    /**
     * The DisallowNonContiguous
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisallowNonContiguous;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The RequestPartId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestPartId;
    /**
     * The MinSeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinSeatCount;
    /**
     * The SkipGaAreas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipGaAreas;
    /**
     * The TreatAsSeparateClientSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $TreatAsSeparateClientSeats;
    /**
     * Constructor method for CatchSeatRequest
     * @uses CatchSeatRequest::setAreaGuid()
     * @uses CatchSeatRequest::setPriceLevelGuid()
     * @uses CatchSeatRequest::setPriceTypeGuid()
     * @uses CatchSeatRequest::setReservationMode()
     * @uses CatchSeatRequest::setSeatCount()
     * @uses CatchSeatRequest::setSeatIds()
     * @uses CatchSeatRequest::setLockIdToUSe()
     * @uses CatchSeatRequest::setAllowSnakePath()
     * @uses CatchSeatRequest::setAdvancedCatchInfo()
     * @uses CatchSeatRequest::setDisallowNonContiguous()
     * @uses CatchSeatRequest::setIsComplimentary()
     * @uses CatchSeatRequest::setRequestPartId()
     * @uses CatchSeatRequest::setMinSeatCount()
     * @uses CatchSeatRequest::setSkipGaAreas()
     * @uses CatchSeatRequest::setTreatAsSeparateClientSeats()
     * @param string $areaGuid
     * @param string $priceLevelGuid
     * @param string $priceTypeGuid
     * @param string $reservationMode
     * @param int $seatCount
     * @param \patest\ArrayType\ArrayOfint $seatIds
     * @param string $lockIdToUSe
     * @param bool $allowSnakePath
     * @param \patest\ArrayType\ArrayOfAdvancedTicketCatchInfo $advancedCatchInfo
     * @param bool $disallowNonContiguous
     * @param bool $isComplimentary
     * @param string $requestPartId
     * @param int $minSeatCount
     * @param bool $skipGaAreas
     * @param bool $treatAsSeparateClientSeats
     */
    public function __construct($areaGuid = null, $priceLevelGuid = null, $priceTypeGuid = null, $reservationMode = null, $seatCount = null, \patest\ArrayType\ArrayOfint $seatIds = null, $lockIdToUSe = null, $allowSnakePath = null, \patest\ArrayType\ArrayOfAdvancedTicketCatchInfo $advancedCatchInfo = null, $disallowNonContiguous = null, $isComplimentary = null, $requestPartId = null, $minSeatCount = null, $skipGaAreas = null, $treatAsSeparateClientSeats = null)
    {
        $this
            ->setAreaGuid($areaGuid)
            ->setPriceLevelGuid($priceLevelGuid)
            ->setPriceTypeGuid($priceTypeGuid)
            ->setReservationMode($reservationMode)
            ->setSeatCount($seatCount)
            ->setSeatIds($seatIds)
            ->setLockIdToUSe($lockIdToUSe)
            ->setAllowSnakePath($allowSnakePath)
            ->setAdvancedCatchInfo($advancedCatchInfo)
            ->setDisallowNonContiguous($disallowNonContiguous)
            ->setIsComplimentary($isComplimentary)
            ->setRequestPartId($requestPartId)
            ->setMinSeatCount($minSeatCount)
            ->setSkipGaAreas($skipGaAreas)
            ->setTreatAsSeparateClientSeats($treatAsSeparateClientSeats);
    }
    /**
     * Get AreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaGuid()
    {
        return isset($this->AreaGuid) ? $this->AreaGuid : null;
    }
    /**
     * Set AreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaGuid
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        if (is_null($areaGuid) || (is_array($areaGuid) && empty($areaGuid))) {
            unset($this->AreaGuid);
        } else {
            $this->AreaGuid = $areaGuid;
        }
        return $this;
    }
    /**
     * Get PriceLevelGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelGuid()
    {
        return isset($this->PriceLevelGuid) ? $this->PriceLevelGuid : null;
    }
    /**
     * Set PriceLevelGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelGuid
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setPriceLevelGuid($priceLevelGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelGuid) && !is_string($priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelGuid, true), gettype($priceLevelGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelGuid, true)), __LINE__);
        }
        if (is_null($priceLevelGuid) || (is_array($priceLevelGuid) && empty($priceLevelGuid))) {
            unset($this->PriceLevelGuid);
        } else {
            $this->PriceLevelGuid = $priceLevelGuid;
        }
        return $this;
    }
    /**
     * Get PriceTypeGuid value
     * @return string|null
     */
    public function getPriceTypeGuid()
    {
        return $this->PriceTypeGuid;
    }
    /**
     * Set PriceTypeGuid value
     * @param string $priceTypeGuid
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setPriceTypeGuid($priceTypeGuid = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeGuid) && !is_string($priceTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeGuid, true), gettype($priceTypeGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeGuid, true)), __LINE__);
        }
        $this->PriceTypeGuid = $priceTypeGuid;
        return $this;
    }
    /**
     * Get ReservationMode value
     * @return string|null
     */
    public function getReservationMode()
    {
        return $this->ReservationMode;
    }
    /**
     * Set ReservationMode value
     * @uses \patest\EnumType\SeatReservationMode::valueIsValid()
     * @uses \patest\EnumType\SeatReservationMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reservationMode
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setReservationMode($reservationMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatReservationMode::valueIsValid($reservationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatReservationMode', is_array($reservationMode) ? implode(', ', $reservationMode) : var_export($reservationMode, true), implode(', ', \patest\EnumType\SeatReservationMode::getValidValues())), __LINE__);
        }
        $this->ReservationMode = $reservationMode;
        return $this;
    }
    /**
     * Get SeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatCount()
    {
        return isset($this->SeatCount) ? $this->SeatCount : null;
    }
    /**
     * Set SeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatCount
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setSeatCount($seatCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatCount) && !(is_int($seatCount) || ctype_digit($seatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCount, true), gettype($seatCount)), __LINE__);
        }
        if (is_null($seatCount) || (is_array($seatCount) && empty($seatCount))) {
            unset($this->SeatCount);
        } else {
            $this->SeatCount = $seatCount;
        }
        return $this;
    }
    /**
     * Get SeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getSeatIds()
    {
        return isset($this->SeatIds) ? $this->SeatIds : null;
    }
    /**
     * Set SeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $seatIds
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setSeatIds(\patest\ArrayType\ArrayOfint $seatIds = null)
    {
        if (is_null($seatIds) || (is_array($seatIds) && empty($seatIds))) {
            unset($this->SeatIds);
        } else {
            $this->SeatIds = $seatIds;
        }
        return $this;
    }
    /**
     * Get LockIdToUSe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLockIdToUSe()
    {
        return isset($this->LockIdToUSe) ? $this->LockIdToUSe : null;
    }
    /**
     * Set LockIdToUSe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lockIdToUSe
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setLockIdToUSe($lockIdToUSe = null)
    {
        // validation for constraint: string
        if (!is_null($lockIdToUSe) && !is_string($lockIdToUSe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lockIdToUSe, true), gettype($lockIdToUSe)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($lockIdToUSe) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $lockIdToUSe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($lockIdToUSe, true)), __LINE__);
        }
        if (is_null($lockIdToUSe) || (is_array($lockIdToUSe) && empty($lockIdToUSe))) {
            unset($this->LockIdToUSe);
        } else {
            $this->LockIdToUSe = $lockIdToUSe;
        }
        return $this;
    }
    /**
     * Get AllowSnakePath value
     * @return bool|null
     */
    public function getAllowSnakePath()
    {
        return $this->AllowSnakePath;
    }
    /**
     * Set AllowSnakePath value
     * @param bool $allowSnakePath
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setAllowSnakePath($allowSnakePath = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSnakePath) && !is_bool($allowSnakePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSnakePath, true), gettype($allowSnakePath)), __LINE__);
        }
        $this->AllowSnakePath = $allowSnakePath;
        return $this;
    }
    /**
     * Get AdvancedCatchInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAdvancedTicketCatchInfo|null
     */
    public function getAdvancedCatchInfo()
    {
        return isset($this->AdvancedCatchInfo) ? $this->AdvancedCatchInfo : null;
    }
    /**
     * Set AdvancedCatchInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAdvancedTicketCatchInfo $advancedCatchInfo
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setAdvancedCatchInfo(\patest\ArrayType\ArrayOfAdvancedTicketCatchInfo $advancedCatchInfo = null)
    {
        if (is_null($advancedCatchInfo) || (is_array($advancedCatchInfo) && empty($advancedCatchInfo))) {
            unset($this->AdvancedCatchInfo);
        } else {
            $this->AdvancedCatchInfo = $advancedCatchInfo;
        }
        return $this;
    }
    /**
     * Get DisallowNonContiguous value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisallowNonContiguous()
    {
        return isset($this->DisallowNonContiguous) ? $this->DisallowNonContiguous : null;
    }
    /**
     * Set DisallowNonContiguous value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $disallowNonContiguous
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setDisallowNonContiguous($disallowNonContiguous = null)
    {
        // validation for constraint: boolean
        if (!is_null($disallowNonContiguous) && !is_bool($disallowNonContiguous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disallowNonContiguous, true), gettype($disallowNonContiguous)), __LINE__);
        }
        if (is_null($disallowNonContiguous) || (is_array($disallowNonContiguous) && empty($disallowNonContiguous))) {
            unset($this->DisallowNonContiguous);
        } else {
            $this->DisallowNonContiguous = $disallowNonContiguous;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return $this->IsComplimentary;
    }
    /**
     * Set IsComplimentary value
     * @param bool $isComplimentary
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        $this->IsComplimentary = $isComplimentary;
        return $this;
    }
    /**
     * Get RequestPartId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestPartId()
    {
        return isset($this->RequestPartId) ? $this->RequestPartId : null;
    }
    /**
     * Set RequestPartId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestPartId
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setRequestPartId($requestPartId = null)
    {
        // validation for constraint: string
        if (!is_null($requestPartId) && !is_string($requestPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestPartId, true), gettype($requestPartId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestPartId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestPartId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestPartId, true)), __LINE__);
        }
        if (is_null($requestPartId) || (is_array($requestPartId) && empty($requestPartId))) {
            unset($this->RequestPartId);
        } else {
            $this->RequestPartId = $requestPartId;
        }
        return $this;
    }
    /**
     * Get MinSeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinSeatCount()
    {
        return isset($this->MinSeatCount) ? $this->MinSeatCount : null;
    }
    /**
     * Set MinSeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minSeatCount
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setMinSeatCount($minSeatCount = null)
    {
        // validation for constraint: int
        if (!is_null($minSeatCount) && !(is_int($minSeatCount) || ctype_digit($minSeatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minSeatCount, true), gettype($minSeatCount)), __LINE__);
        }
        if (is_null($minSeatCount) || (is_array($minSeatCount) && empty($minSeatCount))) {
            unset($this->MinSeatCount);
        } else {
            $this->MinSeatCount = $minSeatCount;
        }
        return $this;
    }
    /**
     * Get SkipGaAreas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipGaAreas()
    {
        return isset($this->SkipGaAreas) ? $this->SkipGaAreas : null;
    }
    /**
     * Set SkipGaAreas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipGaAreas
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setSkipGaAreas($skipGaAreas = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipGaAreas) && !is_bool($skipGaAreas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipGaAreas, true), gettype($skipGaAreas)), __LINE__);
        }
        if (is_null($skipGaAreas) || (is_array($skipGaAreas) && empty($skipGaAreas))) {
            unset($this->SkipGaAreas);
        } else {
            $this->SkipGaAreas = $skipGaAreas;
        }
        return $this;
    }
    /**
     * Get TreatAsSeparateClientSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getTreatAsSeparateClientSeats()
    {
        return isset($this->TreatAsSeparateClientSeats) ? $this->TreatAsSeparateClientSeats : null;
    }
    /**
     * Set TreatAsSeparateClientSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $treatAsSeparateClientSeats
     * @return \patest\StructType\CatchSeatRequest
     */
    public function setTreatAsSeparateClientSeats($treatAsSeparateClientSeats = null)
    {
        // validation for constraint: boolean
        if (!is_null($treatAsSeparateClientSeats) && !is_bool($treatAsSeparateClientSeats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($treatAsSeparateClientSeats, true), gettype($treatAsSeparateClientSeats)), __LINE__);
        }
        if (is_null($treatAsSeparateClientSeats) || (is_array($treatAsSeparateClientSeats) && empty($treatAsSeparateClientSeats))) {
            unset($this->TreatAsSeparateClientSeats);
        } else {
            $this->TreatAsSeparateClientSeats = $treatAsSeparateClientSeats;
        }
        return $this;
    }
}
