<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardInquiryRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CardInquiryRequest
 * @subpackage Structs
 */
class CardInquiryRequest extends ExtensibleDataContract
{
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $ProviderSpecificData;
    /**
     * Constructor method for CardInquiryRequest
     * @uses CardInquiryRequest::setCardNumber()
     * @uses CardInquiryRequest::setCardTypeId()
     * @uses CardInquiryRequest::setProviderSpecificData()
     * @param string $cardNumber
     * @param string $cardTypeId
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     */
    public function __construct($cardNumber = null, $cardTypeId = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null)
    {
        $this
            ->setCardNumber($cardNumber)
            ->setCardTypeId($cardTypeId)
            ->setProviderSpecificData($providerSpecificData);
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\CardInquiryRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardTypeId value
     * @return string|null
     */
    public function getCardTypeId()
    {
        return $this->CardTypeId;
    }
    /**
     * Set CardTypeId value
     * @param string $cardTypeId
     * @return \patest\StructType\CardInquiryRequest
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        $this->CardTypeId = $cardTypeId;
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData
     * @return \patest\StructType\CardInquiryRequest
     */
    public function setProviderSpecificData(\patest\ArrayType\ArrayOfKeyValueOfstringstring $providerSpecificData = null)
    {
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
}
