<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CardBalance StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CardBalance
 * @subpackage Structs
 */
class CardBalance extends AbstractStructBase
{
    /**
     * The AmountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountDue;
    /**
     * The AmountUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AmountUsed;
    /**
     * The Balance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Balance;
    /**
     * The PointBalance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PointBalance;
    /**
     * The ProgramKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProgramKey;
    /**
     * The Refund
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Refund;
    /**
     * Constructor method for CardBalance
     * @uses CardBalance::setAmountDue()
     * @uses CardBalance::setAmountUsed()
     * @uses CardBalance::setBalance()
     * @uses CardBalance::setPointBalance()
     * @uses CardBalance::setProgramKey()
     * @uses CardBalance::setRefund()
     * @param float $amountDue
     * @param float $amountUsed
     * @param float $balance
     * @param float $pointBalance
     * @param string $programKey
     * @param float $refund
     */
    public function __construct($amountDue = null, $amountUsed = null, $balance = null, $pointBalance = null, $programKey = null, $refund = null)
    {
        $this
            ->setAmountDue($amountDue)
            ->setAmountUsed($amountUsed)
            ->setBalance($balance)
            ->setPointBalance($pointBalance)
            ->setProgramKey($programKey)
            ->setRefund($refund);
    }
    /**
     * Get AmountDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountDue()
    {
        return isset($this->AmountDue) ? $this->AmountDue : null;
    }
    /**
     * Set AmountDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountDue
     * @return \patest\StructType\CardBalance
     */
    public function setAmountDue($amountDue = null)
    {
        // validation for constraint: float
        if (!is_null($amountDue) && !(is_float($amountDue) || is_numeric($amountDue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDue, true), gettype($amountDue)), __LINE__);
        }
        if (is_null($amountDue) || (is_array($amountDue) && empty($amountDue))) {
            unset($this->AmountDue);
        } else {
            $this->AmountDue = $amountDue;
        }
        return $this;
    }
    /**
     * Get AmountUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAmountUsed()
    {
        return isset($this->AmountUsed) ? $this->AmountUsed : null;
    }
    /**
     * Set AmountUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $amountUsed
     * @return \patest\StructType\CardBalance
     */
    public function setAmountUsed($amountUsed = null)
    {
        // validation for constraint: float
        if (!is_null($amountUsed) && !(is_float($amountUsed) || is_numeric($amountUsed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountUsed, true), gettype($amountUsed)), __LINE__);
        }
        if (is_null($amountUsed) || (is_array($amountUsed) && empty($amountUsed))) {
            unset($this->AmountUsed);
        } else {
            $this->AmountUsed = $amountUsed;
        }
        return $this;
    }
    /**
     * Get Balance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getBalance()
    {
        return isset($this->Balance) ? $this->Balance : null;
    }
    /**
     * Set Balance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $balance
     * @return \patest\StructType\CardBalance
     */
    public function setBalance($balance = null)
    {
        // validation for constraint: float
        if (!is_null($balance) && !(is_float($balance) || is_numeric($balance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($balance, true), gettype($balance)), __LINE__);
        }
        if (is_null($balance) || (is_array($balance) && empty($balance))) {
            unset($this->Balance);
        } else {
            $this->Balance = $balance;
        }
        return $this;
    }
    /**
     * Get PointBalance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPointBalance()
    {
        return isset($this->PointBalance) ? $this->PointBalance : null;
    }
    /**
     * Set PointBalance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pointBalance
     * @return \patest\StructType\CardBalance
     */
    public function setPointBalance($pointBalance = null)
    {
        // validation for constraint: float
        if (!is_null($pointBalance) && !(is_float($pointBalance) || is_numeric($pointBalance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointBalance, true), gettype($pointBalance)), __LINE__);
        }
        if (is_null($pointBalance) || (is_array($pointBalance) && empty($pointBalance))) {
            unset($this->PointBalance);
        } else {
            $this->PointBalance = $pointBalance;
        }
        return $this;
    }
    /**
     * Get ProgramKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgramKey()
    {
        return isset($this->ProgramKey) ? $this->ProgramKey : null;
    }
    /**
     * Set ProgramKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $programKey
     * @return \patest\StructType\CardBalance
     */
    public function setProgramKey($programKey = null)
    {
        // validation for constraint: string
        if (!is_null($programKey) && !is_string($programKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programKey, true), gettype($programKey)), __LINE__);
        }
        if (is_null($programKey) || (is_array($programKey) && empty($programKey))) {
            unset($this->ProgramKey);
        } else {
            $this->ProgramKey = $programKey;
        }
        return $this;
    }
    /**
     * Get Refund value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRefund()
    {
        return isset($this->Refund) ? $this->Refund : null;
    }
    /**
     * Set Refund value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $refund
     * @return \patest\StructType\CardBalance
     */
    public function setRefund($refund = null)
    {
        // validation for constraint: float
        if (!is_null($refund) && !(is_float($refund) || is_numeric($refund))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($refund, true), gettype($refund)), __LINE__);
        }
        if (is_null($refund) || (is_array($refund) && empty($refund))) {
            unset($this->Refund);
        } else {
            $this->Refund = $refund;
        }
        return $this;
    }
}
