<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * CancelResaleTransferTransactionsResponse_TicketExecutionResult-Response
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelResaleTransferTransactionsResponse_TicketExecutionResult-Response
 * @subpackage Structs
 */
class CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response extends AbstractStructBase
{
    /**
     * The CancelledTicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $CancelledTicketIds;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMsg;
    /**
     * The IsSuccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSuccess;
    /**
     * The RelatedTransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $RelatedTransactionIds;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for
     * CancelResaleTransferTransactionsResponse_TicketExecutionResult-Response
     * @uses CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response::setCancelledTicketIds()
     * @uses CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response::setErrorMsg()
     * @uses CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response::setIsSuccess()
     * @uses CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response::setRelatedTransactionIds()
     * @uses CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response::setTicketId()
     * @param \patest\ArrayType\ArrayOfguid $cancelledTicketIds
     * @param string $errorMsg
     * @param bool $isSuccess
     * @param \patest\ArrayType\ArrayOfguid $relatedTransactionIds
     * @param string $ticketId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $cancelledTicketIds = null, $errorMsg = null, $isSuccess = null, \patest\ArrayType\ArrayOfguid $relatedTransactionIds = null, $ticketId = null)
    {
        $this
            ->setCancelledTicketIds($cancelledTicketIds)
            ->setErrorMsg($errorMsg)
            ->setIsSuccess($isSuccess)
            ->setRelatedTransactionIds($relatedTransactionIds)
            ->setTicketId($ticketId);
    }
    /**
     * Get CancelledTicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getCancelledTicketIds()
    {
        return isset($this->CancelledTicketIds) ? $this->CancelledTicketIds : null;
    }
    /**
     * Set CancelledTicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $cancelledTicketIds
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response
     */
    public function setCancelledTicketIds(\patest\ArrayType\ArrayOfguid $cancelledTicketIds = null)
    {
        if (is_null($cancelledTicketIds) || (is_array($cancelledTicketIds) && empty($cancelledTicketIds))) {
            unset($this->CancelledTicketIds);
        } else {
            $this->CancelledTicketIds = $cancelledTicketIds;
        }
        return $this;
    }
    /**
     * Get ErrorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->ErrorMsg) ? $this->ErrorMsg : null;
    }
    /**
     * Set ErrorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->ErrorMsg);
        } else {
            $this->ErrorMsg = $errorMsg;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return $this->IsSuccess;
    }
    /**
     * Set IsSuccess value
     * @param bool $isSuccess
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccess, true), gettype($isSuccess)), __LINE__);
        }
        $this->IsSuccess = $isSuccess;
        return $this;
    }
    /**
     * Get RelatedTransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getRelatedTransactionIds()
    {
        return isset($this->RelatedTransactionIds) ? $this->RelatedTransactionIds : null;
    }
    /**
     * Set RelatedTransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $relatedTransactionIds
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response
     */
    public function setRelatedTransactionIds(\patest\ArrayType\ArrayOfguid $relatedTransactionIds = null)
    {
        if (is_null($relatedTransactionIds) || (is_array($relatedTransactionIds) && empty($relatedTransactionIds))) {
            unset($this->RelatedTransactionIds);
        } else {
            $this->RelatedTransactionIds = $relatedTransactionIds;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\CancelResaleTransferTransactionsResponse_TicketExecutionResult_Response
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
