<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CallSpRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CallSpRequest
 * @subpackage Structs
 */
class CallSpRequest extends AbstractStructBase
{
    /**
     * The SpName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpName;
    /**
     * The SpParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $SpParameters;
    /**
     * Constructor method for CallSpRequest
     * @uses CallSpRequest::setSpName()
     * @uses CallSpRequest::setSpParameters()
     * @param string $spName
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $spParameters
     */
    public function __construct($spName = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $spParameters = null)
    {
        $this
            ->setSpName($spName)
            ->setSpParameters($spParameters);
    }
    /**
     * Get SpName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpName()
    {
        return isset($this->SpName) ? $this->SpName : null;
    }
    /**
     * Set SpName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spName
     * @return \patest\StructType\CallSpRequest
     */
    public function setSpName($spName = null)
    {
        // validation for constraint: string
        if (!is_null($spName) && !is_string($spName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spName, true), gettype($spName)), __LINE__);
        }
        if (is_null($spName) || (is_array($spName) && empty($spName))) {
            unset($this->SpName);
        } else {
            $this->SpName = $spName;
        }
        return $this;
    }
    /**
     * Get SpParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getSpParameters()
    {
        return isset($this->SpParameters) ? $this->SpParameters : null;
    }
    /**
     * Set SpParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $spParameters
     * @return \patest\StructType\CallSpRequest
     */
    public function setSpParameters(\patest\ArrayType\ArrayOfKeyValueOfstringstring $spParameters = null)
    {
        if (is_null($spParameters) || (is_array($spParameters) && empty($spParameters))) {
            unset($this->SpParameters);
        } else {
            $this->SpParameters = $spParameters;
        }
        return $this;
    }
}
