<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculateDefaultInvoiceDueDateResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CalculateDefaultInvoiceDueDateResponse
 * @subpackage Structs
 */
class CalculateDefaultInvoiceDueDateResponse extends AbstractStructBase
{
    /**
     * The DefaultDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DefaultDueDate;
    /**
     * The PaymentTermsId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTermsId;
    /**
     * Constructor method for CalculateDefaultInvoiceDueDateResponse
     * @uses CalculateDefaultInvoiceDueDateResponse::setDefaultDueDate()
     * @uses CalculateDefaultInvoiceDueDateResponse::setPaymentTermsId()
     * @param string $defaultDueDate
     * @param string $paymentTermsId
     */
    public function __construct($defaultDueDate = null, $paymentTermsId = null)
    {
        $this
            ->setDefaultDueDate($defaultDueDate)
            ->setPaymentTermsId($paymentTermsId);
    }
    /**
     * Get DefaultDueDate value
     * @return string|null
     */
    public function getDefaultDueDate()
    {
        return $this->DefaultDueDate;
    }
    /**
     * Set DefaultDueDate value
     * @param string $defaultDueDate
     * @return \patest\StructType\CalculateDefaultInvoiceDueDateResponse
     */
    public function setDefaultDueDate($defaultDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($defaultDueDate) && !is_string($defaultDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultDueDate, true), gettype($defaultDueDate)), __LINE__);
        }
        $this->DefaultDueDate = $defaultDueDate;
        return $this;
    }
    /**
     * Get PaymentTermsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTermsId()
    {
        return isset($this->PaymentTermsId) ? $this->PaymentTermsId : null;
    }
    /**
     * Set PaymentTermsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTermsId
     * @return \patest\StructType\CalculateDefaultInvoiceDueDateResponse
     */
    public function setPaymentTermsId($paymentTermsId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsId) && !is_string($paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsId, true), gettype($paymentTermsId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTermsId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTermsId, true)), __LINE__);
        }
        if (is_null($paymentTermsId) || (is_array($paymentTermsId) && empty($paymentTermsId))) {
            unset($this->PaymentTermsId);
        } else {
            $this->PaymentTermsId = $paymentTermsId;
        }
        return $this;
    }
}
